/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.QueryModel.Internal;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jzkit.search.util.QueryModel.Internal.QueryNode;
import org.jzkit.search.util.QueryModel.Internal.TermValueBundle;

public class AttrPlusTermNode
extends QueryNode
implements Cloneable {
    public static final String ACCESS_POINT_ATTR = "AccessPoint";
    public static final String RELATION_ATTR = "Relation";
    public static final String POSITION_ATTR = "Position";
    public static final String STRUCTURE_ATTR = "Structure";
    public static final String TRUNCATION_ATTR = "Truncation";
    public static final String COMPLETENESS_ATTR = "Completeness";
    public static final String MULTI_TERM_OP = "MultiTermOp";
    private Object term;
    public static final int AND_TERMS = 0;
    public static final int OR_TERMS = 1;
    public static final int PASSTHRU_TERMS = 2;
    public static final int NONE = 3;
    private List terms = new ArrayList();
    private int default_multi_term_operator = 0;

    public AttrPlusTermNode() {
    }

    public AttrPlusTermNode(HashMap attrs, Object term, String name, int default_multi_term_operator) {
        this.attrs = attrs;
        this.term = term;
        this.default_multi_term_operator = default_multi_term_operator;
        if (name != null) {
            this.setNodeName(name);
        }
    }

    public Object clone() {
        return new AttrPlusTermNode((HashMap)this.attrs.clone(), this.term, this.getNodeName(), this.default_multi_term_operator);
    }

    public int countChildrenWithTerms() {
        if (this.term == null || this.term instanceof String && ((String)this.term).length() == 0 || this.term instanceof Object[] && ((Object[])this.term).length == 0 || this.term instanceof List && ((List)this.term).size() == 0) {
            return 0;
        }
        return 1;
    }

    public int countChildren() {
        return 0;
    }

    public void setTerm(Object term) {
        this.term = term;
    }

    public Object getTerm() {
        return this.term;
    }

    public int getDefaultMultiTermOperator() {
        String val = (String)this.attrs.get(MULTI_TERM_OP);
        int result = this.default_multi_term_operator;
        if (val != null) {
            if (val.equals("OR")) {
                result = 1;
            } else if (val.equals("AND")) {
                result = 0;
            } else if (val.equals("PASSTHRU")) {
                result = 2;
            } else if (val.equals("NONE")) {
                result = 3;
            }
        }
        return result;
    }

    public void clearAttrs() {
        this.attrs.clear();
    }

    public Iterator getAttrIterator() {
        return this.attrs.keySet().iterator();
    }

    public String toString() {
        String result = null;
        result = this.term != null ? (this.term instanceof String ? this.getNodeName() + " Single Term : " + this.term + " attrs : " + this.attrs : (this.term instanceof List ? this.getNodeName() + " Term List : " + (List)this.term + " attrs : " + this.attrs : (this.term instanceof Object[] ? this.getNodeName() + " Term List : " + (Object[])this.term + " attrs : " + this.attrs : this.getNodeName() + " Unknown Term Type : " + this.term.toString() + " attrs : " + this.attrs))) : this.getNodeName() + " No Term, attrs : " + this.attrs;
        return result;
    }

    public TermValueBundle getTermValueBundle(boolean quote_phrases) {
        TermValueBundle bundle = new TermValueBundle();
        String human_string = this.getTermAsString(quote_phrases);
        bundle.setStringValue(human_string);
        Iterator i = this.terms.iterator();
        while (i.hasNext()) {
            bundle.addValue((String)i.next());
        }
        return bundle;
    }

    public String getTermAsString(boolean quote_phrases) {
        this.terms.clear();
        String retval = null;
        if (this.term != null) {
            if (this.term instanceof List) {
                retval = "";
                List term_list = (List)this.term;
                int i = term_list.size();
                for (int j = 0; j < i; ++j) {
                    if (j > 0) {
                        retval = retval + ", ";
                    }
                    String this_term = (String)term_list.get(j);
                    if (quote_phrases) {
                        this_term = "\"" + this_term + "\"";
                    }
                    this.terms.add(this_term);
                    retval = retval + this_term;
                }
            } else if (this.term instanceof Object[]) {
                Object[] term_array = (Object[])this.term;
                StringWriter sw = new StringWriter();
                for (int j = 0; j < term_array.length; ++j) {
                    if (j > 0) {
                        sw.write(", ");
                    }
                    String this_term = term_array[j].toString();
                    if (quote_phrases) {
                        this_term = "\"" + this_term + "\"";
                    }
                    sw.write(this_term);
                    this.terms.add(this_term);
                }
                retval = sw.toString();
            } else {
                String term_string = this.term.toString();
                if (quote_phrases) {
                    term_string = "\"" + term_string + "\"";
                }
                this.terms.add(term_string);
                retval = term_string;
            }
        } else {
            retval = "";
        }
        return retval;
    }

    public void setAccessPoint(Object access_point) {
        this.attrs.put(ACCESS_POINT_ATTR, access_point);
    }

    public Object getAccessPoint() {
        return this.attrs.get(ACCESS_POINT_ATTR);
    }

    public void setRelation(Object relation) {
        this.attrs.put(RELATION_ATTR, relation);
    }

    public Object getRelation() {
        return this.attrs.get(RELATION_ATTR);
    }

    public void setPosition(Object position) {
        this.attrs.put(POSITION_ATTR, position);
    }

    public Object getPosition() {
        return this.attrs.get(POSITION_ATTR);
    }

    public void setStructure(Object structure) {
        this.attrs.put(STRUCTURE_ATTR, structure);
    }

    public Object getStructure() {
        return this.attrs.get(STRUCTURE_ATTR);
    }

    public void setTruncation(Object truncation) {
        this.attrs.put(TRUNCATION_ATTR, truncation);
    }

    public Object getTruncation() {
        return this.attrs.get(TRUNCATION_ATTR);
    }

    public void setCompleteness(Object completeness) {
        this.attrs.put(COMPLETENESS_ATTR, completeness);
    }

    public Object getCompleteness() {
        return this.attrs.get(COMPLETENESS_ATTR);
    }

    public void setMultiTermOp(Object multi_term_op) {
        this.attrs.put(MULTI_TERM_OP, multi_term_op);
    }

    public Object getMultiTermOp() {
        return this.attrs.get(MULTI_TERM_OP);
    }

    public Object getAttr(String attr_name) {
        return this.attrs.get(attr_name);
    }

    public void clearAllTerms() {
    }

    public void dump(StringWriter sw) {
        sw.write(this.toString());
    }

    public AttrPlusTermNode cloneForAttrs() {
        return new AttrPlusTermNode((HashMap)this.attrs.clone(), this.term, this.getNodeName(), this.default_multi_term_operator);
    }
}

