/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.thesaurus;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.kernel.KeywordBean;
import org.fao.geonet.kernel.Thesaurus;
import org.fao.geonet.kernel.ThesaurusManager;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.jdom.Content;
import org.jdom.Element;

public class AddElement
implements Service {
    public static final String PREFIX = "loc_";
    public static final String DEFINITION = "definition";
    public static final String PREF_LAB = "label";

    public static Map<Pair<String, String>, String> getLocalizedElements(Element params) {
        List children = params.getChildren();
        HashMap<Pair<String, String>, String> map = new HashMap<Pair<String, String>, String>();
        for (Element child : children) {
            if (!child.getName().startsWith(PREFIX)) continue;
            String[] parts = child.getName().split("_");
            String lang = parts[1];
            String type = parts[2];
            map.put((Pair<String, String>)Pair.read((Object)lang, (Object)type), child.getTextTrim());
        }
        return map;
    }

    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        String ref = Util.getParam((Element)params, (String)"ref");
        String namespace = Util.getParam((Element)params, (String)"namespace", (String)"");
        String newid = Util.getParam((Element)params, (String)"newid", null);
        if (newid == null) {
            newid = UUID.randomUUID().toString();
        }
        String thesaType = Util.getParam((Element)params, (String)"refType");
        Element elResp = new Element("response");
        ThesaurusManager manager = (ThesaurusManager)gc.getBean(ThesaurusManager.class);
        Thesaurus thesaurus = manager.getThesaurusByName(ref);
        if (thesaurus.isFreeCode(null, newid)) {
            KeywordBean keyword = new KeywordBean((IsoLanguagesMapper)context.getBean(IsoLanguagesMapper.class)).setNamespaceCode(namespace).setUriCode(newid);
            Map<Pair<String, String>, String> localizations = AddElement.getLocalizedElements(params);
            if (localizations.isEmpty()) {
                String prefLab = Util.getParam((Element)params, (String)PREF_LAB);
                String lang = Util.getParam((Element)params, (String)"lang");
                String string = Util.getParam((Element)params, (String)DEFINITION, (String)"");
                keyword.setValue(prefLab, lang).setDefinition(string, lang);
            } else {
                Set<Map.Entry<Pair<String, String>, String>> entries = localizations.entrySet();
                for (Map.Entry entry : entries) {
                    String lang = (String)((Pair)entry.getKey()).one();
                    if (((String)((Pair)entry.getKey()).two()).equals(DEFINITION)) {
                        String definition = (String)entry.getValue();
                        keyword.setDefinition(definition, lang);
                        continue;
                    }
                    if (((String)((Pair)entry.getKey()).two()).equals(PREF_LAB)) {
                        String label = (String)entry.getValue();
                        keyword.setValue(label, lang);
                        continue;
                    }
                    throw new IllegalArgumentException("Unknown localization type: " + (String)((Pair)entry.getKey()).two());
                }
            }
            if (thesaType.equals("place")) {
                String east = Util.getParam((Element)params, (String)"east");
                String west = Util.getParam((Element)params, (String)"west");
                String string = Util.getParam((Element)params, (String)"south");
                String north = Util.getParam((Element)params, (String)"north");
                keyword.setCoordEast(east).setCoordNorth(north).setCoordSouth(string).setCoordWest(west);
            }
            thesaurus.addElement(keyword);
            elResp.addContent((Content)new Element("selected").setText(ref));
            elResp.addContent((Content)new Element("mode").setText("edit"));
        } else {
            elResp.addContent((Content)new Element("error").setAttribute("message", String.format("Code value '%s' already exists in thesaurus", newid)));
        }
        return elResp;
    }
}

