/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.metadata.schema;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nonnull;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Util;
import org.fao.geonet.domain.SchematronCriteria;
import org.fao.geonet.domain.SchematronCriteriaGroup;
import org.fao.geonet.domain.SchematronCriteriaGroupId;
import org.fao.geonet.domain.SchematronCriteriaType;
import org.fao.geonet.domain.SchematronRequirement;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.repository.SchematronCriteriaGroupRepository;
import org.fao.geonet.repository.SchematronCriteriaRepository;
import org.fao.geonet.repository.Updater;
import org.fao.geonet.repository.specification.SchematronCriteriaSpecs;
import org.fao.geonet.services.metadata.schema.AbstractSchematronService;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;

public class SchematronCriteriaService
extends AbstractSchematronService {
    public static final String PARAM_GROUP_NAME = "groupName";
    public static final String PARAM_INCLUDE_GROUP = "includeGroup";
    public static final String PARAM_SCHEMATRON_ID = "schematronId";
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_VALUE = "value";
    public static final String PARAM_UI_TYPE = "uitype";
    public static final String PARAM_UI_VALUE = "uivalue";

    @Override
    protected Element add(Element params, ServiceContext context) throws Exception {
        String groupName = Util.getParam((Element)params, (String)PARAM_GROUP_NAME);
        int schematronId = Integer.parseInt(Util.getParam((Element)params, (String)PARAM_SCHEMATRON_ID));
        SchematronCriteriaGroupRepository criteriaGroupRepository = (SchematronCriteriaGroupRepository)context.getBean(SchematronCriteriaGroupRepository.class);
        SchematronCriteriaType type = SchematronCriteriaType.valueOf((String)Util.getParam((Element)params, (String)PARAM_TYPE));
        String value = Util.getParam((Element)params, (String)PARAM_VALUE, (String)"");
        String uitype = Util.getParam((Element)params, (String)PARAM_UI_TYPE);
        String uivalue = Util.getParam((Element)params, (String)PARAM_UI_VALUE, (String)"");
        SchematronCriteriaGroupId id = new SchematronCriteriaGroupId(groupName, schematronId);
        SchematronCriteriaGroup group = (SchematronCriteriaGroup)criteriaGroupRepository.findOne((Serializable)id);
        if (group == null) {
            group = new SchematronCriteriaGroup();
            group.setId(id);
            group.setRequirement(SchematronRequirement.REQUIRED);
        }
        SchematronCriteria criteria = new SchematronCriteria();
        criteria.setType(type);
        criteria.setValue(value);
        criteria.setUiType(uitype);
        criteria.setUiValue(uivalue);
        group.addCriteria(criteria);
        group = (SchematronCriteriaGroup)criteriaGroupRepository.saveAndFlush((Object)group);
        SchematronCriteria savedCriteria = (SchematronCriteria)group.getCriteria().get(group.getCriteria().size() - 1);
        Element result = new Element("response");
        result.addContent((Content)new Element("status").setText("success"));
        result.addContent((Content)new Element("id").setText("" + savedCriteria.getId()));
        result.addContent((Content)new Element("groupname").setText(group.getId().getName()));
        result.addContent((Content)new Element("schematronid").setText("" + group.getId().getSchematronId()));
        return result;
    }

    @Override
    protected Element list(Element params, ServiceContext context) throws Exception {
        Element element;
        String groupName = Util.getParam((Element)params, (String)PARAM_GROUP_NAME, null);
        String schematronId = Util.getParam((Element)params, (String)PARAM_SCHEMATRON_ID, null);
        boolean includeGroup = Util.getParam((Element)params, (String)PARAM_INCLUDE_GROUP, (boolean)false);
        String id = Util.getParam((Element)params, (String)"id", null);
        if (id != null && schematronId != null && groupName != null) {
            throw new IllegalArgumentException("Either one of id cannot be present if either groupName or schematronId are also present.");
        }
        SchematronCriteriaRepository criteriaRepository = (SchematronCriteriaRepository)context.getBean(SchematronCriteriaRepository.class);
        if (id == null) {
            Specifications spec = null;
            if (schematronId != null) {
                spec = Specifications.where((Specification)SchematronCriteriaSpecs.hasSchematronId((int)Integer.parseInt(schematronId)));
            }
            if (groupName != null) {
                Specification hasGroupSpec = SchematronCriteriaSpecs.hasGroupName((String)groupName);
                spec = spec == null ? Specifications.where((Specification)hasGroupSpec) : spec.and(hasGroupSpec);
            }
            element = criteriaRepository.findAllAsXml((Specification)spec);
        } else {
            SchematronCriteria criteria = (SchematronCriteria)criteriaRepository.findOne((Serializable)Integer.valueOf(Integer.parseInt(id)));
            if (criteria == null) {
                throw new BadParameterEx("id", (Object)id);
            }
            element = new Element("response").addContent((Content)criteria.asXml());
        }
        List criteriaRecords = element.getChildren();
        if (!includeGroup) {
            for (Element criteriaRecord : criteriaRecords) {
                Element groupEl = criteriaRecord.getChild("group");
                Element idEl = groupEl.getChild("id");
                idEl.detach();
                groupEl.setContent((Content)idEl);
            }
        } else {
            for (Element criteriaRecord : criteriaRecords) {
                List groups = criteriaRecord.getChildren("group");
                for (Element group : groups) {
                    group.removeChild("criteria");
                    group.removeChild("schematron");
                }
            }
        }
        return element;
    }

    @Override
    protected boolean exists(Element params, ServiceContext context) throws Exception {
        Integer id = Integer.valueOf(Util.getParam((Element)params, (String)"id"));
        return ((SchematronCriteriaRepository)context.getBean(SchematronCriteriaRepository.class)).exists((Serializable)id);
    }

    @Override
    protected Element edit(Element params, ServiceContext context) throws Exception {
        int id = Integer.parseInt(Util.getParam((Element)params, (String)"id"));
        final String type = Util.getParam((Element)params, (String)PARAM_TYPE, null);
        final String value = Util.getParam((Element)params, (String)PARAM_VALUE, null);
        final String uiType = Util.getParam((Element)params, (String)PARAM_UI_TYPE, null);
        final String uiValue = Util.getParam((Element)params, (String)PARAM_UI_VALUE, null);
        SchematronCriteriaRepository criteriaRepository = (SchematronCriteriaRepository)context.getBean(SchematronCriteriaRepository.class);
        criteriaRepository.update((Serializable)Integer.valueOf(id), (Updater)new Updater<SchematronCriteria>(){

            public void apply(@Nonnull SchematronCriteria entity) {
                if (type != null) {
                    entity.setType(SchematronCriteriaType.valueOf((String)type.toUpperCase()));
                }
                if (value != null) {
                    entity.setValue(value);
                }
                if (uiType != null) {
                    entity.setUiType(uiType);
                }
                if (uiValue != null) {
                    entity.setUiValue(uiValue);
                }
            }
        });
        return new Element("ok");
    }

    @Override
    protected Element delete(Element params, ServiceContext context) throws Exception {
        Integer id = Integer.valueOf(Util.getParam((Element)params, (String)"id"));
        SchematronCriteriaRepository criteriaRepository = (SchematronCriteriaRepository)context.getBean(SchematronCriteriaRepository.class);
        if (criteriaRepository.exists((Serializable)id)) {
            criteriaRepository.delete((Serializable)id);
            if (!criteriaRepository.exists((Serializable)id)) {
                return new Element("ok");
            }
            throw new IOException("Error deleting criteria object");
        }
        throw new BadParameterEx("id", (Object)id);
    }
}

