/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.ServiceManager;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.records.MetadataUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.OperationAllowed;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.exceptions.ServiceNotAllowedEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SelectionManager;
import org.fao.geonet.kernel.datamanager.IMetadataStatus;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.datamanager.IMetadataValidator;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.MetadataValidationRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.specification.OperationAllowedSpecs;
import org.fao.geonet.services.metadata.BatchOpsMetadataReindexer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Deprecated
@Controller(value="md.publish")
public class Publish {
    @VisibleForTesting
    boolean testing = false;

    @RequestMapping(value={"/{portal}/{lang}/md.publish"}, produces={"application/json", "application/xml"})
    @ResponseBody
    public PublishReport publish(@PathVariable String lang, HttpServletRequest request, @RequestParam(value="ids", required=false) String commaSeparatedIds, @RequestParam(value="skipIntranet", defaultValue="false") boolean skipIntranet) throws Exception {
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        ServiceManager serviceManager = (ServiceManager)appContext.getBean(ServiceManager.class);
        ServiceContext serviceContext = serviceManager.createServiceContext("md.publish", lang, request);
        return this.exec(commaSeparatedIds, true, skipIntranet, serviceContext);
    }

    @RequestMapping(value={"/{portal}/{lang}/md.unpublish"}, produces={"application/json", "application/xml"})
    @ResponseBody
    public PublishReport unpublish(@PathVariable String lang, HttpServletRequest request, @RequestParam(value="ids", required=false) String commaSeparatedIds, @RequestParam(value="skipIntranet", defaultValue="false") boolean skipIntranet) throws Exception {
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        ServiceManager serviceManager = (ServiceManager)appContext.getBean(ServiceManager.class);
        ServiceContext serviceContext = serviceManager.createServiceContext("md.publish", lang, request);
        return this.exec(commaSeparatedIds, false, skipIntranet, serviceContext);
    }

    private PublishReport exec(String commaSeparatedIds, boolean publish, boolean skipIntranet, ServiceContext serviceContext) throws Exception {
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        DataManager dataManager = (DataManager)appContext.getBean(DataManager.class);
        OperationAllowedRepository operationAllowedRepository = (OperationAllowedRepository)appContext.getBean(OperationAllowedRepository.class);
        IMetadataUtils metadataRepository = (IMetadataUtils)appContext.getBean(IMetadataUtils.class);
        MetadataValidationRepository metadataValidationRepository = (MetadataValidationRepository)appContext.getBean(MetadataValidationRepository.class);
        IMetadataStatus metadataStatusRepository = (IMetadataStatus)appContext.getBean(IMetadataStatus.class);
        SettingManager sm = (SettingManager)appContext.getBean(SettingManager.class);
        IMetadataValidator validator = (IMetadataValidator)appContext.getBean(IMetadataValidator.class);
        GroupRepository groupRepository = (GroupRepository)appContext.getBean(GroupRepository.class);
        boolean allowPublishInvalidMd = sm.getValueAsBool("metadata/workflow/allowPublishInvalidMd");
        boolean allowPublishNonApprovedMd = sm.getValueAsBool("metadata/workflow/allowPublishNonApprovedMd");
        PublishReport report = new PublishReport();
        Iterator<String> iter = this.getIds(appContext, serviceContext.getUserSession(), commaSeparatedIds);
        ArrayList groupIds = Lists.newArrayList((Object[])new Integer[]{ReservedGroup.all.getId()});
        if (!skipIntranet) {
            groupIds.add(ReservedGroup.intranet.getId());
        }
        HashSet toIndex = Sets.newHashSet();
        Specification hasGroupIdIn = OperationAllowedSpecs.hasGroupIdIn((Collection)groupIds);
        ArrayList operationIds = Lists.newArrayList((Object[])new Integer[]{ReservedOperation.download.getId(), ReservedOperation.view.getId(), ReservedOperation.dynamic.getId(), ReservedOperation.featured.getId(), ReservedOperation.notify.getId()});
        Specification hasOperationIdIn = OperationAllowedSpecs.hasOperationIdIn((Collection)operationIds);
        while (iter.hasNext()) {
            String nextId = iter.next();
            if (nextId == null) continue;
            int mdId = Integer.parseInt(nextId);
            Specifications allOpsSpec = Specifications.where((Specification)OperationAllowedSpecs.hasMetadataId((String)nextId)).and(hasGroupIdIn).and(hasOperationIdIn);
            List operationAllowed = operationAllowedRepository.findAll((Specification)allOpsSpec);
            if (publish) {
                MetadataStatus metadataStatus;
                String statusId;
                boolean isInvalid;
                AbstractMetadata metadata = metadataRepository.findOne(mdId);
                if (!allowPublishInvalidMd && (isInvalid = MetadataUtils.retrieveMetadataValidationStatus(metadata, serviceContext))) {
                    report.incNoValid();
                    continue;
                }
                if (!allowPublishNonApprovedMd && !(statusId = (metadataStatus = metadataStatusRepository.getStatus(metadata.getId())).getId().getStatusId() + "").equals("2")) {
                    report.incNoApproved();
                    continue;
                }
                this.doPublish(serviceContext, report, groupIds, toIndex, operationIds, mdId, (Specifications<OperationAllowed>)allOpsSpec, operationAllowed);
                continue;
            }
            this.doUnpublish(serviceContext, report, groupIds, toIndex, operationIds, mdId, (Specifications<OperationAllowed>)allOpsSpec, operationAllowed);
        }
        BatchOpsMetadataReindexer r = new BatchOpsMetadataReindexer(dataManager, toIndex);
        r.process(this.testing || toIndex.size() < 5);
        return report;
    }

    private Iterator<String> getIds(ConfigurableApplicationContext appContext, UserSession userSession, final String commaSeparatedIds) {
        final DataManager dataManager = (DataManager)appContext.getBean(DataManager.class);
        if (commaSeparatedIds == null) {
            if (userSession != null) {
                SelectionManager sm = SelectionManager.getManager((UserSession)userSession);
                Iterator selectionIter = sm.getSelection("metadata").iterator();
                return Iterators.transform(selectionIter, (Function)new Function<String, String>(){

                    @Nullable
                    public String apply(String uuid) {
                        try {
                            return dataManager.getMetadataId(uuid);
                        }
                        catch (Exception e) {
                            return null;
                        }
                    }
                });
            }
            return Iterators.emptyIterator();
        }
        return new Iterator<String>(){
            final StringTokenizer tokenizer;
            {
                this.tokenizer = new StringTokenizer(commaSeparatedIds, ",", false);
            }

            @Override
            public boolean hasNext() {
                return this.tokenizer.hasMoreElements();
            }

            @Override
            public String next() {
                return this.tokenizer.nextToken();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void doUnpublish(ServiceContext serviceContext, PublishReport report, ArrayList<Integer> groupIds, Set<Integer> toIndex, Collection<Integer> operationIds, int mdId, Specifications<OperationAllowed> allOpsSpec, List<OperationAllowed> operationAllowed) throws Exception {
        OperationAllowedRepository operationAllowedRepository = (OperationAllowedRepository)serviceContext.getBean(OperationAllowedRepository.class);
        long count = operationAllowedRepository.count(allOpsSpec);
        if (count == 0L) {
            report.incUnmodified();
        } else {
            boolean succeeded = this.updateOps(serviceContext, false, groupIds, operationIds, mdId);
            if (!succeeded) {
                operationAllowedRepository.deleteAll(allOpsSpec);
                operationAllowedRepository.save(operationAllowed);
                report.incDisallowed();
            } else {
                report.incUnpublished();
                toIndex.add(mdId);
            }
        }
    }

    private void doPublish(ServiceContext serviceContext, PublishReport report, ArrayList<Integer> groupIds, Set<Integer> toIndex, Collection<Integer> operationIds, int mdId, Specifications<OperationAllowed> allOpsSpec, List<OperationAllowed> operationAllowed) throws Exception {
        OperationAllowedRepository operationAllowedRepository = (OperationAllowedRepository)serviceContext.getBean(OperationAllowedRepository.class);
        long count = operationAllowedRepository.count((Specification)Specifications.where((Specification)OperationAllowedSpecs.hasMetadataId((int)mdId)).and(OperationAllowedSpecs.isPublic((ReservedOperation)ReservedOperation.view)));
        if (count == 1L) {
            report.incUnmodified();
        } else {
            boolean succeeded = this.updateOps(serviceContext, true, groupIds, operationIds, mdId);
            if (!succeeded) {
                operationAllowedRepository.deleteAll(allOpsSpec);
                operationAllowedRepository.save(operationAllowed);
                report.incDisallowed();
            } else {
                toIndex.add(mdId);
                report.incPublished();
            }
        }
    }

    private boolean updateOps(ServiceContext serviceContext, boolean publish, ArrayList<Integer> groupIds, Collection<Integer> operationIds, int metadataId) throws Exception {
        DataManager dataManager = (DataManager)serviceContext.getBean(DataManager.class);
        for (Integer groupId : groupIds) {
            for (Integer operationId : operationIds) {
                try {
                    if (publish) {
                        dataManager.setOperation(serviceContext, metadataId, groupId.intValue(), operationId.intValue());
                        continue;
                    }
                    dataManager.unsetOperation(serviceContext, metadataId, groupId.intValue(), operationId.intValue());
                }
                catch (ServiceNotAllowedEx e) {
                    return false;
                }
            }
        }
        return true;
    }

    @XmlRootElement(name="publishReport")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static final class PublishReport
    implements Serializable {
        private int published;
        private int unpublished;
        private int unmodified;
        private int disallowed;
        private int novalid;
        private int noapproved;

        public void incPublished() {
            ++this.published;
        }

        public void incUnpublished() {
            ++this.unpublished;
        }

        public void incUnmodified() {
            ++this.unmodified;
        }

        public void incDisallowed() {
            ++this.disallowed;
        }

        public void incNoValid() {
            ++this.novalid;
        }

        public void incNoApproved() {
            ++this.noapproved;
        }

        public int getPublished() {
            return this.published;
        }

        public int getUnpublished() {
            return this.unpublished;
        }

        public int getUnmodified() {
            return this.unmodified;
        }

        public int getDisallowed() {
            return this.disallowed;
        }

        public int getNovalid() {
            return this.novalid;
        }

        public int getNoapproved() {
            return this.noapproved;
        }

        public String toString() {
            return "PublishReport{published=" + this.published + ", unpublished=" + this.unpublished + ", unmodified=" + this.unmodified + ", disallowed=" + this.disallowed + ", novalid=" + this.novalid + ", noapproved=" + this.noapproved + '}';
        }
    }
}

