/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.processing;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayDeque;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.management.MalformedObjectNameException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.processing.EmptySlotBatch;
import org.fao.geonet.api.processing.MInspireEtfValidateProcess;
import org.fao.geonet.api.processing.report.SimpleMetadataProcessingReport;
import org.fao.geonet.api.processing.report.registry.IProcessingReportRegistry;
import org.fao.geonet.api.records.editing.InspireValidatorUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.events.history.RecordValidationTriggeredEvent;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.datamanager.IMetadataValidator;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.MetadataValidationRepository;
import org.fao.geonet.services.metadata.BatchOpsMetadataReindexer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.jmx.export.naming.SelfNaming;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api/records", "/{portal}/api/0.1/records"})
@Api(value="records", tags={"records"}, description="Metadata record operations")
@Controller(value="processValidate")
public class ValidateApi {
    private static final int NUMBER_OF_SUBSEQUENT_PROCESS_MBEAN_TO_KEEP = 1;
    @Autowired
    IProcessingReportRegistry registry;
    @Autowired
    IMetadataValidator validator;
    @Autowired
    AccessManager accessMan;
    @Autowired
    DataManager dataMan;
    @Autowired
    IMetadataUtils metadataRepository;
    @Autowired
    InspireValidatorUtils inspireValidatorUtils;
    @Autowired
    SchemaManager schemaManager;
    @Autowired
    SettingManager settingManager;
    @Autowired
    MetadataValidationRepository metadataValidationRepository;
    @Autowired
    IMetadataUtils metadataUtils;
    @Autowired
    protected ApplicationContext appContext;
    @Autowired
    MBeanExporter mBeanExporter;
    private ArrayDeque<SelfNaming> mAnalyseProcesses = new ArrayDeque(1);

    @PostConstruct
    public void iniMBeansSlidingWindowWithEmptySlot() {
        for (int i = 0; i < 1; ++i) {
            EmptySlotBatch emptySlot = new EmptySlotBatch("batch-etf-inspire", i);
            this.mAnalyseProcesses.addFirst(emptySlot);
            try {
                this.mBeanExporter.registerManagedResource((Object)emptySlot, emptySlot.getObjectName());
                continue;
            }
            catch (MalformedObjectNameException e) {
                e.printStackTrace();
            }
        }
    }

    @ApiOperation(value="Validate one or more records", nickname="validateRecords", notes="Update validation status for all records.")
    @RequestMapping(value={"/validate"}, method={RequestMethod.PUT}, produces={"application/json"})
    @PreAuthorize(value="hasRole('Editor')")
    @ApiResponses(value={@ApiResponse(code=201, message="Records validated."), @ApiResponse(code=403, message="Operation not allowed. Only Editors can access it.")})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public SimpleMetadataProcessingReport validateRecords(@ApiParam(value="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @ApiParam(value="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="") Boolean approved, @ApiParam(value="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @ApiIgnore HttpSession session, @ApiIgnore HttpServletRequest request) throws Exception {
        UserSession userSession = ApiUtils.getUserSession(session);
        try (SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();){
            ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
            ServiceContext serviceContext = ApiUtils.createServiceContext(request);
            Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, userSession);
            report.setTotalRecords(records.size());
            for (String uuid : records) {
                int loopConditionCount = 0;
                for (AbstractMetadata record : this.metadataRepository.findAllByUuid(uuid)) {
                    Boolean isMetadataApproved = this.metadataUtils.isMetadataApproved(record.getId());
                    if (approved != null && (!approved.booleanValue() || !isMetadataApproved.booleanValue()) && (approved.booleanValue() || isMetadataApproved.booleanValue())) continue;
                    if (++loopConditionCount > 1) {
                        report.setTotalRecords(report.getNumberOfRecords() + 1);
                    }
                    if (!this.accessMan.canEdit(serviceContext, String.valueOf(record.getId()))) {
                        report.addNotEditableMetadataId(record.getId());
                        continue;
                    }
                    boolean isValid = this.validator.doValidate(record, serviceContext.getLanguage());
                    if (isValid) {
                        report.addMetadataInfos(record, "Is valid");
                        new RecordValidationTriggeredEvent(Integer.valueOf(record.getId()), Integer.valueOf(ApiUtils.getUserSession(request.getSession()).getUserIdAsInt()), "1").publish((ApplicationContext)applicationContext);
                    } else {
                        report.addMetadataError(record, "Is invalid");
                        new RecordValidationTriggeredEvent(Integer.valueOf(record.getId()), Integer.valueOf(ApiUtils.getUserSession(request.getSession()).getUserIdAsInt()), "0").publish((ApplicationContext)applicationContext);
                    }
                    report.addMetadataId(record.getId());
                    report.incrementProcessedRecords();
                }
                if (loopConditionCount != 0) continue;
                report.incrementNullRecords();
            }
            BatchOpsMetadataReindexer r = new BatchOpsMetadataReindexer(this.dataMan, report.getMetadata());
            r.process(true);
        }
        return report;
    }

    @ApiOperation(value="Validate one or more records in INSPIRE validator", nickname="validateRecordsInspire", notes="Update validation status for all records.")
    @RequestMapping(value={"/validate/inspire"}, method={RequestMethod.PUT}, produces={"application/json"})
    @PreAuthorize(value="hasRole('Editor')")
    @ApiResponses(value={@ApiResponse(code=201, message="Records validated."), @ApiResponse(code=403, message="Operation not allowed. Only Editors can access it.")})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public ResponseEntity validateRecordsInspire(@ApiParam(value="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @ApiParam(value="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @ApiIgnore HttpSession session, @ApiIgnore HttpServletRequest request) throws Exception {
        ServiceContext serviceContext = ApiUtils.createServiceContext(request);
        MInspireEtfValidateProcess registredMAnalyseProcess = this.getRegistredMInspireEtfValidateProcess(serviceContext);
        registredMAnalyseProcess.deleteAll();
        UserSession userSession = ApiUtils.getUserSession(session);
        Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, userSession);
        registredMAnalyseProcess.processMetadata(records);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    private MInspireEtfValidateProcess getRegistredMInspireEtfValidateProcess(ServiceContext serviceContext) {
        String URL2 = this.settingManager.getValue("system/inspire/remotevalidation/url");
        MInspireEtfValidateProcess mAnalyseProcess = new MInspireEtfValidateProcess(URL2, serviceContext, this.appContext);
        this.mBeanExporter.registerManagedResource((Object)mAnalyseProcess, mAnalyseProcess.getObjectName());
        try {
            this.mBeanExporter.unregisterManagedResource(this.mAnalyseProcesses.removeLast().getObjectName());
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        this.mAnalyseProcesses.addFirst(mAnalyseProcess);
        return mAnalyseProcess;
    }
}

