/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api;

import com.google.common.collect.Sets;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.ServiceManager;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.SelectionManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.XmlRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.util.StringUtils;

public class ApiUtils {
    @Autowired
    static LanguageUtils languageUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getUuidsParameterOrSelection(String[] uuids, String bucket, UserSession session) {
        HashSet setOfUuidsToEdit;
        if (uuids == null) {
            if (bucket == null) {
                bucket = "metadata";
            }
            SelectionManager selectionManager = SelectionManager.getManager((UserSession)session);
            Set set = selectionManager.getSelection(bucket);
            synchronized (set) {
                Set selection = selectionManager.getSelection(bucket);
                setOfUuidsToEdit = Sets.newHashSet((Iterable)selection);
            }
        } else {
            setOfUuidsToEdit = Sets.newHashSet(Arrays.asList(uuids));
        }
        if (setOfUuidsToEdit.size() == 0) {
            throw new IllegalArgumentException("At least one record should be defined or selected for analysis.");
        }
        return setOfUuidsToEdit;
    }

    public static String getInternalId(String uuidOrInternalId, Boolean approved) throws Exception {
        IMetadataUtils metadataUtils = (IMetadataUtils)ApplicationContextHolder.get().getBean(IMetadataUtils.class);
        String id = String.valueOf(metadataUtils.findOneByUuid(uuidOrInternalId).getId());
        if (StringUtils.isEmpty((Object)id)) {
            id = String.valueOf(metadataUtils.findOne(uuidOrInternalId).getId());
        } else if (approved.booleanValue()) {
            id = String.valueOf(((MetadataRepository)ApplicationContextHolder.get().getBean(MetadataRepository.class)).findOneByUuid(uuidOrInternalId).getId());
        }
        if (StringUtils.isEmpty((Object)id)) {
            throw new ResourceNotFoundException(String.format("Record with UUID '%s' not found in this catalog", uuidOrInternalId));
        }
        return id;
    }

    public static String fixURIFragment(String uri) throws UnsupportedEncodingException {
        CharSequence[] parts = uri.split("#");
        if (parts.length > 1) {
            parts[parts.length - 1] = ((String)parts[parts.length - 1]).replace("+", " ");
            parts[parts.length - 1] = URLEncoder.encode((String)parts[parts.length - 1], "UTF-8");
            parts[parts.length - 1] = ((String)parts[parts.length - 1]).replace("+", "%20");
            parts[parts.length - 1] = ((String)parts[parts.length - 1]).replace("%3A", ":");
        }
        return String.join((CharSequence)"#", parts);
    }

    public static AbstractMetadata getRecord(String uuidOrInternalId) throws ResourceNotFoundException {
        IMetadataUtils metadataRepository = (IMetadataUtils)ApplicationContextHolder.get().getBean(IMetadataUtils.class);
        AbstractMetadata metadata = null;
        try {
            metadata = metadataRepository.findOneByUuid(uuidOrInternalId);
            if (metadata != null) {
                Log.trace((String)"geonetwork.datamanager", (Object)("ApiUtils.getRecord(" + uuidOrInternalId + ") -> " + metadata));
                return metadata;
            }
        }
        catch (IncorrectResultSizeDataAccessException e) {
            Log.warning((String)"geonetwork", (Object)String.format("More than one record found with UUID '%s'. Error is '%s'.", uuidOrInternalId, e.getMessage()));
        }
        try {
            Log.trace((String)"geonetwork.datamanager", (Object)(uuidOrInternalId + " not recognized as UUID. Trying ID."));
            metadata = metadataRepository.findOne(uuidOrInternalId);
            if (metadata != null) {
                Log.trace((String)"geonetwork.datamanager", (Object)("ApiUtils.getRecord(" + uuidOrInternalId + ") -> " + metadata));
                return metadata;
            }
        }
        catch (InvalidDataAccessApiUsageException invalidDataAccessApiUsageException) {
            // empty catch block
        }
        Log.trace((String)"geonetwork.datamanager", (Object)("Record identified by " + uuidOrInternalId + " not found."));
        throw new ResourceNotFoundException(String.format("Record with UUID '%s' not found in this catalog", uuidOrInternalId));
    }

    public static UserSession getUserSession(HttpSession httpSession) {
        if (httpSession == null) {
            throw new SecurityException("The service requested is not available for crawlers. HTTP session is not activated for bots.");
        }
        UserSession userSession = (UserSession)httpSession.getAttribute("session");
        if (userSession == null) {
            throw new SecurityException("The service requested is not available for crawlers. Catalog session is null.");
        }
        return userSession;
    }

    public static ServiceContext createServiceContext(HttpServletRequest request) {
        String iso3langCode = ((LanguageUtils)ApplicationContextHolder.get().getBean(LanguageUtils.class)).getIso3langCode(request.getLocales());
        return ApiUtils.createServiceContext(request, iso3langCode);
    }

    public static ServiceContext createServiceContext(HttpServletRequest request, String iso3langCode) {
        ServiceManager serviceManager = (ServiceManager)ApplicationContextHolder.get().getBean(ServiceManager.class);
        ServiceContext serviceContext = serviceManager.createServiceContext("Api", iso3langCode, request);
        serviceContext.setAsThreadLocal();
        return serviceContext;
    }

    public static long sizeOfDirectory(Path lDir) throws IOException {
        final long[] size = new long[]{0L};
        Files.walkFileTree(lDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                size[0] = size[0] + Files.size(file);
                return FileVisitResult.CONTINUE;
            }
        });
        return size[0] / 1024L;
    }

    public static Path downloadUrlInTemp(String url) throws IOException, URISyntaxException {
        URI uri = new URI(url);
        Path file = Files.createTempFile("file-from-url", ".xml", new FileAttribute[0]);
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        XmlRequest httpReq = ((GeonetHttpRequestFactory)applicationContext.getBean(GeonetHttpRequestFactory.class)).createXmlRequest(uri.toURL());
        httpReq.setAddress(uri.getPath());
        Lib.net.setupProxy((SettingManager)applicationContext.getBean(SettingManager.class), httpReq);
        httpReq.executeLarge(file);
        return file;
    }

    public static AbstractMetadata canEditRecord(String metadataUuid, HttpServletRequest request) throws Exception {
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        AbstractMetadata metadata = ApiUtils.getRecord(metadataUuid);
        AccessManager accessManager = (AccessManager)appContext.getBean(AccessManager.class);
        if (!accessManager.canEdit(ApiUtils.createServiceContext(request), String.valueOf(metadata.getId()))) {
            throw new SecurityException(String.format("You can't edit record with UUID %s", metadataUuid));
        }
        return metadata;
    }

    public static AbstractMetadata canReviewRecord(String metadataUuid, HttpServletRequest request) throws Exception {
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        AbstractMetadata metadata = ApiUtils.getRecord(metadataUuid);
        AccessManager accessManager = (AccessManager)appContext.getBean(AccessManager.class);
        if (!accessManager.canReview(ApiUtils.createServiceContext(request), String.valueOf(metadata.getId()))) {
            throw new SecurityException(String.format("You can't review or edit record with UUID %s", metadataUuid));
        }
        return metadata;
    }

    public static AbstractMetadata canChangeStatusRecord(String metadataUuid, HttpServletRequest request) throws Exception {
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        AbstractMetadata metadata = ApiUtils.getRecord(metadataUuid);
        AccessManager accessManager = (AccessManager)appContext.getBean(AccessManager.class);
        if (!accessManager.canChangeStatus(ApiUtils.createServiceContext(request), String.valueOf(metadata.getId()))) {
            throw new SecurityException(String.format("You can't change status of record with UUID %s", metadataUuid));
        }
        return metadata;
    }

    public static AbstractMetadata canViewRecord(String metadataUuid, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.getRecord(metadataUuid);
        try {
            Lib.resource.checkPrivilege(ApiUtils.createServiceContext(request), String.valueOf(metadata.getId()), ReservedOperation.view);
        }
        catch (Exception e) {
            throw new SecurityException(String.format("You can't view record with UUID %s", metadataUuid));
        }
        return metadata;
    }

    public static void createFavicon(Image img, Path outFile) throws IOException {
        int width = 32;
        int height = 32;
        String type = "png";
        Image thumb = img.getScaledInstance(width, height, 4);
        BufferedImage bimg = new BufferedImage(width, height, 3);
        Graphics2D g = bimg.createGraphics();
        g.drawImage(thumb, 0, 0, null);
        g.dispose();
        try (OutputStream out = Files.newOutputStream(outFile, new OpenOption[0]);){
            ImageIO.write((RenderedImage)bimg, type, out);
        }
    }
}

