/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain.userfeedback;

import java.io.Serializable;
import java.util.Map;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Cacheable;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.fao.geonet.domain.Localized;
import org.fao.geonet.domain.converter.BooleanToYNConverter;
import org.fao.geonet.entitylistener.RatingCriteriaEntityListenerManager;

@Entity
@Table(name="GUF_RatingCriteria")
@Cacheable
@Access(value=AccessType.PROPERTY)
@EntityListeners(value={RatingCriteriaEntityListenerManager.class})
@SequenceGenerator(name="rating_criteria_id_seq", initialValue=100, allocationSize=1)
public class RatingCriteria
extends Localized
implements Serializable {
    static final String ID_SEQ_NAME = "rating_criteria_id_seq";
    public static final Integer AVERAGE_ID = -1;
    private int _id;
    private String _name;
    private Boolean _isInternal;

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="rating_criteria_id_seq")
    @Column(nullable=false)
    public int getId() {
        return this._id;
    }

    public RatingCriteria setId(int id) {
        this._id = id;
        return this;
    }

    @Column(nullable=false, length=32)
    public String getName() {
        return this._name;
    }

    public RatingCriteria setName(String name) {
        this._name = name;
        return this;
    }

    @Column(name="isinternal", nullable=false, length=1, columnDefinition="CHAR(1) DEFAULT 'y'")
    @Convert(converter=BooleanToYNConverter.class)
    public boolean isInternal() {
        if (this._isInternal == null) {
            this._isInternal = true;
        }
        return this._isInternal;
    }

    public RatingCriteria setInternal(Boolean isInternal) {
        this._isInternal = isInternal;
        return this;
    }

    @Override
    @ElementCollection(fetch=FetchType.LAZY, targetClass=String.class)
    @CollectionTable(joinColumns={@JoinColumn(name="idDes")}, name="GUF_RatingCriteriaDes")
    @MapKeyColumn(name="langId", length=5)
    @Column(name="label", nullable=false, length=2000)
    public Map<String, String> getLabelTranslations() {
        return super.getLabelTranslations();
    }

    public String toString() {
        return "rating criteria [_id=" + this._id + ", _name=" + this._name + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RatingCriteria other = (RatingCriteria)obj;
        return this._id == other._id;
    }
}

