/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.entitylistener.HarvesterSettingEntityListenerManager;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.Type;

@Entity
@Table(name="HarvesterSettings")
@Access(value=AccessType.PROPERTY)
@EntityListeners(value={HarvesterSettingEntityListenerManager.class})
@SequenceGenerator(name="harvester_setting_id_seq", initialValue=100, allocationSize=1)
public class HarvesterSetting
extends GeonetEntity {
    static final String ID_SEQ_NAME = "harvester_setting_id_seq";
    private static final HashSet<String> EXCLUDE_FROM_XML = Sets.newHashSet((Object[])new String[]{"valueAsBool", "valueAsInt"});
    private int _id;
    private HarvesterSetting _parent;
    private String _name;
    private String _value;

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="harvester_setting_id_seq")
    @Column(name="id", nullable=false)
    public int getId() {
        return this._id;
    }

    public HarvesterSetting setId(int id) {
        this._id = id;
        return this;
    }

    @OneToOne(optional=true, fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="parentid")
    @OnDelete(action=OnDeleteAction.CASCADE)
    @Nullable
    public HarvesterSetting getParent() {
        return this._parent;
    }

    @Nonnull
    public HarvesterSetting setParent(@Nullable HarvesterSetting parent) {
        this._parent = parent;
        return this;
    }

    @Column(name="name", nullable=false)
    @Nonnull
    public String getName() {
        return this._name;
    }

    @Nonnull
    public HarvesterSetting setName(@Nonnull String name) {
        this._name = name;
        return this;
    }

    @Lob
    @Column(name="value", nullable=true)
    @Type(type="org.hibernate.type.StringClobType")
    @Nullable
    public String getValue() {
        return this._value;
    }

    public HarvesterSetting setValue(boolean value) {
        return this.setValue(String.valueOf(value));
    }

    public HarvesterSetting setValue(@Nullable String value) {
        this._value = value;
        return this;
    }

    @Transient
    public int getValueAsInt() throws NullPointerException, NumberFormatException {
        if (this.getValue() == null) {
            throw new NullPointerException("Setting value of " + this.getName() + " is null");
        }
        return Integer.parseInt(this.getValue());
    }

    public HarvesterSetting setValue(int value) {
        return this.setValue(String.valueOf(value));
    }

    @Transient
    public boolean getValueAsBool() throws NullPointerException {
        if (this.getValue() == null) {
            throw new NullPointerException("Setting value of " + this.getName() + " is null");
        }
        return Boolean.parseBoolean(this._value);
    }

    @Override
    protected Set<String> propertiesToExcludeFromXml() {
        return EXCLUDE_FROM_XML;
    }

    public String toString() {
        return "Setting [id=" + this._id + ", name=" + this._name + ", value=" + this._value + "]";
    }
}

