/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.util.uri;

public class UriUtil {
    private static final String ESCAPE_CHARS = "<>#%\"{}|\\^[]`";

    public static String encodeUri(String uri) {
        StringBuffer result = new StringBuffer(2 * uri.length());
        UriUtil.encodeUri(uri, result);
        return result.toString();
    }

    public static void encodeUri(String uri, StringBuffer buf) {
        for (int i = 0; i < uri.length(); ++i) {
            char c;
            char cInt = c = uri.charAt(i);
            if (ESCAPE_CHARS.indexOf(c) >= 0 || cInt <= ' ') {
                buf.append('%');
                String hexVal = Integer.toHexString(cInt);
                if (hexVal.length() == 1) {
                    buf.append('0');
                }
                buf.append(hexVal);
                continue;
            }
            buf.append(c);
        }
    }

    public static String decodeUri(String uri) {
        StringBuffer result = new StringBuffer(uri.length());
        UriUtil.decodeUri(uri, result);
        return result.toString();
    }

    public static void decodeUri(String uri, StringBuffer buf) {
        int indexOfHash = uri.indexOf(35);
        if (indexOfHash == -1) {
            UriUtil._decodeUri(uri, buf);
        } else {
            String baseUri = uri.substring(0, indexOfHash);
            String fragId = uri.substring(indexOfHash);
            UriUtil._decodeUri(baseUri, buf);
            buf.append(fragId);
        }
    }

    private static void _decodeUri(String uri, StringBuffer buf) {
        int percentIdx = uri.indexOf(37);
        int startIdx = 0;
        while (percentIdx != -1) {
            buf.append(uri.substring(startIdx, percentIdx));
            String xx = uri.substring(percentIdx + 1, percentIdx + 3);
            int c = Integer.parseInt(xx, 16);
            buf.append((char)c);
            startIdx = percentIdx + 3;
            percentIdx = uri.indexOf(37, startIdx);
        }
        buf.append(uri.substring(startIdx));
    }
}

