/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.util.io;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public final class IOUtil {
    public static final long transfer(InputStream in, OutputStream out) throws IOException {
        long totalBytes = 0L;
        int bytesInBuf = 0;
        byte[] buf = new byte[4096];
        while ((bytesInBuf = in.read(buf)) != -1) {
            out.write(buf, 0, bytesInBuf);
            totalBytes += (long)bytesInBuf;
        }
        return totalBytes;
    }

    public static final byte[] readFully(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        IOUtil.transfer(in, out);
        out.close();
        return out.toByteArray();
    }

    public static final byte[] readBytes(InputStream in, int maxBytes) throws IOException {
        int bytesRead;
        byte[] result = new byte[maxBytes];
        int totalBytesRead = bytesRead = in.read(result);
        while (totalBytesRead < maxBytes && bytesRead >= 0) {
            if ((bytesRead = in.read(result, bytesRead, maxBytes - bytesRead)) <= 0) continue;
            totalBytesRead += bytesRead;
        }
        if (totalBytesRead < 0) {
            result = new byte[]{};
        } else if (totalBytesRead < maxBytes) {
            byte[] tmp = new byte[totalBytesRead];
            System.arraycopy(result, 0, tmp, 0, totalBytesRead);
            result = tmp;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long writeToFile(InputStream in, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            long l = IOUtil.transfer(in, out);
            return l;
        }
        finally {
            out.close();
        }
    }

    public static final long transfer(Reader in, Writer out) throws IOException {
        long totalChars = 0L;
        int charsInBuf = 0;
        char[] buf = new char[4096];
        while ((charsInBuf = in.read(buf)) != -1) {
            out.write(buf, 0, charsInBuf);
            totalChars += (long)charsInBuf;
        }
        return totalChars;
    }

    public static final String readFully(Reader reader) throws IOException {
        CharArrayWriter out = new CharArrayWriter(4096);
        IOUtil.transfer(reader, out);
        out.close();
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long writeToFile(Reader reader, File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        try {
            long l = IOUtil.transfer(reader, writer);
            return l;
        }
        finally {
            writer.close();
        }
    }
}

