/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.builder.AbstractStyleBuilder;
import org.geotools.styling.builder.ColorMapEntryBuilder;
import org.geotools.styling.builder.StyleBuilder;

public class ColorMapBuilder
extends AbstractStyleBuilder<ColorMap> {
    int type = 1;
    boolean extended = false;
    List<ColorMapEntry> entries = new ArrayList<ColorMapEntry>();
    ColorMapEntryBuilder colorMapEntryBuilder = null;

    public ColorMapBuilder() {
        this((AbstractStyleBuilder<?>)null);
    }

    public ColorMapBuilder(AbstractStyleBuilder<?> parent) {
        super(parent);
        this.reset();
    }

    public ColorMapBuilder type(int type) {
        this.type = type;
        this.unset = false;
        return this;
    }

    public ColorMapBuilder extended(boolean extended) {
        this.extended = extended;
        this.unset = false;
        return this;
    }

    public ColorMapEntryBuilder entry() {
        if (this.colorMapEntryBuilder != null && !this.colorMapEntryBuilder.isUnset()) {
            this.entries.add(this.colorMapEntryBuilder.build());
            this.unset = false;
        }
        this.colorMapEntryBuilder = new ColorMapEntryBuilder();
        return this.colorMapEntryBuilder;
    }

    @Override
    public ColorMap build() {
        this.entry();
        if (this.unset) {
            return null;
        }
        ColorMap colorMap = this.sf.createColorMap();
        colorMap.setType(this.type);
        colorMap.setExtendedColors(this.extended);
        for (ColorMapEntry entry : this.entries) {
            colorMap.addColorMapEntry(entry);
        }
        if (this.parent == null) {
            this.reset();
        }
        return colorMap;
    }

    public ColorMapBuilder reset() {
        this.type = 1;
        this.extended = false;
        this.entries = new ArrayList<ColorMapEntry>();
        this.unset = false;
        return this;
    }

    public ColorMapBuilder reset(ColorMap original) {
        if (original == null) {
            return this.reset();
        }
        this.type = original.getType();
        this.extended = original.getExtendedColors();
        this.entries = new ArrayList<ColorMapEntry>(Arrays.asList(original.getColorMapEntries()));
        this.unset = false;
        return this;
    }

    @Override
    public ColorMapBuilder unset() {
        return (ColorMapBuilder)super.unset();
    }

    @Override
    protected void buildStyleInternal(StyleBuilder sb) {
        sb.featureTypeStyle().rule().raster().colorMap().init(this);
    }
}

