/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.z3950.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jzkit.z3950.server.Z3950NonBlockingBackend;
import org.jzkit.z3950.server.ZServerAssociation;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class Z3950Listener
extends Thread
implements ApplicationContextAware {
    public static Log log = LogFactory.getLog(Z3950Listener.class);
    private int socket_timeout = 300000;
    private boolean running = true;
    private ServerSocket server_socket = null;
    private int port;
    private String bind_address;
    private String default_collections;
    private String backend_bean_name;
    private ApplicationContext ctx;

    public Z3950Listener() {
        log.debug((Object)"new Z3950Listener()");
    }

    public void run() {
        try {
            log.debug((Object)("Starting ZServer on port " + this.port + " (timeout=" + this.socket_timeout + ")"));
            this.server_socket = new ServerSocket(this.port);
            while (this.running) {
                log.debug((Object)"Waiting for connection");
                Socket socket = this.server_socket.accept();
                socket.setSoTimeout(this.socket_timeout);
                log.debug((Object)"Obtaining handle to backend and creating association");
                Z3950NonBlockingBackend backend = (Z3950NonBlockingBackend)this.ctx.getBean(this.backend_bean_name);
                log.debug((Object)("new backend instance " + backend.hashCode()));
                ZServerAssociation zServerAssociation = new ZServerAssociation(socket, backend, this.ctx);
            }
            this.server_socket.close();
        }
        catch (IOException e) {
            log.error((Object)"Problem", (Throwable)e);
        }
    }

    public void shutdown(int shutdown_type) {
        this.running = false;
        switch (shutdown_type) {
            default: 
        }
        try {
            this.server_socket.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getBindAddress() {
        return this.bind_address;
    }

    public void setBindAddress(String bind_address) {
        this.bind_address = bind_address;
    }

    public String getDefault() {
        return this.default_collections;
    }

    public void setDefault(String default_collections) {
        this.default_collections = default_collections;
    }

    public String getBackendBeanName() {
        return this.backend_bean_name;
    }

    public void setBackendBeanName(String backend_bean_name) {
        this.backend_bean_name = backend_bean_name;
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this.ctx = ctx;
    }
}

