/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io.footprint;

import com.vividsolutions.jts.awt.ShapeReader;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import javax.imageio.ImageReadParam;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import org.geotools.coverage.grid.io.footprint.FootprintInsetPolicy;
import org.geotools.coverage.grid.io.footprint.MultiLevelROI;
import org.geotools.coverage.grid.io.imageio.ReadType;
import org.geotools.geometry.jts.GeometryClipper;
import org.geotools.util.SoftValueHashMap;
import org.jaitools.imageutils.ROIGeometry;

public class MultiLevelROIGeometry
implements MultiLevelROI {
    private Geometry originalFootprint;
    private Geometry insetFootprint;
    private Geometry granuleBounds;
    private double inset;
    private FootprintInsetPolicy insetPolicy;
    private SoftValueHashMap<AffineTransform, ROIGeometry> roiCache = new SoftValueHashMap(10);
    private boolean empty;

    public MultiLevelROIGeometry(Geometry footprint, Geometry granuleBounds, double inset, FootprintInsetPolicy insetPolicy) {
        this.originalFootprint = footprint;
        this.granuleBounds = granuleBounds;
        this.inset = inset;
        this.insetPolicy = insetPolicy;
        if (inset > 0.0) {
            this.insetFootprint = insetPolicy.applyInset(this.originalFootprint, granuleBounds, inset);
            this.empty = this.insetFootprint.isEmpty();
        } else {
            this.empty = this.originalFootprint.isEmpty();
        }
    }

    public ROIGeometry getTransformedROI(AffineTransform at, int imageIndex, Rectangle imgBounds, ImageReadParam params, ReadType readType) {
        ROIGeometry roiGeometry;
        if (this.empty) {
            return null;
        }
        if (at == null) {
            at = new AffineTransform();
        }
        if ((roiGeometry = (ROIGeometry)this.roiCache.get((Object)at)) == null) {
            Geometry rescaled;
            AffineTransformation geometryAT = new AffineTransformation(at.getScaleX(), at.getShearX(), at.getTranslateX(), at.getShearY(), at.getScaleY(), at.getTranslateY());
            if (this.inset > 0.0) {
                double scale = Math.min(Math.abs(at.getScaleX()), Math.abs(at.getScaleY()));
                double rescaledInset = scale * this.inset;
                if (rescaledInset < 1.0) {
                    Geometry cloned = (Geometry)this.originalFootprint.clone();
                    cloned.apply((CoordinateSequenceFilter)geometryAT);
                    Geometry bounds = (Geometry)this.granuleBounds.clone();
                    bounds.apply((CoordinateSequenceFilter)geometryAT);
                    rescaled = this.insetPolicy.applyInset(cloned, bounds, 1.5);
                } else {
                    rescaled = (Geometry)this.insetFootprint.clone();
                    rescaled.apply((CoordinateSequenceFilter)geometryAT);
                }
            } else {
                rescaled = (Geometry)this.originalFootprint.clone();
                rescaled.apply((CoordinateSequenceFilter)geometryAT);
            }
            if (!rescaled.isEmpty()) {
                Geometry simplified = TopologyPreservingSimplifier.simplify((Geometry)rescaled, (double)0.333);
                roiGeometry = new FastClipROIGeometry(simplified);
                this.roiCache.put((Object)at, (Object)roiGeometry);
            } else {
                return null;
            }
        }
        return roiGeometry;
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public Geometry getFootprint() {
        if (this.inset == 0.0) {
            return this.originalFootprint;
        }
        return this.insetFootprint;
    }

    static class FastClipROIGeometry
    extends ROIGeometry {
        private static final long serialVersionUID = -4283288388988174306L;
        private static final AffineTransformation Y_INVERSION = new AffineTransformation(1.0, 0.0, 0.0, 0.0, -1.0, 0.0);

        public FastClipROIGeometry(Geometry geom) {
            super(geom);
        }

        public ROI intersect(ROI roi) {
            Geometry geom = this.getGeometry(roi);
            if (geom != null && geom.equalsExact(geom.getEnvelope())) {
                GeometryClipper clipper = new GeometryClipper(geom.getEnvelopeInternal());
                Geometry intersect = clipper.clip(this.getAsGeometry(), true);
                return new ROIGeometry(intersect);
            }
            return super.intersect(roi);
        }

        private Geometry getGeometry(ROI roi) {
            if (roi instanceof ROIGeometry) {
                return ((ROIGeometry)roi).getAsGeometry();
            }
            if (roi instanceof ROIShape) {
                Shape shape = ((ROIShape)roi).getAsShape();
                Geometry geom = ShapeReader.read((Shape)shape, (double)0.0, (GeometryFactory)new GeometryFactory());
                geom.apply((CoordinateSequenceFilter)Y_INVERSION);
                return geom;
            }
            return null;
        }
    }
}

