/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Channel;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.StartupListener;
import org.apache.camel.TimerListener;
import org.apache.camel.VetoCamelContextStartException;
import org.apache.camel.api.management.PerformanceCounter;
import org.apache.camel.impl.ConsumerCache;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.EndpointRegistry;
import org.apache.camel.impl.EventDrivenConsumerRoute;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.impl.ThrottlingInflightRoutePolicy;
import org.apache.camel.management.CompositePerformanceCounter;
import org.apache.camel.management.DelegatePerformanceCounter;
import org.apache.camel.management.InstrumentationInterceptStrategy;
import org.apache.camel.management.InstrumentationProcessor;
import org.apache.camel.management.mbean.ManagedBacklogDebugger;
import org.apache.camel.management.mbean.ManagedBacklogTracer;
import org.apache.camel.management.mbean.ManagedCamelContext;
import org.apache.camel.management.mbean.ManagedConsumerCache;
import org.apache.camel.management.mbean.ManagedEndpointRegistry;
import org.apache.camel.management.mbean.ManagedProducerCache;
import org.apache.camel.management.mbean.ManagedRestRegistry;
import org.apache.camel.management.mbean.ManagedRoute;
import org.apache.camel.management.mbean.ManagedRuntimeEndpointRegistry;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.management.mbean.ManagedStreamCachingStrategy;
import org.apache.camel.management.mbean.ManagedThrottlingInflightRoutePolicy;
import org.apache.camel.management.mbean.ManagedTracer;
import org.apache.camel.management.mbean.ManagedTypeConverterRegistry;
import org.apache.camel.model.AOPDefinition;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.CamelInternalProcessor;
import org.apache.camel.processor.interceptor.BacklogDebugger;
import org.apache.camel.processor.interceptor.BacklogTracer;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ManagementAgent;
import org.apache.camel.spi.ManagementAware;
import org.apache.camel.spi.ManagementNameStrategy;
import org.apache.camel.spi.ManagementObjectStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.RestRegistry;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.RuntimeEndpointRegistry;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.support.TimerListenerManager;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultManagementLifecycleStrategy
extends ServiceSupport
implements LifecycleStrategy,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultManagementLifecycleStrategy.class);
    private final Map<Processor, KeyValueHolder<ProcessorDefinition<?>, InstrumentationProcessor>> wrappedProcessors = new HashMap();
    private final List<PreRegisterService> preServices = new ArrayList<PreRegisterService>();
    private final TimerListenerManager timerListenerManager = new TimerListenerManager();
    private final TimerListenerManagerStartupListener timerManagerStartupListener = new TimerListenerManagerStartupListener();
    private volatile CamelContext camelContext;
    private volatile ManagedCamelContext camelContextMBean;
    private volatile boolean initialized;
    private final Set<String> knowRouteIds = new HashSet<String>();
    private final Map<Tracer, ManagedTracer> managedTracers = new HashMap<Tracer, ManagedTracer>();
    private final Map<BacklogTracer, ManagedBacklogTracer> managedBacklogTracers = new HashMap<BacklogTracer, ManagedBacklogTracer>();
    private final Map<BacklogDebugger, ManagedBacklogDebugger> managedBacklogDebuggers = new HashMap<BacklogDebugger, ManagedBacklogDebugger>();
    private final Map<ThreadPoolExecutor, Object> managedThreadPools = new HashMap<ThreadPoolExecutor, Object>();

    public DefaultManagementLifecycleStrategy() {
    }

    public DefaultManagementLifecycleStrategy(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void onContextStart(CamelContext context) throws VetoCamelContextStartException {
        Object mc = this.getManagementObjectStrategy().getManagedObjectForCamelContext(context);
        String name = context.getName();
        String managementName = context.getManagementNameStrategy().getName();
        try {
            boolean done = false;
            while (!done) {
                ObjectName on = this.getManagementStrategy().getManagementNamingStrategy().getObjectNameForCamelContext(managementName, name);
                boolean exists = this.getManagementStrategy().isManaged(mc, on);
                if (!exists) {
                    done = true;
                    continue;
                }
                boolean fixed = false;
                String newName = this.findFreeName(mc, context.getManagementNameStrategy(), name);
                if (newName != null) {
                    fixed = true;
                    done = true;
                    managementName = newName;
                }
                if (!fixed) {
                    throw new VetoCamelContextStartException("CamelContext (" + context.getName() + ") with ObjectName[" + on + "] is already registered." + " Make sure to use unique names on CamelContext when using multiple CamelContexts in the same MBeanServer.", context);
                }
                LOG.warn("This CamelContext(" + context.getName() + ") will be registered using the name: " + managementName + " due to clash with an existing name already registered in MBeanServer.");
            }
        }
        catch (VetoCamelContextStartException e) {
            throw e;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        if (context instanceof DefaultCamelContext) {
            ((DefaultCamelContext)context).setManagementName(managementName);
        }
        try {
            this.manageObject(mc);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        this.initialized = true;
        if (mc instanceof ManagedCamelContext) {
            this.camelContextMBean = (ManagedCamelContext)mc;
        }
        this.enlistPreRegisteredServices();
    }

    private String findFreeName(Object mc, ManagementNameStrategy strategy, String name) throws MalformedObjectNameException {
        if (strategy.isFixedName()) {
            return null;
        }
        boolean done = false;
        String newName = null;
        while (!done) {
            newName = strategy.getNextName();
            ObjectName on = this.getManagementStrategy().getManagementNamingStrategy().getObjectNameForCamelContext(newName, name);
            boolean bl = done = !this.getManagementStrategy().isManaged(mc, on);
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("Using name: {} in ObjectName[{}] exists? {}", new Object[]{name, on, done});
        }
        return newName;
    }

    private void enlistPreRegisteredServices() {
        if (this.preServices.isEmpty()) {
            return;
        }
        LOG.debug("Registering {} pre registered services", (Object)this.preServices.size());
        for (PreRegisterService pre : this.preServices) {
            if (pre.getComponent() != null) {
                this.onComponentAdd(pre.getName(), pre.getComponent());
                continue;
            }
            if (pre.getEndpoint() != null) {
                this.onEndpointAdd(pre.getEndpoint());
                continue;
            }
            if (pre.getService() == null) continue;
            this.onServiceAdd(pre.getCamelContext(), pre.getService(), pre.getRoute());
        }
        this.preServices.clear();
    }

    @Override
    public void onContextStop(CamelContext context) {
        if (!this.initialized) {
            return;
        }
        try {
            Object mc = this.getManagementObjectStrategy().getManagedObjectForCamelContext(context);
            if (this.getManagementStrategy().isManaged(mc, null)) {
                this.unmanageObject(mc);
            }
        }
        catch (Exception e) {
            LOG.warn("Could not unregister CamelContext MBean", (Throwable)e);
        }
        this.camelContextMBean = null;
    }

    @Override
    public void onComponentAdd(String name, Component component) {
        if (!this.initialized) {
            PreRegisterService pre = new PreRegisterService();
            pre.onComponentAdd(name, component);
            this.preServices.add(pre);
            return;
        }
        try {
            Object mc = this.getManagementObjectStrategy().getManagedObjectForComponent(this.camelContext, component, name);
            this.manageObject(mc);
        }
        catch (Exception e) {
            LOG.warn("Could not register Component MBean", (Throwable)e);
        }
    }

    @Override
    public void onComponentRemove(String name, Component component) {
        if (!this.initialized) {
            return;
        }
        try {
            Object mc = this.getManagementObjectStrategy().getManagedObjectForComponent(this.camelContext, component, name);
            this.unmanageObject(mc);
        }
        catch (Exception e) {
            LOG.warn("Could not unregister Component MBean", (Throwable)e);
        }
    }

    @Override
    public void onEndpointAdd(Endpoint endpoint) {
        if (!this.initialized) {
            PreRegisterService pre = new PreRegisterService();
            pre.onEndpointAdd(endpoint);
            this.preServices.add(pre);
            return;
        }
        if (!this.shouldRegister(endpoint, null)) {
            return;
        }
        try {
            Object me = this.getManagementObjectStrategy().getManagedObjectForEndpoint(this.camelContext, endpoint);
            if (me == null) {
                return;
            }
            this.manageObject(me);
        }
        catch (Exception e) {
            LOG.warn("Could not register Endpoint MBean for endpoint: " + endpoint + ". This exception will be ignored.", (Throwable)e);
        }
    }

    @Override
    public void onEndpointRemove(Endpoint endpoint) {
        if (!this.initialized) {
            return;
        }
        try {
            Object me = this.getManagementObjectStrategy().getManagedObjectForEndpoint(this.camelContext, endpoint);
            this.unmanageObject(me);
        }
        catch (Exception e) {
            LOG.warn("Could not unregister Endpoint MBean for endpoint: " + endpoint + ". This exception will be ignored.", (Throwable)e);
        }
    }

    @Override
    public void onServiceAdd(CamelContext context, Service service, Route route) {
        if (!this.initialized) {
            PreRegisterService pre = new PreRegisterService();
            pre.onServiceAdd(context, service, route);
            this.preServices.add(pre);
            return;
        }
        if (!this.shouldRegister(service, route)) {
            return;
        }
        Object managedObject = this.getManagedObjectForService(context, service, route);
        if (managedObject == null) {
            return;
        }
        if (this.getManagementStrategy().isManaged(managedObject, null)) {
            LOG.trace("The service is already managed: {}", (Object)service);
            return;
        }
        try {
            this.manageObject(managedObject);
        }
        catch (Exception e) {
            LOG.warn("Could not register service: " + service + " as Service MBean.", (Throwable)e);
        }
    }

    @Override
    public void onServiceRemove(CamelContext context, Service service, Route route) {
        if (!this.initialized) {
            return;
        }
        Object managedObject = this.getManagedObjectForService(context, service, route);
        if (managedObject != null) {
            try {
                this.unmanageObject(managedObject);
            }
            catch (Exception e) {
                LOG.warn("Could not unregister service: " + service + " as Service MBean.", (Throwable)e);
            }
        }
    }

    private Object getManagedObjectForService(CamelContext context, Service service, Route route) {
        if (service instanceof Channel || service instanceof UnitOfWork || service instanceof InstrumentationProcessor) {
            return null;
        }
        Object answer = null;
        if (service instanceof ManagementAware) {
            return ((ManagementAware)((Object)service)).getManagedObject(service);
        }
        if (service instanceof Tracer) {
            Tracer tracer = (Tracer)service;
            ManagedTracer mt = this.managedTracers.get(tracer);
            if (mt == null) {
                mt = new ManagedTracer(context, tracer);
                mt.init(this.getManagementStrategy());
                this.managedTracers.put(tracer, mt);
            }
            return mt;
        }
        if (service instanceof BacklogTracer) {
            BacklogTracer backlogTracer = (BacklogTracer)service;
            ManagedBacklogTracer mt = this.managedBacklogTracers.get(backlogTracer);
            if (mt == null) {
                mt = new ManagedBacklogTracer(context, backlogTracer);
                mt.init(this.getManagementStrategy());
                this.managedBacklogTracers.put(backlogTracer, mt);
            }
            return mt;
        }
        if (service instanceof BacklogDebugger) {
            BacklogDebugger backlogDebugger = (BacklogDebugger)service;
            ManagedBacklogDebugger md = this.managedBacklogDebuggers.get(backlogDebugger);
            if (md == null) {
                md = new ManagedBacklogDebugger(context, backlogDebugger);
                md.init(this.getManagementStrategy());
                this.managedBacklogDebuggers.put(backlogDebugger, md);
            }
            return md;
        }
        if (service instanceof EventNotifier) {
            answer = this.getManagementObjectStrategy().getManagedObjectForEventNotifier(context, (EventNotifier)((Object)service));
        } else if (service instanceof Producer) {
            answer = this.getManagementObjectStrategy().getManagedObjectForProducer(context, (Producer)service);
        } else if (service instanceof Consumer) {
            answer = this.getManagementObjectStrategy().getManagedObjectForConsumer(context, (Consumer)service);
        } else {
            if (service instanceof Processor) {
                return this.getManagedObjectForProcessor(context, (Processor)((Object)service), route);
            }
            if (service instanceof ThrottlingInflightRoutePolicy) {
                answer = new ManagedThrottlingInflightRoutePolicy(context, (ThrottlingInflightRoutePolicy)service);
            } else if (service instanceof ConsumerCache) {
                answer = new ManagedConsumerCache(context, (ConsumerCache)service);
            } else if (service instanceof ProducerCache) {
                answer = new ManagedProducerCache(context, (ProducerCache)service);
            } else if (service instanceof EndpointRegistry) {
                answer = new ManagedEndpointRegistry(context, (EndpointRegistry)service);
            } else if (service instanceof TypeConverterRegistry) {
                answer = new ManagedTypeConverterRegistry(context, (TypeConverterRegistry)service);
            } else if (service instanceof RestRegistry) {
                answer = new ManagedRestRegistry(context, (RestRegistry)service);
            } else if (service instanceof RuntimeEndpointRegistry) {
                answer = new ManagedRuntimeEndpointRegistry(context, (RuntimeEndpointRegistry)service);
            } else if (service instanceof StreamCachingStrategy) {
                answer = new ManagedStreamCachingStrategy(context, (StreamCachingStrategy)service);
            } else if (service != null) {
                answer = this.getManagementObjectStrategy().getManagedObjectForService(context, service);
            }
        }
        if (answer != null && answer instanceof ManagedService) {
            ManagedService ms = (ManagedService)answer;
            ms.setRoute(route);
            ms.init(this.getManagementStrategy());
        }
        return answer;
    }

    private Object getManagedObjectForProcessor(CamelContext context, Processor processor, Route route) {
        InstrumentationProcessor counter;
        KeyValueHolder<ProcessorDefinition<?>, InstrumentationProcessor> holder = this.wrappedProcessors.get(processor);
        if (holder == null) {
            return null;
        }
        Object managedObject = this.getManagementObjectStrategy().getManagedObjectForProcessor(context, processor, holder.getKey(), route);
        if (managedObject != null && managedObject instanceof PerformanceCounter && (counter = holder.getValue()) != null) {
            counter.setCounter(managedObject);
        }
        return managedObject;
    }

    @Override
    public void onRoutesAdd(Collection<Route> routes) {
        for (Route route : routes) {
            EventDrivenConsumerRoute edcr;
            Processor processor;
            if (this.getCamelContext().getStatus().isStarting() || this.getManagementStrategy().getManagementAgent().getRegisterAlways().booleanValue() || this.getManagementStrategy().getManagementAgent().getRegisterNewRoutes().booleanValue()) {
                this.knowRouteIds.add(route.getId());
            }
            if (!this.shouldRegister(route, route)) continue;
            Object mr = this.getManagementObjectStrategy().getManagedObjectForRoute(this.camelContext, route);
            if (this.getManagementStrategy().isManaged(mr, null)) {
                LOG.trace("The route is already managed: {}", (Object)route);
                continue;
            }
            if (route instanceof EventDrivenConsumerRoute && (processor = (edcr = (EventDrivenConsumerRoute)route).getProcessor()) instanceof CamelInternalProcessor && mr instanceof ManagedRoute) {
                CamelInternalProcessor internal = (CamelInternalProcessor)processor;
                ManagedRoute routeMBean = (ManagedRoute)mr;
                CamelInternalProcessor.InstrumentationAdvice task = internal.getAdvice(CamelInternalProcessor.InstrumentationAdvice.class);
                if (task != null) {
                    if (this.camelContextMBean != null) {
                        CompositePerformanceCounter wrapper = new CompositePerformanceCounter(routeMBean, this.camelContextMBean);
                        task.setCounter(wrapper);
                    } else {
                        task.setCounter(routeMBean);
                    }
                }
            }
            try {
                this.manageObject(mr);
            }
            catch (JMException e) {
                LOG.warn("Could not register Route MBean", (Throwable)e);
            }
            catch (Exception e) {
                LOG.warn("Could not create Route MBean", (Throwable)e);
            }
        }
    }

    @Override
    public void onRoutesRemove(Collection<Route> routes) {
        if (!this.initialized) {
            return;
        }
        for (Route route : routes) {
            Object mr = this.getManagementObjectStrategy().getManagedObjectForRoute(this.camelContext, route);
            if (!this.getManagementStrategy().isManaged(mr, null)) {
                LOG.trace("The route is not managed: {}", (Object)route);
                continue;
            }
            try {
                this.unmanageObject(mr);
            }
            catch (Exception e) {
                LOG.warn("Could not unregister Route MBean", (Throwable)e);
            }
            this.knowRouteIds.remove(route.getId());
        }
        this.removeWrappedProcessorsForRoutes(routes);
    }

    @Override
    public void onErrorHandlerAdd(RouteContext routeContext, Processor errorHandler, ErrorHandlerFactory errorHandlerBuilder) {
        if (!this.shouldRegister(errorHandler, null)) {
            return;
        }
        Object me = this.getManagementObjectStrategy().getManagedObjectForErrorHandler(this.camelContext, routeContext, errorHandler, errorHandlerBuilder);
        if (this.getManagementStrategy().isManaged(me, null)) {
            LOG.trace("The error handler builder is already managed: {}", (Object)errorHandlerBuilder);
            return;
        }
        try {
            this.manageObject(me);
        }
        catch (Exception e) {
            LOG.warn("Could not register error handler builder: " + errorHandlerBuilder + " as ErrorHandler MBean.", (Throwable)e);
        }
    }

    @Override
    public void onErrorHandlerRemove(RouteContext routeContext, Processor errorHandler, ErrorHandlerFactory errorHandlerBuilder) {
        if (!this.initialized) {
            return;
        }
        Object me = this.getManagementObjectStrategy().getManagedObjectForErrorHandler(this.camelContext, routeContext, errorHandler, errorHandlerBuilder);
        if (me != null) {
            try {
                this.unmanageObject(me);
            }
            catch (Exception e) {
                LOG.warn("Could not unregister error handler: " + me + " as ErrorHandler MBean.", (Throwable)e);
            }
        }
    }

    @Override
    public void onThreadPoolAdd(CamelContext camelContext, ThreadPoolExecutor threadPool, String id, String sourceId, String routeId, String threadPoolProfileId) {
        if (!this.shouldRegister(threadPool, null)) {
            return;
        }
        Object mtp = this.getManagementObjectStrategy().getManagedObjectForThreadPool(camelContext, threadPool, id, sourceId, routeId, threadPoolProfileId);
        if (this.getManagementStrategy().isManaged(mtp, null)) {
            LOG.trace("The thread pool is already managed: {}", (Object)threadPool);
            return;
        }
        try {
            this.manageObject(mtp);
            this.managedThreadPools.put(threadPool, mtp);
        }
        catch (Exception e) {
            LOG.warn("Could not register thread pool: " + threadPool + " as ThreadPool MBean.", (Throwable)e);
        }
    }

    @Override
    public void onThreadPoolRemove(CamelContext camelContext, ThreadPoolExecutor threadPool) {
        if (!this.initialized) {
            return;
        }
        Object mtp = this.managedThreadPools.remove(threadPool);
        if (mtp != null) {
            if (!this.getManagementStrategy().isManaged(mtp, null)) {
                LOG.trace("The thread pool is not managed: {}", (Object)threadPool);
                return;
            }
            try {
                this.unmanageObject(mtp);
            }
            catch (Exception e) {
                LOG.warn("Could not unregister ThreadPool MBean", (Throwable)e);
            }
        }
    }

    @Override
    public void onRouteContextCreate(RouteContext routeContext) {
        if (!this.initialized) {
            return;
        }
        HashMap registeredCounters = new HashMap();
        RouteDefinition route = routeContext.getRoute();
        for (ProcessorDefinition<?> processor : route.getOutputs()) {
            this.registerPerformanceCounters(routeContext, processor, registeredCounters);
        }
        routeContext.setManagedInterceptStrategy(new InstrumentationInterceptStrategy(registeredCounters, this.wrappedProcessors));
    }

    private void removeWrappedProcessorsForRoutes(Collection<Route> routes) {
        for (Route route : routes) {
            String id = route.getId();
            Iterator<KeyValueHolder<ProcessorDefinition<?>, InstrumentationProcessor>> it = this.wrappedProcessors.values().iterator();
            while (it.hasNext()) {
                KeyValueHolder<ProcessorDefinition<?>, InstrumentationProcessor> holder = it.next();
                RouteDefinition def = ProcessorDefinitionHelper.getRoute(holder.getKey());
                if (def == null || !id.equals(def.getId())) continue;
                it.remove();
            }
        }
    }

    private void registerPerformanceCounters(RouteContext routeContext, ProcessorDefinition<?> processor, Map<ProcessorDefinition<?>, PerformanceCounter> registeredCounters) {
        List<ProcessorDefinition<?>> children = processor.getOutputs();
        for (ProcessorDefinition<?> child : children) {
            this.registerPerformanceCounters(routeContext, child, registeredCounters);
        }
        if (!this.registerProcessor(processor)) {
            return;
        }
        DelegatePerformanceCounter pc = new DelegatePerformanceCounter();
        boolean enabled = this.camelContext.getManagementStrategy().getStatisticsLevel() == ManagementStatisticsLevel.All;
        pc.setStatisticsEnabled(enabled);
        registeredCounters.put(processor, pc);
    }

    protected boolean registerProcessor(ProcessorDefinition<?> processor) {
        if (processor instanceof OnExceptionDefinition) {
            return false;
        }
        if (processor instanceof OnCompletionDefinition) {
            return false;
        }
        if (processor instanceof InterceptDefinition) {
            return false;
        }
        if (processor instanceof AOPDefinition) {
            return false;
        }
        if (processor instanceof PolicyDefinition) {
            return false;
        }
        if (this.getManagementStrategy().isOnlyManageProcessorWithCustomId()) {
            return processor.hasCustomIdAssigned();
        }
        return this.getManagementStrategy().manageProcessor(processor);
    }

    private ManagementStrategy getManagementStrategy() {
        ObjectHelper.notNull(this.camelContext, "CamelContext");
        return this.camelContext.getManagementStrategy();
    }

    private ManagementObjectStrategy getManagementObjectStrategy() {
        ObjectHelper.notNull(this.camelContext, "CamelContext");
        return this.camelContext.getManagementStrategy().getManagementObjectStrategy();
    }

    protected void manageObject(Object me) throws Exception {
        this.getManagementStrategy().manageObject(me);
        if (me instanceof TimerListener) {
            TimerListener timer = (TimerListener)me;
            this.timerListenerManager.addTimerListener(timer);
        }
    }

    protected void unmanageObject(Object me) throws Exception {
        if (me instanceof TimerListener) {
            TimerListener timer = (TimerListener)me;
            this.timerListenerManager.removeTimerListener(timer);
        }
        this.getManagementStrategy().unmanageObject(me);
    }

    protected boolean shouldRegister(Object service, Route route) {
        if (!this.initialized) {
            return false;
        }
        LOG.trace("Checking whether to register {} from route: {}", service, (Object)route);
        ManagementAgent agent = this.getManagementStrategy().getManagementAgent();
        if (agent == null) {
            return false;
        }
        if (this.getCamelContext().getStatus().isStarting()) {
            return true;
        }
        if (this.getCamelContext().isSetupRoutes()) {
            return true;
        }
        if (agent.getRegisterAlways().booleanValue()) {
            return true;
        }
        if (route != null && this.knowRouteIds.contains(route.getId())) {
            return true;
        }
        if (agent.getRegisterNewRoutes().booleanValue()) {
            return this.getCamelContext().isStartingRoutes();
        }
        return false;
    }

    @Override
    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.camelContext, "CamelContext");
        this.camelContext.addStartupListener(this.timerManagerStartupListener);
    }

    @Override
    protected void doStop() throws Exception {
        this.initialized = false;
        this.knowRouteIds.clear();
        this.preServices.clear();
        this.wrappedProcessors.clear();
        this.managedTracers.clear();
        this.managedBacklogTracers.clear();
        this.managedBacklogDebuggers.clear();
        this.managedThreadPools.clear();
    }

    private static final class PreRegisterService {
        private String name;
        private Component component;
        private Endpoint endpoint;
        private CamelContext camelContext;
        private Service service;
        private Route route;

        private PreRegisterService() {
        }

        public void onComponentAdd(String name, Component component) {
            this.name = name;
            this.component = component;
        }

        public void onEndpointAdd(Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        public void onServiceAdd(CamelContext camelContext, Service service, Route route) {
            this.camelContext = camelContext;
            this.service = service;
            this.route = route;
        }

        public String getName() {
            return this.name;
        }

        public Component getComponent() {
            return this.component;
        }

        public Endpoint getEndpoint() {
            return this.endpoint;
        }

        public CamelContext getCamelContext() {
            return this.camelContext;
        }

        public Service getService() {
            return this.service;
        }

        public Route getRoute() {
            return this.route;
        }
    }

    private final class TimerListenerManagerStartupListener
    implements StartupListener {
        private TimerListenerManagerStartupListener() {
        }

        @Override
        public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) throws Exception {
            boolean disabled = !DefaultManagementLifecycleStrategy.this.camelContext.getManagementStrategy().isLoadStatisticsEnabled() || DefaultManagementLifecycleStrategy.this.camelContext.getManagementStrategy().getStatisticsLevel() == ManagementStatisticsLevel.Off;
            LOG.debug("Load performance statistics {}", (Object)(disabled ? "disabled" : "enabled"));
            if (!disabled) {
                DefaultManagementLifecycleStrategy.this.timerListenerManager.setInterval(1000L);
                DefaultManagementLifecycleStrategy.this.getCamelContext().addService(DefaultManagementLifecycleStrategy.this.timerListenerManager);
            }
        }
    }
}

