/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.geotools.factory.Hints;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.jdbc.JDBCFeatureReader;
import org.geotools.jdbc.JDBCFeatureSource;
import org.geotools.jdbc.JoinInfo;
import org.geotools.jdbc.PrimaryKey;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class JDBCJoiningFeatureReader
extends JDBCFeatureReader {
    List<JDBCFeatureReader> joinReaders;
    SimpleFeatureBuilder joinFeatureBuilder;

    public JDBCJoiningFeatureReader(String sql, Connection cx, JDBCFeatureSource featureSource, SimpleFeatureType featureType, JoinInfo join, Hints hints) throws SQLException, IOException {
        super(sql, cx, featureSource, featureType, hints);
        this.init(cx, featureSource, featureType, join, hints);
    }

    public JDBCJoiningFeatureReader(PreparedStatement st, Connection cx, JDBCFeatureSource featureSource, SimpleFeatureType featureType, JoinInfo join, Hints hints) throws SQLException, IOException {
        super(st, cx, featureSource, featureType, hints);
        this.init(cx, featureSource, featureType, join, hints);
    }

    void init(Connection cx, JDBCFeatureSource featureSource, SimpleFeatureType featureType, JoinInfo join, Hints hints) throws SQLException, IOException {
        this.joinReaders = new ArrayList<JDBCFeatureReader>();
        int offset = featureType.getAttributeCount() + this.getPrimaryKeyOffset(featureSource, this.getPrimaryKey(), featureType);
        for (JoinInfo.JoinPart part : join.getParts()) {
            SimpleFeatureType ft = part.getQueryFeatureType();
            JDBCFeatureReader joinReader = new JDBCFeatureReader(this.rs, cx, offset, featureSource.getDataStore().getAbsoluteFeatureSource(ft.getTypeName()), ft, hints){

                @Override
                protected void finalize() throws Throwable {
                }
            };
            this.joinReaders.add(joinReader);
            offset += ft.getAttributeCount() + this.getPrimaryKeyOffset(featureSource, joinReader.getPrimaryKey(), ft);
        }
        this.joinFeatureBuilder = new SimpleFeatureBuilder(JDBCJoiningFeatureReader.retype(featureType, join));
    }

    private int getPrimaryKeyOffset(JDBCFeatureSource featureSource, PrimaryKey pk, SimpleFeatureType featureType) {
        int pkSize = pk.getColumns().size();
        if (!featureSource.isExposePrimaryKeyColumns()) {
            return pkSize;
        }
        int requestedPkColumns = 0;
        for (AttributeDescriptor ad : featureType.getAttributeDescriptors()) {
            if (ad.getUserData().get("org.geotools.jdbc.pk.column") != Boolean.TRUE) continue;
            ++requestedPkColumns;
        }
        return pkSize - requestedPkColumns;
    }

    @Override
    public boolean hasNext() throws IOException {
        boolean next = super.hasNext();
        for (JDBCFeatureReader r : this.joinReaders) {
            r.setNext(next);
        }
        return next;
    }

    @Override
    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        SimpleFeature f = super.next();
        this.joinFeatureBuilder.init(f);
        f = this.joinFeatureBuilder.buildFeature(f.getID());
        for (int i = 0; i < this.joinReaders.size(); ++i) {
            JDBCFeatureReader r = this.joinReaders.get(i);
            f.setAttribute(f.getAttributeCount() - this.joinReaders.size() + i, (Object)r.next());
        }
        return f;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    static SimpleFeatureType retype(SimpleFeatureType featureType, JoinInfo join) {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.init(featureType);
        for (JoinInfo.JoinPart part : join.getParts()) {
            b.add(part.getAttributeName(), SimpleFeature.class);
        }
        return b.buildFeatureType();
    }
}

