/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.inspireatom.harvester;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.EnhancedPatternLayout;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Priority;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Logger;
import org.fao.geonet.constants.Geonet;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.InspireAtomFeed;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.inspireatom.model.DatasetFeedInfo;
import org.fao.geonet.inspireatom.util.InspireAtomUtil;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.InspireAtomFeedRepository;
import org.fao.geonet.repository.specification.InspireAtomFeedSpecs;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;

public class InspireAtomHarvester {
    private static final String EXTRACT_DATASETS_FROM_SERVICE_XSLT = "extract-datasetinfo-from-service-feed.xsl";
    private static final String EXTRACT_DATASET_ID_XSLT = "extract-datasetid.xsl";
    private Logger logger = Log.createLogger((String)"geonetwork.atom");
    private GeonetContext gc;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm");

    public InspireAtomHarvester(GeonetContext geonetGontext) {
        this.gc = geonetGontext;
    }

    public final Element harvest() {
        this.initializeLog();
        SearchManager searchManager = (SearchManager)this.gc.getBean(SearchManager.class);
        SettingManager sm = (SettingManager)this.gc.getBean(SettingManager.class);
        DataManager dataMan = (DataManager)this.gc.getBean(DataManager.class);
        InspireAtomFeedRepository repository = (InspireAtomFeedRepository)this.gc.getBean(InspireAtomFeedRepository.class);
        String atomProtocol = sm.getValue("system/inspire/atomProtocol");
        List<AbstractMetadata> iso19139Metadata = InspireAtomUtil.searchMetadataByTypeAndProtocol(ServiceContext.get(), searchManager, "service", atomProtocol);
        Element result = new Element("response");
        try {
            this.logger.info("ATOM feed harvest started");
            this.logger.info("ATOM feed harvest: remove existing metadata feeds");
            repository.deleteAll();
            this.logger.info("ATOM feed harvest: retrieving service metadata feeds");
            Map<String, String> serviceMetadataWithAtomFeeds = InspireAtomUtil.retrieveServiceMetadataWithAtomFeeds(dataMan, iso19139Metadata, atomProtocol);
            this.logger.info("ATOM feed harvest: processing service metadata feeds (" + serviceMetadataWithAtomFeeds.size() + ")");
            List<DatasetFeedInfo> datasetsInformation = this.processServiceMetadataFeeds(dataMan, serviceMetadataWithAtomFeeds, result);
            this.logger.info("ATOM feed harvest : processing dataset metadata feeds (" + datasetsInformation.size() + ")");
            this.processDatasetsMetadataFeeds(dataMan, datasetsInformation, result);
            this.logger.info("ATOM feed harvest finished");
        }
        catch (Exception x) {
            this.logger.error("ATOM feed harvest error: " + x.getMessage());
            this.logger.error((Throwable)x);
            result.addContent((Content)new Element("error").setText(x.getMessage()));
        }
        return result;
    }

    public final void harvestServiceMetadata(ServiceContext context, String metadataId) {
        Logger logger = Log.createLogger((String)"geonetwork.atom");
        InspireAtomFeedRepository repository = (InspireAtomFeedRepository)context.getBean(InspireAtomFeedRepository.class);
        DataManager dataMan = (DataManager)context.getBean(DataManager.class);
        SettingManager sm = (SettingManager)context.getBean(SettingManager.class);
        IMetadataUtils metadataUtils = (IMetadataUtils)this.gc.getBean(IMetadataUtils.class);
        AbstractMetadata iso19139Metadata = metadataUtils.findOne((Specification)Specifications.where((Specification)MetadataSpecs.isType((MetadataType)MetadataType.METADATA)).and(MetadataSpecs.isIso19139Schema()).and(MetadataSpecs.hasMetadataId((int)Integer.parseInt(metadataId))));
        Element result = new Element("response");
        try {
            logger.info("ATOM feed harvest started for metadata: " + metadataId);
            String atomProtocol = sm.getValue("system/inspire/atomProtocol");
            logger.info("ATOM feed harvest: remove existing metadata feed");
            repository.deleteAll(InspireAtomFeedSpecs.hasMetadataId((int)Integer.parseInt(metadataId)));
            dataMan.indexMetadata(Arrays.asList(metadataId));
            logger.info("ATOM feed harvest: processing service metadata feeds");
            Map<String, String> serviceMetadataWithAtomFeed = InspireAtomUtil.retrieveServiceMetadataWithAtomFeed(dataMan, iso19139Metadata, atomProtocol);
            List<DatasetFeedInfo> datasetsInformation = this.processServiceMetadataFeeds(dataMan, serviceMetadataWithAtomFeed, result);
            logger.info("ATOM feed harvest for metadata: " + metadataId + ",  processing dataset metadata feeds");
            this.processDatasetsMetadataFeeds(context, dataMan, datasetsInformation, result);
            logger.info("ATOM feed harvest finished for metadata: " + metadataId);
        }
        catch (Exception x) {
            logger.error("ATOM feed harvest error: " + x.getMessage());
            logger.error((Throwable)x);
        }
    }

    private List<DatasetFeedInfo> processServiceMetadataFeeds(DataManager dataMan, Map<String, String> serviceMetadataWithAtomFeeds, Element result) throws Exception {
        ArrayList<DatasetFeedInfo> datasetsInformation = new ArrayList<DatasetFeedInfo>();
        InspireAtomFeedRepository repository = (InspireAtomFeedRepository)this.gc.getBean(InspireAtomFeedRepository.class);
        long total = serviceMetadataWithAtomFeeds.entrySet().size();
        long i = 1L;
        for (Map.Entry<String, String> entry : serviceMetadataWithAtomFeeds.entrySet()) {
            String metadataId = entry.getKey();
            String metadataUuid = dataMan.getMetadataUuid(metadataId);
            try {
                this.logger.info("Processing feed (" + i++ + "/" + total + ") for service metadata with uuid:" + metadataUuid);
                String atomUrl = entry.getValue();
                this.logger.debug("Atom feed Url for service metadata (" + metadataUuid + "): " + atomUrl);
                String atomFeedDocument = InspireAtomUtil.retrieveRemoteAtomFeedDocument(this.gc, atomUrl);
                this.logger.debug("Atom feed Document for service metadata (" + metadataUuid + "): " + atomFeedDocument);
                Element atomDoc = Xml.loadString((String)atomFeedDocument, (boolean)false);
                if (!atomDoc.getNamespace().equals((Object)Geonet.Namespaces.ATOM)) {
                    this.logger.warning("Atom feed Document (" + atomUrl + ") for service metadata (" + metadataUuid + ") is not a valid feed");
                    continue;
                }
                InspireAtomFeed inspireAtomFeed = InspireAtomFeed.build((Element)atomDoc);
                inspireAtomFeed.setMetadataId(Integer.valueOf(Integer.parseInt(metadataId)));
                inspireAtomFeed.setAtomUrl(atomUrl);
                inspireAtomFeed.setAtom(atomFeedDocument);
                inspireAtomFeed.setAtomDatasetid("");
                inspireAtomFeed.setAtomDatasetns("");
                repository.save((Object)inspireAtomFeed);
                dataMan.indexMetadata(Arrays.asList(metadataId));
                this.logger.debug("Extract datasets information (identifier, namespace) from service atom feed  (" + atomUrl + ")");
                datasetsInformation.addAll(InspireAtomUtil.extractRelatedDatasetsInfoFromServiceFeed(atomFeedDocument, dataMan));
                result.addContent((Content)new Element("feed").setAttribute("uuid", metadataUuid).setAttribute("feed", atomUrl).setAttribute("status", "ok"));
            }
            catch (Exception ex) {
                this.logger.error("Failed to process atom feed for service metadata: " + metadataUuid + " " + ex.getMessage());
                this.logger.error((Throwable)ex);
                result.addContent((Content)new Element("feed").setAttribute("uuid", metadataUuid).setAttribute("error", ex.getMessage()).setAttribute("status", "error"));
            }
        }
        return datasetsInformation;
    }

    private void processDatasetsMetadataFeeds(DataManager dataMan, List<DatasetFeedInfo> datasetsFeedInformation, Element result) throws Exception {
        this.processDatasetsMetadataFeeds(ServiceContext.get(), dataMan, datasetsFeedInformation, result);
    }

    private void processDatasetsMetadataFeeds(ServiceContext context, DataManager dataMan, List<DatasetFeedInfo> datasetsFeedInformation, Element result) throws Exception {
        InspireAtomFeedRepository repository = (InspireAtomFeedRepository)this.gc.getBean(InspireAtomFeedRepository.class);
        long total = datasetsFeedInformation.size();
        long i = 1L;
        for (DatasetFeedInfo datasetFeedInfo : datasetsFeedInformation) {
            String metadataUuid = "";
            try {
                metadataUuid = InspireAtomUtil.retrieveDatasetUuidFromIdentifier(ServiceContext.get(), (SearchManager)this.gc.getBean(SearchManager.class), datasetFeedInfo.identifier);
                String atomUrl = datasetFeedInfo.feedUrl;
                this.logger.info("Processing feed (" + i++ + "/" + total + ") for dataset metadata with uuid:" + metadataUuid + ", feed url: " + atomUrl);
                if (StringUtils.isEmpty((String)metadataUuid)) {
                    this.logger.warning("Metadata with dataset identifier (" + datasetFeedInfo.identifier + ") is not available. Skip dataset feed processing");
                    continue;
                }
                if (!atomUrl.toLowerCase().endsWith(".xml")) {
                    this.logger.warning("Atom feed Document (" + atomUrl + ") for dataset metadata (" + metadataUuid + ") is not a valid feed");
                    continue;
                }
                String metadataId = dataMan.getMetadataId(metadataUuid);
                this.logger.debug("Dataset, id=" + datasetFeedInfo.identifier + ", namespace=" + datasetFeedInfo.namespace);
                String atomFeedDocument = InspireAtomUtil.retrieveRemoteAtomFeedDocument(this.gc, atomUrl);
                this.logger.debug("Dataset feed: " + atomFeedDocument);
                Element atomDoc = Xml.loadString((String)atomFeedDocument, (boolean)false);
                if (!atomDoc.getNamespace().equals((Object)Geonet.Namespaces.ATOM)) {
                    this.logger.warning("Atom feed Document (" + atomUrl + ") for dataset metadata (" + metadataUuid + ") is not a valid feed");
                    continue;
                }
                InspireAtomFeed inspireAtomFeed = InspireAtomFeed.build((Element)atomDoc);
                inspireAtomFeed.setMetadataId(Integer.valueOf(Integer.parseInt(metadataId)));
                inspireAtomFeed.setAtomDatasetid(datasetFeedInfo.identifier);
                inspireAtomFeed.setAtomDatasetns(datasetFeedInfo.namespace);
                inspireAtomFeed.setAtomUrl(atomUrl);
                inspireAtomFeed.setAtom(atomFeedDocument);
                repository.save((Object)inspireAtomFeed);
                dataMan.indexMetadata(Arrays.asList(metadataId));
                result.addContent((Content)new Element("feed").setAttribute("uuid", metadataUuid).setAttribute("feed", atomUrl).setAttribute("status", "ok"));
            }
            catch (Exception ex) {
                this.logger.error("Failed to process atom feed for dataset metadata: " + metadataUuid + " " + ex.getMessage());
                this.logger.error((Throwable)ex);
                result.addContent((Content)new Element("feed").setAttribute("uuid", metadataUuid).setAttribute("error", ex.getMessage()).setAttribute("status", "error"));
            }
        }
    }

    private void processDatasetsMetadataFeedsForService(ServiceContext context, DataManager dataMan, List<DatasetFeedInfo> datasetsFeedInformation, Element result) throws Exception {
        String atomProtocol = ((SettingManager)this.gc.getBean(SettingManager.class)).getValue("system/inspire/atomProtocol");
        InspireAtomFeedRepository repository = (InspireAtomFeedRepository)this.gc.getBean(InspireAtomFeedRepository.class);
        for (DatasetFeedInfo datasetFeedInfo : datasetsFeedInformation) {
            String atomDatasetId = datasetFeedInfo.identifier;
            String metadataUuid = "";
            try {
                metadataUuid = InspireAtomUtil.retrieveDatasetUuidFromIdentifier(context, (SearchManager)this.gc.getBean(SearchManager.class), atomDatasetId);
                String atomDatasetNs = datasetFeedInfo.namespace;
                this.logger.debug("Dataset, id=" + atomDatasetId + ", namespace=" + atomDatasetNs);
                if (StringUtils.isEmpty((String)metadataUuid)) {
                    this.logger.warning("Can't find dataset metadata with datasetIdCode:" + atomDatasetId);
                    continue;
                }
                this.logger.info("Processing feed for dataset metadata with uuid:" + metadataUuid);
                String metadataId = dataMan.getMetadataId(metadataUuid);
                String atomUrl = datasetFeedInfo.feedUrl;
                this.logger.debug("Dataset, feedurl=" + atomUrl);
                String atomFeedDocument = InspireAtomUtil.retrieveRemoteAtomFeedDocument(this.gc, atomUrl);
                this.logger.debug("Dataset feed: " + atomFeedDocument);
                Element atomDoc = Xml.loadString((String)atomFeedDocument, (boolean)false);
                if (!atomDoc.getNamespace().equals((Object)Geonet.Namespaces.ATOM)) {
                    this.logger.warning("Atom feed Document (" + atomUrl + ") for dataset metadata (" + metadataUuid + ") is not a valid feed");
                    continue;
                }
                InspireAtomFeed inspireAtomFeed = InspireAtomFeed.build((Element)atomDoc);
                inspireAtomFeed.setMetadataId(Integer.valueOf(Integer.parseInt(metadataId)));
                inspireAtomFeed.setAtomDatasetid(atomDatasetId);
                inspireAtomFeed.setAtomDatasetns(atomDatasetNs);
                inspireAtomFeed.setAtomUrl(atomUrl);
                inspireAtomFeed.setAtom(atomFeedDocument);
                repository.save((Object)inspireAtomFeed);
                dataMan.indexMetadata(Arrays.asList(metadataId));
                result.addContent((Content)new Element("feed").setAttribute("uuid", metadataUuid).setAttribute("feed", atomUrl).setAttribute("status", "ok"));
            }
            catch (Exception ex) {
                this.logger.error("Failed to process atom feed for dataset metadata: " + metadataUuid + " " + ex.getMessage());
                result.addContent((Content)new Element("feed").setAttribute("uuid", metadataUuid).setAttribute("error", ex.getMessage()).setAttribute("status", "error"));
            }
        }
    }

    private String initializeLog() {
        File d;
        String packagename = this.getClass().getPackage().getName();
        String[] packages = packagename.split("\\.");
        String packageType = packages[packages.length - 1];
        String harvesterName = "inspireatom";
        this.logger = Log.createLogger((String)"inspireatom", (String)"geonetwork.atom");
        String directory = this.logger.getFileAppender();
        if (directory == null || directory.isEmpty()) {
            directory = ((GeonetworkDataDirectory)this.gc.getBean(GeonetworkDataDirectory.class)).getSystemDataDir() + "/harvester_logs/";
        }
        if (!(d = new File(directory)).isDirectory()) {
            directory = d.getParent() + File.separator;
        }
        FileAppender fa = new FileAppender();
        fa.setName("inspireatom");
        String logfile = directory + "atomharvester_" + packageType + "_" + this.dateFormat.format(new Date(System.currentTimeMillis())) + ".log";
        fa.setFile(logfile);
        SettingManager settingManager = (SettingManager)this.gc.getBean(SettingManager.class);
        String timeZoneSetting = settingManager.getValue("system/server/timeZone");
        if (StringUtils.isBlank((String)timeZoneSetting)) {
            timeZoneSetting = TimeZone.getDefault().getID();
        }
        fa.setLayout((Layout)new EnhancedPatternLayout("%d{yyyy-MM-dd'T'HH:mm:ss,SSSZ}{" + timeZoneSetting + "} %-5p [%c] - %m%n"));
        fa.setThreshold((Priority)this.logger.getThreshold());
        fa.setAppend(true);
        fa.activateOptions();
        this.logger.setAppender(fa);
        return logfile;
    }
}

