/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.IntCollection;
import bak.pcj.hash.DefaultByteHashFunction;
import bak.pcj.hash.DefaultIntHashFunction;
import bak.pcj.map.ByteKeyIntMap;
import bak.pcj.map.ByteKeyIntMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.ByteSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractByteKeyIntMap
implements ByteKeyIntMap {
    protected AbstractByteKeyIntMap() {
    }

    public void clear() {
        ByteKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public int remove(byte key) {
        ByteKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            int value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultInt();
    }

    public void putAll(ByteKeyIntMap map) {
        ByteKeyIntMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(byte key) {
        ByteKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public int get(byte key) {
        ByteKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultInt();
    }

    public boolean containsValue(int value) {
        ByteKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ByteKeyIntMap)) {
            return false;
        }
        ByteKeyIntMap map = (ByteKeyIntMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        ByteKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            byte k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        ByteKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultByteHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultIntHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        ByteKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public int tget(byte key) {
        int value = this.get(key);
        if (value == MapDefaults.defaultInt() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        ByteKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract IntCollection values();

    public abstract int put(byte var1, int var2);

    public abstract int lget();

    public abstract ByteSet keySet();

    public abstract ByteKeyIntMapIterator entries();
}

