/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.datasources;

import javax.sql.PooledConnection;
import org.apache.commons.dbcp2.Utils;
import org.apache.commons.dbcp2.datasources.UserPassKey;

final class PooledConnectionAndInfo {
    private final PooledConnection pooledConnection;
    private final char[] userPassword;
    private final String userName;
    private final UserPassKey upKey;

    PooledConnectionAndInfo(PooledConnection pc, String userName, char[] userPassword) {
        this.pooledConnection = pc;
        this.userName = userName;
        this.userPassword = userPassword;
        this.upKey = new UserPassKey(userName, userPassword);
    }

    @Deprecated
    PooledConnectionAndInfo(PooledConnection pc, String userName, String userPassword) {
        this(pc, userName, Utils.toCharArray(userPassword));
    }

    PooledConnection getPooledConnection() {
        return this.pooledConnection;
    }

    UserPassKey getUserPassKey() {
        return this.upKey;
    }

    String getPassword() {
        return Utils.toString(this.userPassword);
    }

    char[] getPasswordCharArray() {
        return this.userPassword;
    }

    String getUsername() {
        return this.userName;
    }
}

