/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.web;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.fao.geonet.DatabaseMigrationTask;
import org.fao.geonet.kernel.search.log.LuceneQueryParamType;
import org.fao.geonet.kernel.search.log.QueryRequest;
import org.fao.geonet.kernel.search.log.SearchRequestParam;
import org.fao.geonet.kernel.search.log.SearcherLogger;
import org.fao.geonet.utils.Log;
import org.joda.time.DateTime;

public class SearchStatisticsDatabaseMigration
extends DatabaseMigrationTask {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Connection connection) throws SQLException {
        Log.debug((String)"geonetwork.database", (Object)"SearchStatisticsDatabaseMigration");
        SearcherLogger searcherLogger = (SearcherLogger)this.applicationContext.getBean(SearcherLogger.class);
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT id, requestdate, ip, query, hits, lang, sortby, spatialfilter, type, service, autogenerated, simple FROM requests");){
            while (resultSet.next()) {
                int id = resultSet.getInt(1);
                QueryRequest queryRequest = new QueryRequest(resultSet.getString(3), new DateTime((Object)resultSet.getString(2)).toDate().getTime());
                ArrayList<SearchRequestParam> queryInfos = new ArrayList<SearchRequestParam>();
                try (PreparedStatement paramsResultStm = null;){
                    paramsResultStm = connection.prepareStatement("SELECT id, requestid, querytype, termfield, termtext, similarity, lowertext, uppertext, inclusive FROM params WHERE requestid=?");
                    paramsResultStm.setInt(1, id);
                    ResultSet paramsResultSet = paramsResultStm.executeQuery();
                    while (paramsResultSet.next()) {
                        String term = paramsResultSet.getString(4);
                        if (LuceneQueryParamType.isExcludedField(term)) continue;
                        SearchRequestParam searchRequestParam = new SearchRequestParam();
                        searchRequestParam.setId(paramsResultSet.getInt(1));
                        searchRequestParam.setTermField(paramsResultSet.getString(4));
                        searchRequestParam.setTermText(paramsResultSet.getString(5));
                        searchRequestParam.setSimilarity(paramsResultSet.getInt(6));
                        searchRequestParam.setLowerText(paramsResultSet.getString(7));
                        searchRequestParam.setUpperText(paramsResultSet.getString(8));
                        searchRequestParam.setInclusive(paramsResultSet.getBoolean(9));
                        queryInfos.add(searchRequestParam);
                    }
                }
                queryRequest.setQueryInfos(queryInfos);
                queryRequest.setHits(resultSet.getInt(5));
                queryRequest.setService(resultSet.getString(10));
                queryRequest.setLanguage(resultSet.getString(6));
                queryRequest.setLuceneQuery(resultSet.getString(4));
                queryRequest.setSortBy(resultSet.getString(7));
                queryRequest.setSpatialFilter(resultSet.getString(8));
                queryRequest.isSimpleQuery();
                if (!queryRequest.storeToEs(searcherLogger.getIndex(), searcherLogger.getIndexType())) {
                    Log.warning((String)"geonetwork.search-logger", (Object)"unable to log query into database...");
                    continue;
                }
                if (!Log.isDebugEnabled((String)"geonetwork.search-logger")) continue;
                Log.debug((String)"geonetwork.search-logger", (Object)"Query saved to database");
            }
        }
    }
}

