/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.url;

import java.io.Serializable;
import java.util.Objects;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Link;
import org.fao.geonet.domain.LinkStatus;
import org.fao.geonet.domain.Link_;
import org.fao.geonet.domain.MetadataLink;
import org.fao.geonet.domain.MetadataLink_;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.schema.LinkAwareSchemaPlugin;
import org.fao.geonet.kernel.schema.LinkPatternStreamer.ILinkBuilder;
import org.fao.geonet.kernel.schema.SchemaPlugin;
import org.fao.geonet.kernel.url.UrlChecker;
import org.fao.geonet.repository.LinkRepository;
import org.fao.geonet.repository.LinkStatusRepository;
import org.fao.geonet.repository.MetadataLinkRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;

public class UrlAnalyzer {
    @Autowired
    protected SchemaManager schemaManager;
    @Autowired
    protected MetadataRepository metadataRepository;
    @PersistenceContext
    protected EntityManager entityManager;
    @Autowired
    protected UrlChecker urlChecker;
    @Autowired
    protected LinkRepository linkRepository;
    @Autowired
    protected LinkStatusRepository linkStatusRepository;
    @Autowired
    protected MetadataLinkRepository metadataLinkRepository;

    public void processMetadata(Element element, AbstractMetadata md) throws JDOMException {
        SchemaPlugin schemaPlugin = this.schemaManager.getSchema(md.getDataInfo().getSchemaId()).getSchemaPlugin();
        if (schemaPlugin instanceof LinkAwareSchemaPlugin) {
            this.metadataLinkRepository.findAll(this.metadatalinksTargetting(md)).stream().forEach(metadatalink -> metadatalink.getLink().getRecords().remove(metadatalink));
            this.entityManager.flush();
            ((LinkAwareSchemaPlugin)schemaPlugin).createLinkStreamer((ILinkBuilder)new ILinkBuilder<Link, AbstractMetadata>(){

                public Link found(String url) {
                    Link link = UrlAnalyzer.this.linkRepository.findOneByUrl(url);
                    if (link != null) {
                        return link;
                    }
                    link = new Link();
                    link.setUrl(url);
                    UrlAnalyzer.this.linkRepository.save((Object)link);
                    return link;
                }

                public void persist(Link link, AbstractMetadata metadata) {
                    MetadataLink metadataLink = new MetadataLink();
                    metadataLink.setMetadataId(new Integer(metadata.getId()));
                    metadataLink.setMetadataUuid(metadata.getUuid());
                    metadataLink.setLink(link);
                    link.getRecords().add(metadataLink);
                    UrlAnalyzer.this.linkRepository.save((Object)link);
                }
            }).processAllRawText(element, (Object)md);
            this.entityManager.flush();
        }
    }

    public void purgeMetataLink(Link link) {
        this.metadataLinkRepository.findAll(this.metadatalinksTargetting(link)).stream().filter(metadatalink -> this.isReferencingAnUnknownMetadata((MetadataLink)metadatalink)).forEach(arg_0 -> ((MetadataLinkRepository)this.metadataLinkRepository).delete(arg_0));
        this.entityManager.flush();
    }

    public void deleteAll() {
        this.metadataLinkRepository.deleteAllInBatch();
        this.linkStatusRepository.deleteAllInBatch();
        this.linkRepository.deleteAllInBatch();
        this.entityManager.clear();
    }

    public void testLink(Link link) {
        LinkStatus linkStatus = this.urlChecker.getUrlStatus(link.getUrl());
        link.addStatus(linkStatus);
        this.linkRepository.save((Object)link);
    }

    private Specification<MetadataLink> metadatalinksTargetting(final Link link) {
        return new Specification<MetadataLink>(){

            public Predicate toPredicate(Root<MetadataLink> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                return criteriaBuilder.equal((Expression)root.get(MetadataLink_.link).get(Link_.id), (Object)link.getId());
            }
        };
    }

    private Specification<MetadataLink> metadatalinksTargetting(final AbstractMetadata md) {
        return new Specification<MetadataLink>(){

            public Predicate toPredicate(Root<MetadataLink> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                return criteriaBuilder.equal((Expression)root.get(MetadataLink_.metadataId), (Object)md.getId());
            }
        };
    }

    private boolean isReferencingAnUnknownMetadata(MetadataLink metadatalink) {
        return Objects.isNull(this.metadataRepository.findOne((Serializable)metadatalink.getMetadataId()));
    }
}

