/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import bak.pcj.set.IntBitSet;
import bak.pcj.set.IntSet;
import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.DocIdBitSet;

public class DuplicateDocFilter
extends Filter {
    final IntSet hits = new IntBitSet();
    private Query _query;

    public DuplicateDocFilter(Query query) {
        this._query = query;
    }

    public Query getQuery() {
        return this._query;
    }

    public void setQuery(Query query) {
        this._query = query;
    }

    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        AtomicReader reader = context.reader();
        final BitSet bits = new BitSet(reader.maxDoc());
        final FieldCache.Ints mdIds = FieldCache.DEFAULT.getInts(reader, "_id", false);
        new IndexSearcher((IndexReader)reader).search(this._query, new Collector(){
            private int docBase;

            public void setScorer(Scorer scorer) throws IOException {
            }

            public void setNextReader(AtomicReaderContext context) throws IOException {
                this.docBase = context.docBase;
            }

            public void collect(int doc) throws IOException {
                try {
                    int id = mdIds.get(this.docBase + doc);
                    if (!DuplicateDocFilter.this.hits.contains(id)) {
                        bits.set(this.docBase + doc);
                        DuplicateDocFilter.this.hits.add(id);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public boolean acceptsDocsOutOfOrder() {
                return true;
            }
        });
        return new DocIdBitSet(bits);
    }
}

