/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.admin;

import org.openrdf.model.Statement;
import org.openrdf.sesame.admin.AdminListener;

public class StdOutAdminListener
implements AdminListener {
    public void transactionStart() {
        System.out.println("Transaction started.");
    }

    public void transactionEnd() {
        System.out.println("Transaction finished.");
    }

    public void status(String msg, int lineNo, int colNo) {
        System.out.println("[status ] " + this._createMessage(msg, lineNo, colNo, null));
    }

    public void notification(String msg, int lineNo, int colNo, Statement statement) {
        System.out.println("[notify ] " + this._createMessage(msg, lineNo, colNo, statement));
    }

    public void warning(String msg, int lineNo, int colNo, Statement statement) {
        System.out.println("[WARNING] " + this._createMessage(msg, lineNo, colNo, statement));
    }

    public void error(String msg, int lineNo, int colNo, Statement statement) {
        System.out.println("[ERROR  ] " + this._createMessage(msg, lineNo, colNo, statement));
    }

    private String _createMessage(String msg, int lineNo, int colNo, Statement statement) {
        StringBuffer result = new StringBuffer();
        if (lineNo != -1) {
            result.append("(");
            result.append(lineNo);
            result.append(", ");
            result.append(colNo);
            result.append(")");
        }
        result.append(": ");
        result.append(msg);
        if (statement != null) {
            result.append("\n  -> subject  : " + statement.getSubject());
            result.append("\n  -> predicate: " + statement.getPredicate());
            result.append("\n  -> object   : " + statement.getObject());
        }
        return result.toString();
    }
}

