/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.parsing.Annotation;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.JsDocToken;
import com.google.javascript.jscomp.parsing.JsDocTokenStream;
import com.google.javascript.jscomp.parsing.NullErrorReporter;
import com.google.javascript.jscomp.parsing.TypeTransformationParser;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.SimpleErrorReporter;
import com.google.javascript.rhino.StaticSourceFile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class JsDocInfoParser {
    private final JsDocTokenStream stream;
    private final JSDocInfoBuilder jsdocBuilder;
    private final StaticSourceFile sourceFile;
    private final ErrorReporter errorReporter;
    private final ErrorReporterParser parser = new ErrorReporterParser();
    private final Node templateNode;
    private JSDocInfo fileOverviewJSDocInfo = null;
    private State state;
    private final Map<String, Annotation> annotationNames;
    private final Set<String> suppressionNames;
    private static final Set<String> modifiesAnnotationKeywords = ImmutableSet.of((Object)"this", (Object)"arguments");
    private static final Set<String> idGeneratorAnnotationKeywords = ImmutableSet.of((Object)"unique", (Object)"consistent", (Object)"stable", (Object)"mapped");
    private JSDocInfoBuilder fileLevelJsDocBuilder;
    private static final JsDocToken NO_UNREAD_TOKEN = null;
    private JsDocToken unreadToken = NO_UNREAD_TOKEN;

    void setFileLevelJsDocBuilder(JSDocInfoBuilder fileLevelJsDocBuilder) {
        this.fileLevelJsDocBuilder = fileLevelJsDocBuilder;
    }

    void setFileOverviewJSDocInfo(JSDocInfo fileOverviewJSDocInfo) {
        this.fileOverviewJSDocInfo = fileOverviewJSDocInfo;
    }

    JsDocInfoParser(JsDocTokenStream stream, String comment, int commentPosition, StaticSourceFile sourceFile, Config config, ErrorReporter errorReporter) {
        this.stream = stream;
        this.sourceFile = sourceFile;
        this.jsdocBuilder = new JSDocInfoBuilder(config.parseJsDocDocumentation);
        if (comment != null) {
            this.jsdocBuilder.recordOriginalCommentString(comment);
            this.jsdocBuilder.recordOriginalCommentPosition(commentPosition);
        }
        this.annotationNames = config.annotationNames;
        this.suppressionNames = config.suppressionNames;
        this.errorReporter = errorReporter;
        this.templateNode = this.createTemplateNode();
    }

    private String getSourceName() {
        return this.sourceFile == null ? null : this.sourceFile.getName();
    }

    public JSDocInfo parseInlineTypeDoc() {
        this.skipEOLs();
        JsDocToken token = this.next();
        int lineno = this.stream.getLineno();
        int startCharno = this.stream.getCharno();
        Node typeAst = this.parseParamTypeExpression(token);
        this.recordTypeNode(lineno, startCharno, typeAst, token == JsDocToken.LEFT_CURLY);
        JSTypeExpression expr = this.createJSTypeExpression(typeAst);
        if (expr != null) {
            this.jsdocBuilder.recordType(expr);
            this.jsdocBuilder.recordInlineType();
            return this.retrieveAndResetParsedJSDocInfo();
        }
        return null;
    }

    private void recordTypeNode(int lineno, int startCharno, Node typeAst, boolean matchingLC) {
        if (typeAst != null) {
            int endLineno = this.stream.getLineno();
            int endCharno = this.stream.getCharno();
            this.jsdocBuilder.markTypeNode(typeAst, lineno, startCharno, endLineno, endCharno, matchingLC);
        }
    }

    public static Node parseTypeString(String typeString) {
        Config config = new Config(new HashSet<String>(), new HashSet<String>(), false, Config.LanguageMode.ECMASCRIPT3, false);
        JsDocInfoParser parser = new JsDocInfoParser(new JsDocTokenStream(typeString), typeString, 0, null, config, NullErrorReporter.forOldRhino());
        return parser.parseTopLevelTypeExpression(parser.next());
    }

    boolean parse() {
        this.state = State.SEARCHING_ANNOTATION;
        this.skipEOLs();
        JsDocToken token = this.next();
        if (this.jsdocBuilder.shouldParseDocumentation()) {
            ExtractionInfo blockInfo = this.extractBlockComment(token);
            token = blockInfo.token;
            if (!blockInfo.string.isEmpty()) {
                this.jsdocBuilder.recordBlockDescription(blockInfo.string);
            }
        } else if (token != JsDocToken.ANNOTATION && token != JsDocToken.EOC) {
            this.jsdocBuilder.recordBlockDescription("");
        }
        return this.parseHelperLoop(token, new ArrayList<ExtendedTypeInfo>());
    }

    private boolean parseHelperLoop(JsDocToken token, List<ExtendedTypeInfo> extendedTypes) {
        block9: while (true) {
            switch (token) {
                case ANNOTATION: {
                    if (this.state == State.SEARCHING_ANNOTATION) {
                        this.state = State.SEARCHING_NEWLINE;
                        token = this.parseAnnotation(token, extendedTypes);
                        continue block9;
                    }
                    token = this.next();
                    continue block9;
                }
                case EOC: {
                    boolean success = true;
                    this.checkExtendedTypes(extendedTypes);
                    if (this.hasParsedFileOverviewDocInfo()) {
                        this.fileOverviewJSDocInfo = this.retrieveAndResetParsedJSDocInfo();
                        JSDocInfo.Visibility visibility = this.fileOverviewJSDocInfo.getVisibility();
                        switch (visibility) {
                            case PRIVATE: 
                            case PROTECTED: {
                                this.parser.addParserWarning("msg.bad.fileoverview.visibility.annotation", visibility.toString().toLowerCase(), this.stream.getLineno(), this.stream.getCharno());
                                success = false;
                                break;
                            }
                        }
                    }
                    return success;
                }
                case EOF: {
                    this.jsdocBuilder.build();
                    this.parser.addParserWarning("msg.unexpected.eof", this.stream.getLineno(), this.stream.getCharno());
                    this.checkExtendedTypes(extendedTypes);
                    return false;
                }
                case EOL: {
                    if (this.state == State.SEARCHING_NEWLINE) {
                        this.state = State.SEARCHING_ANNOTATION;
                    }
                    token = this.next();
                    continue block9;
                }
            }
            if (token == JsDocToken.STAR && this.state == State.SEARCHING_ANNOTATION) {
                token = this.next();
                continue;
            }
            this.state = State.SEARCHING_NEWLINE;
            token = this.eatTokensUntilEOL();
        }
    }

    private JsDocToken parseAnnotation(JsDocToken token, List<ExtendedTypeInfo> extendedTypes) {
        int lineno = this.stream.getLineno();
        int charno = this.stream.getCharno();
        String annotationName = this.stream.getString();
        Annotation annotation = this.annotationNames.get(annotationName);
        if (annotation == null) {
            this.parser.addParserWarning("msg.bad.jsdoc.tag", annotationName, this.stream.getLineno(), this.stream.getCharno());
        } else {
            this.jsdocBuilder.markAnnotation(annotationName, lineno, charno);
            switch (annotation) {
                case NG_INJECT: {
                    if (this.jsdocBuilder.isNgInjectRecorded()) {
                        this.parser.addParserWarning("msg.jsdoc.nginject.extra", this.stream.getLineno(), this.stream.getCharno());
                    } else {
                        this.jsdocBuilder.recordNgInject(true);
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case JAGGER_INJECT: {
                    if (this.jsdocBuilder.isJaggerInjectRecorded()) {
                        this.parser.addParserWarning("msg.jsdoc.jaggerInject.extra", this.stream.getLineno(), this.stream.getCharno());
                    } else {
                        this.jsdocBuilder.recordJaggerInject(true);
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case JAGGER_MODULE: {
                    if (this.jsdocBuilder.isJaggerModuleRecorded()) {
                        this.parser.addParserWarning("msg.jsdoc.jaggerModule.extra", this.stream.getLineno(), this.stream.getCharno());
                    } else {
                        this.jsdocBuilder.recordJaggerModule(true);
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case JAGGER_PROVIDE: {
                    if (this.jsdocBuilder.isJaggerProvideRecorded()) {
                        this.parser.addParserWarning("msg.jsdoc.jaggerProvide.extra", this.stream.getLineno(), this.stream.getCharno());
                    } else {
                        this.jsdocBuilder.recordJaggerProvide(true);
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case JAGGER_PROVIDE_PROMISE: {
                    if (this.jsdocBuilder.isJaggerProvidePromiseRecorded()) {
                        this.parser.addParserWarning("msg.jsdoc.jaggerProvidePromise.extra", this.stream.getLineno(), this.stream.getCharno());
                    } else {
                        this.jsdocBuilder.recordJaggerProvidePromise(true);
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case AUTHOR: {
                    if (this.jsdocBuilder.shouldParseDocumentation()) {
                        ExtractionInfo authorInfo = this.extractSingleLineBlock();
                        String author = authorInfo.string;
                        if (author.isEmpty()) {
                            this.parser.addParserWarning("msg.jsdoc.authormissing", this.stream.getLineno(), this.stream.getCharno());
                        } else {
                            this.jsdocBuilder.addAuthor(author);
                        }
                        token = authorInfo.token;
                    } else {
                        token = this.eatUntilEOLIfNotAnnotation();
                    }
                    return token;
                }
                case CONSISTENTIDGENERATOR: {
                    if (!this.jsdocBuilder.recordConsistentIdGenerator()) {
                        this.parser.addParserWarning("msg.jsdoc.consistidgen", this.stream.getLineno(), this.stream.getCharno());
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case UNRESTRICTED: {
                    if (!this.jsdocBuilder.recordUnrestricted()) {
                        this.parser.addTypeWarning("msg.jsdoc.incompat.type", this.stream.getLineno(), this.stream.getCharno());
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case STRUCT: {
                    if (!this.jsdocBuilder.recordStruct()) {
                        this.parser.addTypeWarning("msg.jsdoc.incompat.type", this.stream.getLineno(), this.stream.getCharno());
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case DICT: {
                    if (!this.jsdocBuilder.recordDict()) {
                        this.parser.addTypeWarning("msg.jsdoc.incompat.type", this.stream.getLineno(), this.stream.getCharno());
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case CONSTRUCTOR: {
                    if (!this.jsdocBuilder.recordConstructor()) {
                        if (this.jsdocBuilder.isInterfaceRecorded()) {
                            this.parser.addTypeWarning("msg.jsdoc.interface.constructor", this.stream.getLineno(), this.stream.getCharno());
                        } else {
                            this.parser.addTypeWarning("msg.jsdoc.incompat.type", this.stream.getLineno(), this.stream.getCharno());
                        }
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case DEPRECATED: {
                    ExtractionInfo reasonInfo;
                    String reason;
                    if (!this.jsdocBuilder.recordDeprecated()) {
                        this.parser.addParserWarning("msg.jsdoc.deprecated", this.stream.getLineno(), this.stream.getCharno());
                    }
                    if ((reason = (reasonInfo = this.extractMultilineTextualBlock(token)).string).length() > 0) {
                        this.jsdocBuilder.recordDeprecationReason(reason);
                    }
                    token = reasonInfo.token;
                    return token;
                }
                case INTERFACE: {
                    if (!this.jsdocBuilder.recordInterface()) {
                        if (this.jsdocBuilder.isConstructorRecorded()) {
                            this.parser.addTypeWarning("msg.jsdoc.interface.constructor", this.stream.getLineno(), this.stream.getCharno());
                        } else {
                            this.parser.addTypeWarning("msg.jsdoc.incompat.type", this.stream.getLineno(), this.stream.getCharno());
                        }
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case DESC: {
                    if (this.jsdocBuilder.isDescriptionRecorded()) {
                        this.parser.addParserWarning("msg.jsdoc.desc.extra", this.stream.getLineno(), this.stream.getCharno());
                        return this.eatUntilEOLIfNotAnnotation();
                    }
                    ExtractionInfo descriptionInfo = this.extractMultilineTextualBlock(token);
                    String description = descriptionInfo.string;
                    this.jsdocBuilder.recordDescription(description);
                    token = descriptionInfo.token;
                    return token;
                }
                case FILE_OVERVIEW: {
                    String fileOverview = "";
                    if (this.jsdocBuilder.shouldParseDocumentation()) {
                        ExtractionInfo fileOverviewInfo = this.extractMultilineTextualBlock(token, WhitespaceOption.TRIM);
                        fileOverview = fileOverviewInfo.string;
                        token = fileOverviewInfo.token;
                    } else {
                        token = this.eatTokensUntilEOL(token);
                    }
                    if (!this.jsdocBuilder.recordFileOverview(fileOverview)) {
                        this.parser.addParserWarning("msg.jsdoc.fileoverview.extra", this.stream.getLineno(), this.stream.getCharno());
                    }
                    return token;
                }
                case LICENSE: 
                case PRESERVE: {
                    ExtractionInfo preserveInfo = this.extractMultilineTextualBlock(token, WhitespaceOption.PRESERVE);
                    String preserve = preserveInfo.string;
                    if (preserve.length() > 0 && this.fileLevelJsDocBuilder != null) {
                        this.fileLevelJsDocBuilder.addLicense(preserve);
                    }
                    token = preserveInfo.token;
                    return token;
                }
                case ENUM: {
                    token = this.next();
                    lineno = this.stream.getLineno();
                    charno = this.stream.getCharno();
                    JSTypeExpression type = null;
                    if (token != JsDocToken.EOL && token != JsDocToken.EOC) {
                        type = this.createJSTypeExpression(this.parseAndRecordTypeNode(token));
                    }
                    if (type == null) {
                        type = this.createJSTypeExpression(this.newStringNode("number"));
                    }
                    if (!this.jsdocBuilder.recordEnumParameterType(type)) {
                        this.parser.addTypeWarning("msg.jsdoc.incompat.type", lineno, charno);
                    }
                    token = this.eatUntilEOLIfNotAnnotation(token);
                    return token;
                }
                case EXPOSE: {
                    if (!this.jsdocBuilder.recordExpose()) {
                        this.parser.addParserWarning("msg.jsdoc.expose", this.stream.getLineno(), this.stream.getCharno());
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case EXTERNS: {
                    if (!this.jsdocBuilder.recordExterns()) {
                        this.parser.addParserWarning("msg.jsdoc.externs", this.stream.getLineno(), this.stream.getCharno());
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case EXTENDS: 
                case IMPLEMENTS: {
                    this.skipEOLs();
                    token = this.next();
                    lineno = this.stream.getLineno();
                    charno = this.stream.getCharno();
                    boolean matchingRc = false;
                    if (token == JsDocToken.LEFT_CURLY) {
                        token = this.next();
                        matchingRc = true;
                    }
                    if (token == JsDocToken.STRING) {
                        Node typeNode = this.parseAndRecordTypeNameNode(token, lineno, charno, matchingRc);
                        lineno = this.stream.getLineno();
                        charno = this.stream.getCharno();
                        typeNode = this.wrapNode(306, typeNode);
                        JSTypeExpression type = this.createJSTypeExpression(typeNode);
                        if (annotation == Annotation.EXTENDS) {
                            extendedTypes.add(new ExtendedTypeInfo(type, this.stream.getLineno(), this.stream.getCharno()));
                        } else {
                            Preconditions.checkState((annotation == Annotation.IMPLEMENTS ? 1 : 0) != 0);
                            if (!this.jsdocBuilder.recordImplementedInterface(type)) {
                                this.parser.addTypeWarning("msg.jsdoc.implements.duplicate", lineno, charno);
                            }
                        }
                        token = this.next();
                        if (matchingRc) {
                            if (token != JsDocToken.RIGHT_CURLY) {
                                this.parser.addTypeWarning("msg.jsdoc.missing.rc", this.stream.getLineno(), this.stream.getCharno());
                            } else {
                                token = this.next();
                            }
                        } else if (token != JsDocToken.EOL && token != JsDocToken.EOF && token != JsDocToken.EOC) {
                            this.parser.addTypeWarning("msg.end.annotation.expected", this.stream.getLineno(), this.stream.getCharno());
                        }
                    } else {
                        this.parser.addTypeWarning("msg.no.type.name", lineno, charno);
                    }
                    token = this.eatUntilEOLIfNotAnnotation(token);
                    return token;
                }
                case HIDDEN: {
                    if (!this.jsdocBuilder.recordHiddenness()) {
                        this.parser.addParserWarning("msg.jsdoc.hidden", this.stream.getLineno(), this.stream.getCharno());
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case LENDS: {
                    this.skipEOLs();
                    boolean matchingRc = false;
                    if (this.match(JsDocToken.LEFT_CURLY)) {
                        token = this.next();
                        matchingRc = true;
                    }
                    if (this.match(JsDocToken.STRING)) {
                        token = this.next();
                        if (!this.jsdocBuilder.recordLends(this.stream.getString())) {
                            this.parser.addTypeWarning("msg.jsdoc.lends.incompatible", this.stream.getLineno(), this.stream.getCharno());
                        }
                    } else {
                        this.parser.addTypeWarning("msg.jsdoc.lends.missing", this.stream.getLineno(), this.stream.getCharno());
                    }
                    if (matchingRc && !this.match(JsDocToken.RIGHT_CURLY)) {
                        this.parser.addTypeWarning("msg.jsdoc.missing.rc", this.stream.getLineno(), this.stream.getCharno());
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case MEANING: {
                    ExtractionInfo meaningInfo = this.extractMultilineTextualBlock(token);
                    String meaning = meaningInfo.string;
                    token = meaningInfo.token;
                    if (!this.jsdocBuilder.recordMeaning(meaning)) {
                        this.parser.addParserWarning("msg.jsdoc.meaning.extra", this.stream.getLineno(), this.stream.getCharno());
                    }
                    return token;
                }
                case NO_ALIAS: {
                    if (!this.jsdocBuilder.recordNoAlias()) {
                        this.parser.addParserWarning("msg.jsdoc.noalias", this.stream.getLineno(), this.stream.getCharno());
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case NO_COMPILE: {
                    if (!this.jsdocBuilder.recordNoCompile()) {
                        this.parser.addParserWarning("msg.jsdoc.nocompile", this.stream.getLineno(), this.stream.getCharno());
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case NO_COLLAPSE: {
                    if (!this.jsdocBuilder.recordNoCollapse()) {
                        this.parser.addParserWarning("msg.jsdoc.nocollapse", this.stream.getLineno(), this.stream.getCharno());
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case NOT_IMPLEMENTED: {
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case INHERIT_DOC: 
                case OVERRIDE: {
                    if (!this.jsdocBuilder.recordOverride()) {
                        this.parser.addTypeWarning("msg.jsdoc.override", this.stream.getLineno(), this.stream.getCharno());
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case POLYMER_BEHAVIOR: {
                    if (this.jsdocBuilder.isPolymerBehaviorRecorded()) {
                        this.parser.addParserWarning("msg.jsdoc.polymerBehavior.extra", this.stream.getLineno(), this.stream.getCharno());
                    } else {
                        this.jsdocBuilder.recordPolymerBehavior();
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case THROWS: {
                    this.skipEOLs();
                    token = this.next();
                    lineno = this.stream.getLineno();
                    charno = this.stream.getCharno();
                    JSTypeExpression type = null;
                    if (token == JsDocToken.LEFT_CURLY && (type = this.createJSTypeExpression(this.parseAndRecordTypeNode(token))) == null) {
                        return this.eatUntilEOLIfNotAnnotation();
                    }
                    token = this.current();
                    this.jsdocBuilder.recordThrowType(type);
                    boolean isAnnotationNext = this.lookAheadForAnnotation();
                    if (this.jsdocBuilder.shouldParseDocumentation() && !isAnnotationNext) {
                        ExtractionInfo descriptionInfo = this.extractMultilineTextualBlock(token);
                        String description = descriptionInfo.string;
                        if (description.length() > 0) {
                            this.jsdocBuilder.recordThrowDescription(type, description);
                        }
                        token = descriptionInfo.token;
                    } else {
                        token = this.eatUntilEOLIfNotAnnotation();
                    }
                    return token;
                }
                case PARAM: {
                    boolean isBracketedParam;
                    this.skipEOLs();
                    token = this.next();
                    lineno = this.stream.getLineno();
                    charno = this.stream.getCharno();
                    JSTypeExpression type = null;
                    if (token == JsDocToken.LEFT_CURLY) {
                        type = this.createJSTypeExpression(this.parseAndRecordParamTypeNode(token));
                        if (type == null) {
                            return this.eatUntilEOLIfNotAnnotation();
                        }
                        this.skipEOLs();
                        token = this.next();
                        lineno = this.stream.getLineno();
                        charno = this.stream.getCharno();
                    }
                    String name = null;
                    boolean bl = isBracketedParam = JsDocToken.LEFT_SQUARE == token;
                    if (isBracketedParam) {
                        token = this.next();
                    }
                    if (JsDocToken.STRING != token) {
                        this.parser.addTypeWarning("msg.missing.variable.name", lineno, charno);
                    } else {
                        name = this.stream.getString();
                        if (isBracketedParam) {
                            token = this.next();
                            if (JsDocToken.EQUALS == token && JsDocToken.STRING == (token = this.next())) {
                                token = this.next();
                            }
                            if (JsDocToken.RIGHT_SQUARE != token) {
                                this.reportTypeSyntaxWarning("msg.jsdoc.missing.rb");
                            } else if (type != null) {
                                type = JSTypeExpression.makeOptionalArg(type);
                            }
                        }
                        if (name.indexOf(46) > -1) {
                            this.parser.addParserWarning("msg.invalid.variable.name", name, lineno, charno);
                            name = null;
                        } else if (!this.jsdocBuilder.recordParameter(name, type)) {
                            if (this.jsdocBuilder.hasParameter(name)) {
                                this.parser.addTypeWarning("msg.dup.variable.name", name, lineno, charno);
                            } else {
                                this.parser.addTypeWarning("msg.jsdoc.incompat.type", name, lineno, charno);
                            }
                        }
                    }
                    if (name == null) {
                        token = this.eatUntilEOLIfNotAnnotation(token);
                        return token;
                    }
                    this.jsdocBuilder.markName(name, this.sourceFile, lineno, charno);
                    if (this.jsdocBuilder.shouldParseDocumentation() && token != JsDocToken.ANNOTATION) {
                        ExtractionInfo paramDescriptionInfo = this.extractMultilineTextualBlock(token);
                        String paramDescription = paramDescriptionInfo.string;
                        if (paramDescription.length() > 0) {
                            this.jsdocBuilder.recordParameterDescription(name, paramDescription);
                        }
                        token = paramDescriptionInfo.token;
                    } else if (token != JsDocToken.EOC && token != JsDocToken.EOF) {
                        token = this.eatUntilEOLIfNotAnnotation();
                    }
                    return token;
                }
                case PRESERVE_TRY: {
                    if (!this.jsdocBuilder.recordPreserveTry()) {
                        this.parser.addParserWarning("msg.jsdoc.preservertry", this.stream.getLineno(), this.stream.getCharno());
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case NO_SIDE_EFFECTS: {
                    if (!this.jsdocBuilder.recordNoSideEffects()) {
                        this.parser.addParserWarning("msg.jsdoc.nosideeffects", this.stream.getLineno(), this.stream.getCharno());
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case MODIFIES: {
                    token = this.parseModifiesTag(this.next());
                    return token;
                }
                case IMPLICIT_CAST: {
                    if (!this.jsdocBuilder.recordImplicitCast()) {
                        this.parser.addTypeWarning("msg.jsdoc.implicitcast", this.stream.getLineno(), this.stream.getCharno());
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case SEE: {
                    if (this.jsdocBuilder.shouldParseDocumentation()) {
                        ExtractionInfo referenceInfo = this.extractSingleLineBlock();
                        String reference = referenceInfo.string;
                        if (reference.isEmpty()) {
                            this.parser.addParserWarning("msg.jsdoc.seemissing", this.stream.getLineno(), this.stream.getCharno());
                        } else {
                            this.jsdocBuilder.addReference(reference);
                        }
                        token = referenceInfo.token;
                    } else {
                        token = this.eatUntilEOLIfNotAnnotation();
                    }
                    return token;
                }
                case STABLEIDGENERATOR: {
                    if (!this.jsdocBuilder.recordStableIdGenerator()) {
                        this.parser.addParserWarning("msg.jsdoc.stableidgen", this.stream.getLineno(), this.stream.getCharno());
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case SUPPRESS: {
                    token = this.parseSuppressTag(this.next());
                    return token;
                }
                case TEMPLATE: {
                    String templateNames;
                    int templateLineno = this.stream.getLineno();
                    int templateCharno = this.stream.getCharno();
                    ExtractionInfo templateInfo = this.extractMultilineTextualBlock(token, WhitespaceOption.TRIM);
                    String templateString = templateInfo.string;
                    String ttlStartDelimiter = ":=";
                    String ttlEndDelimiter = "=:";
                    String typeTransformationExpr = "";
                    boolean isTypeTransformation = false;
                    boolean validTypeTransformation = true;
                    if (!templateString.contains(ttlStartDelimiter)) {
                        templateNames = templateString.contains("\n") ? templateString.substring(0, templateString.indexOf(10)) : templateString;
                    } else {
                        int ttlStartIndex = templateString.indexOf(ttlStartDelimiter);
                        templateNames = templateString.substring(0, ttlStartIndex);
                        if (!templateString.contains(ttlEndDelimiter)) {
                            validTypeTransformation = false;
                            this.parser.addTypeWarning("msg.jsdoc.typetransformation.missing.delimiter", templateLineno, templateCharno);
                        } else {
                            isTypeTransformation = true;
                            int ttlEndIndex = templateString.indexOf(ttlEndDelimiter);
                            typeTransformationExpr = templateString.substring(ttlStartIndex + ttlStartDelimiter.length(), ttlEndIndex).trim();
                        }
                    }
                    List names = Splitter.on((char)',').trimResults().splitToList((CharSequence)templateNames);
                    if (names.size() == 1 && ((String)names.get(0)).isEmpty()) {
                        this.parser.addTypeWarning("msg.jsdoc.templatemissing", templateLineno, templateCharno);
                    } else {
                        for (String typeName : names) {
                            if (!JsDocInfoParser.validTemplateTypeName(typeName)) {
                                this.parser.addTypeWarning("msg.jsdoc.template.invalid.type.name", templateLineno, templateCharno);
                                continue;
                            }
                            if (isTypeTransformation || this.jsdocBuilder.recordTemplateTypeName(typeName)) continue;
                            this.parser.addTypeWarning("msg.jsdoc.template.name.declared.twice", templateLineno, templateCharno);
                        }
                    }
                    if (isTypeTransformation) {
                        TypeTransformationParser ttlParser;
                        if (names.size() > 1) {
                            this.parser.addTypeWarning("msg.jsdoc.typetransformation.with.multiple.names", templateLineno, templateCharno);
                        }
                        if (typeTransformationExpr.isEmpty()) {
                            validTypeTransformation = false;
                            this.parser.addTypeWarning("msg.jsdoc.typetransformation.expression.missing", templateLineno, templateCharno);
                        }
                        if (validTypeTransformation && (ttlParser = new TypeTransformationParser(typeTransformationExpr, this.sourceFile, this.errorReporter, templateLineno, templateCharno)).parseTypeTransformation() && !this.jsdocBuilder.recordTypeTransformation((String)names.get(0), ttlParser.getTypeTransformationAst())) {
                            this.parser.addTypeWarning("msg.jsdoc.template.name.declared.twice", templateLineno, templateCharno);
                        }
                    }
                    token = templateInfo.token;
                    return token;
                }
                case IDGENERATOR: {
                    token = this.parseIdGeneratorTag(this.next());
                    return token;
                }
                case WIZACTION: {
                    if (!this.jsdocBuilder.recordWizaction()) {
                        this.parser.addParserWarning("msg.jsdoc.wizaction", this.stream.getLineno(), this.stream.getCharno());
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case DISPOSES: {
                    ExtractionInfo templateInfo = this.extractSingleLineBlock();
                    List names = Splitter.on((char)',').trimResults().splitToList((CharSequence)templateInfo.string);
                    if (names.isEmpty() || ((String)names.get(0)).isEmpty()) {
                        this.parser.addTypeWarning("msg.jsdoc.disposeparameter.missing", this.stream.getLineno(), this.stream.getCharno());
                    } else if (!this.jsdocBuilder.recordDisposesParameter(names)) {
                        this.parser.addTypeWarning("msg.jsdoc.disposeparameter.error", this.stream.getLineno(), this.stream.getCharno());
                    }
                    token = templateInfo.token;
                    return token;
                }
                case VERSION: {
                    ExtractionInfo versionInfo = this.extractSingleLineBlock();
                    String version = versionInfo.string;
                    if (version.isEmpty()) {
                        this.parser.addParserWarning("msg.jsdoc.versionmissing", this.stream.getLineno(), this.stream.getCharno());
                    } else if (!this.jsdocBuilder.recordVersion(version)) {
                        this.parser.addParserWarning("msg.jsdoc.extraversion", this.stream.getLineno(), this.stream.getCharno());
                    }
                    token = versionInfo.token;
                    return token;
                }
                case CONSTANT: 
                case DEFINE: 
                case EXPORT: 
                case PRIVATE: 
                case PACKAGE: 
                case PROTECTED: 
                case PUBLIC: 
                case RETURN: 
                case THIS: 
                case TYPEDEF: 
                case TYPE: {
                    boolean hasError;
                    lineno = this.stream.getLineno();
                    charno = this.stream.getCharno();
                    Node typeNode = null;
                    boolean hasType = this.lookAheadForType();
                    boolean isAlternateTypeAnnotation = annotation == Annotation.PACKAGE || annotation == Annotation.PRIVATE || annotation == Annotation.PROTECTED || annotation == Annotation.PUBLIC || annotation == Annotation.CONSTANT || annotation == Annotation.EXPORT;
                    boolean canSkipTypeAnnotation = isAlternateTypeAnnotation || annotation == Annotation.RETURN;
                    JSTypeExpression type = null;
                    if (hasType || !canSkipTypeAnnotation) {
                        this.skipEOLs();
                        token = this.next();
                        typeNode = this.parseAndRecordTypeNode(token);
                        if (annotation == Annotation.THIS) {
                            typeNode = this.wrapNode(306, typeNode);
                        }
                        type = this.createJSTypeExpression(typeNode);
                    }
                    boolean bl = hasError = type == null && !canSkipTypeAnnotation;
                    if (!hasError) {
                        if ((type != null && isAlternateTypeAnnotation || annotation == Annotation.TYPE) && !this.jsdocBuilder.recordType(type)) {
                            this.parser.addTypeWarning("msg.jsdoc.incompat.type", lineno, charno);
                        }
                        boolean isAnnotationNext = this.lookAheadForAnnotation();
                        switch (annotation) {
                            case CONSTANT: {
                                if (this.jsdocBuilder.recordConstancy()) break;
                                this.parser.addParserWarning("msg.jsdoc.const", this.stream.getLineno(), this.stream.getCharno());
                                break;
                            }
                            case DEFINE: {
                                if (!this.jsdocBuilder.recordDefineType(type)) {
                                    this.parser.addParserWarning("msg.jsdoc.define", lineno, charno);
                                }
                                if (isAnnotationNext) break;
                                return this.recordDescription(token);
                            }
                            case EXPORT: {
                                if (!this.jsdocBuilder.recordExport()) {
                                    this.parser.addParserWarning("msg.jsdoc.export", lineno, charno);
                                } else if (!this.jsdocBuilder.recordVisibility(JSDocInfo.Visibility.PUBLIC)) {
                                    this.parser.addParserWarning("msg.jsdoc.extra.visibility", lineno, charno);
                                }
                                if (isAnnotationNext) break;
                                return this.recordDescription(token);
                            }
                            case PRIVATE: {
                                if (!this.jsdocBuilder.recordVisibility(JSDocInfo.Visibility.PRIVATE)) {
                                    this.parser.addParserWarning("msg.jsdoc.extra.visibility", lineno, charno);
                                }
                                if (isAnnotationNext) break;
                                return this.recordDescription(token);
                            }
                            case PACKAGE: {
                                if (!this.jsdocBuilder.recordVisibility(JSDocInfo.Visibility.PACKAGE)) {
                                    this.parser.addParserWarning("msg.jsdoc.extra.visibility", lineno, charno);
                                }
                                if (isAnnotationNext) break;
                                return this.recordDescription(token);
                            }
                            case PROTECTED: {
                                if (!this.jsdocBuilder.recordVisibility(JSDocInfo.Visibility.PROTECTED)) {
                                    this.parser.addParserWarning("msg.jsdoc.extra.visibility", lineno, charno);
                                }
                                if (isAnnotationNext) break;
                                return this.recordDescription(token);
                            }
                            case PUBLIC: {
                                if (!this.jsdocBuilder.recordVisibility(JSDocInfo.Visibility.PUBLIC)) {
                                    this.parser.addParserWarning("msg.jsdoc.extra.visibility", lineno, charno);
                                }
                                if (isAnnotationNext) break;
                                return this.recordDescription(token);
                            }
                            case RETURN: {
                                if (type == null) {
                                    type = this.createJSTypeExpression(this.newNode(304));
                                }
                                if (!this.jsdocBuilder.recordReturnType(type)) {
                                    this.parser.addTypeWarning("msg.jsdoc.incompat.type", lineno, charno);
                                    break;
                                }
                                if (this.jsdocBuilder.shouldParseDocumentation() && !isAnnotationNext) {
                                    ExtractionInfo returnDescriptionInfo = this.extractMultilineTextualBlock(token);
                                    String returnDescription = returnDescriptionInfo.string;
                                    if (returnDescription.length() > 0) {
                                        this.jsdocBuilder.recordReturnDescription(returnDescription);
                                    }
                                    token = returnDescriptionInfo.token;
                                } else {
                                    token = this.eatUntilEOLIfNotAnnotation();
                                }
                                return token;
                            }
                            case THIS: {
                                if (this.jsdocBuilder.recordThisType(type)) break;
                                this.parser.addTypeWarning("msg.jsdoc.incompat.type", lineno, charno);
                                break;
                            }
                            case TYPEDEF: {
                                if (this.jsdocBuilder.recordTypedef(type)) break;
                                this.parser.addTypeWarning("msg.jsdoc.incompat.type", lineno, charno);
                            }
                        }
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
            }
        }
        return this.next();
    }

    private static boolean validTemplateTypeName(String name) {
        return !name.isEmpty() && CharMatcher.JAVA_UPPER_CASE.matches(name.charAt(0)) && CharMatcher.JAVA_LETTER_OR_DIGIT.or(CharMatcher.is((char)'_')).matchesAllOf((CharSequence)name);
    }

    private JsDocToken recordDescription(JsDocToken token) {
        if (this.jsdocBuilder.shouldParseDocumentation()) {
            ExtractionInfo descriptionInfo = this.extractMultilineTextualBlock(token);
            token = descriptionInfo.token;
        } else {
            token = this.eatTokensUntilEOL(token);
        }
        return token;
    }

    private void checkExtendedTypes(List<ExtendedTypeInfo> extendedTypes) {
        for (ExtendedTypeInfo typeInfo : extendedTypes) {
            if (this.jsdocBuilder.isInterfaceRecorded()) {
                if (this.jsdocBuilder.recordExtendedInterface(typeInfo.type)) continue;
                this.parser.addParserWarning("msg.jsdoc.extends.duplicate", typeInfo.lineno, typeInfo.charno);
                continue;
            }
            if (this.jsdocBuilder.recordBaseType(typeInfo.type)) continue;
            this.parser.addTypeWarning("msg.jsdoc.incompat.type", typeInfo.lineno, typeInfo.charno);
        }
    }

    private JsDocToken parseSuppressTag(JsDocToken token) {
        if (token != JsDocToken.LEFT_CURLY) {
            this.parser.addParserWarning("msg.jsdoc.suppress", this.stream.getLineno(), this.stream.getCharno());
        } else {
            HashSet<String> suppressions = new HashSet<String>();
            while (true) {
                if (this.match(JsDocToken.STRING)) {
                    String name = this.stream.getString();
                    if (!this.suppressionNames.contains(name)) {
                        this.parser.addParserWarning("msg.jsdoc.suppress.unknown", name, this.stream.getLineno(), this.stream.getCharno());
                    }
                } else {
                    this.parser.addParserWarning("msg.jsdoc.suppress", this.stream.getLineno(), this.stream.getCharno());
                    return token;
                }
                suppressions.add(this.stream.getString());
                token = this.next();
                if (!this.match(JsDocToken.PIPE, JsDocToken.COMMA)) break;
                token = this.next();
            }
            if (!this.match(JsDocToken.RIGHT_CURLY)) {
                this.parser.addParserWarning("msg.jsdoc.suppress", this.stream.getLineno(), this.stream.getCharno());
            } else {
                token = this.next();
                if (!this.jsdocBuilder.recordSuppressions(suppressions)) {
                    this.parser.addParserWarning("msg.jsdoc.suppress.duplicate", this.stream.getLineno(), this.stream.getCharno());
                }
            }
        }
        return token;
    }

    private JsDocToken parseModifiesTag(JsDocToken token) {
        if (token == JsDocToken.LEFT_CURLY) {
            HashSet<String> modifies = new HashSet<String>();
            while (true) {
                if (this.match(JsDocToken.STRING)) {
                    String name = this.stream.getString();
                    if (!modifiesAnnotationKeywords.contains(name) && !this.jsdocBuilder.hasParameter(name)) {
                        this.parser.addParserWarning("msg.jsdoc.modifies.unknown", name, this.stream.getLineno(), this.stream.getCharno());
                    }
                } else {
                    this.parser.addParserWarning("msg.jsdoc.modifies", this.stream.getLineno(), this.stream.getCharno());
                    return token;
                }
                modifies.add(this.stream.getString());
                token = this.next();
                if (!this.match(JsDocToken.PIPE)) break;
                token = this.next();
            }
            if (!this.match(JsDocToken.RIGHT_CURLY)) {
                this.parser.addParserWarning("msg.jsdoc.modifies", this.stream.getLineno(), this.stream.getCharno());
            } else {
                token = this.next();
                if (!this.jsdocBuilder.recordModifies(modifies)) {
                    this.parser.addParserWarning("msg.jsdoc.modifies.duplicate", this.stream.getLineno(), this.stream.getCharno());
                }
            }
        }
        return token;
    }

    private JsDocToken parseIdGeneratorTag(JsDocToken token) {
        String idgenKind = "unique";
        if (token == JsDocToken.LEFT_CURLY) {
            String name;
            if (this.match(JsDocToken.STRING)) {
                name = this.stream.getString();
                if (!idGeneratorAnnotationKeywords.contains(name) && !this.jsdocBuilder.hasParameter(name)) {
                    this.parser.addParserWarning("msg.jsdoc.idgen.unknown", name, this.stream.getLineno(), this.stream.getCharno());
                }
            } else {
                this.parser.addParserWarning("msg.jsdoc.idgen.bad", this.stream.getLineno(), this.stream.getCharno());
                return token;
            }
            idgenKind = name;
            token = this.next();
            if (!this.match(JsDocToken.RIGHT_CURLY)) {
                this.parser.addParserWarning("msg.jsdoc.idgen.bad", this.stream.getLineno(), this.stream.getCharno());
            } else {
                token = this.next();
            }
        }
        switch (idgenKind) {
            case "unique": {
                if (this.jsdocBuilder.recordIdGenerator()) break;
                this.parser.addParserWarning("msg.jsdoc.idgen.duplicate", this.stream.getLineno(), this.stream.getCharno());
                break;
            }
            case "consistent": {
                if (this.jsdocBuilder.recordConsistentIdGenerator()) break;
                this.parser.addParserWarning("msg.jsdoc.idgen.duplicate", this.stream.getLineno(), this.stream.getCharno());
                break;
            }
            case "stable": {
                if (this.jsdocBuilder.recordStableIdGenerator()) break;
                this.parser.addParserWarning("msg.jsdoc.idgen.duplicate", this.stream.getLineno(), this.stream.getCharno());
                break;
            }
            case "mapped": {
                if (this.jsdocBuilder.recordMappedIdGenerator()) break;
                this.parser.addParserWarning("msg.jsdoc.idgen.duplicate", this.stream.getLineno(), this.stream.getCharno());
            }
        }
        return token;
    }

    Node parseAndRecordTypeNode(JsDocToken token) {
        return this.parseAndRecordTypeNode(token, this.stream.getLineno(), this.stream.getCharno(), token == JsDocToken.LEFT_CURLY, false);
    }

    private Node parseAndRecordTypeNameNode(JsDocToken token, int lineno, int startCharno, boolean matchingLC) {
        return this.parseAndRecordTypeNode(token, lineno, startCharno, matchingLC, true);
    }

    private Node parseAndRecordParamTypeNode(JsDocToken token) {
        Preconditions.checkArgument((token == JsDocToken.LEFT_CURLY ? 1 : 0) != 0);
        int lineno = this.stream.getLineno();
        int startCharno = this.stream.getCharno();
        Node typeNode = this.parseParamTypeExpressionAnnotation(token);
        this.recordTypeNode(lineno, startCharno, typeNode, true);
        return typeNode;
    }

    private Node parseAndRecordTypeNode(JsDocToken token, int lineno, int startCharno, boolean matchingLC, boolean onlyParseSimpleNames) {
        Node typeNode = onlyParseSimpleNames ? this.parseTypeNameAnnotation(token) : this.parseTypeExpressionAnnotation(token);
        this.recordTypeNode(lineno, startCharno, typeNode, matchingLC);
        return typeNode;
    }

    private String toString(JsDocToken token) {
        switch (token) {
            case ANNOTATION: {
                return "@" + this.stream.getString();
            }
            case BANG: {
                return "!";
            }
            case COMMA: {
                return ",";
            }
            case COLON: {
                return ":";
            }
            case RIGHT_ANGLE: {
                return ">";
            }
            case LEFT_SQUARE: {
                return "[";
            }
            case LEFT_CURLY: {
                return "{";
            }
            case LEFT_PAREN: {
                return "(";
            }
            case LEFT_ANGLE: {
                return "<";
            }
            case QMARK: {
                return "?";
            }
            case PIPE: {
                return "|";
            }
            case RIGHT_SQUARE: {
                return "]";
            }
            case RIGHT_CURLY: {
                return "}";
            }
            case RIGHT_PAREN: {
                return ")";
            }
            case STAR: {
                return "*";
            }
            case ELLIPSIS: {
                return "...";
            }
            case EQUALS: {
                return "=";
            }
            case STRING: {
                return this.stream.getString();
            }
        }
        throw new IllegalStateException(token.toString());
    }

    JSTypeExpression createJSTypeExpression(Node n) {
        return n == null ? null : new JSTypeExpression(n, this.getSourceName());
    }

    private ExtractionInfo extractSingleLineBlock() {
        this.stream.update();
        int lineno = this.stream.getLineno();
        int charno = this.stream.getCharno() + 1;
        String line = this.getRemainingJSDocLine().trim();
        if (line.length() > 0) {
            this.jsdocBuilder.markText(line, lineno, charno, lineno, charno + line.length());
        }
        return new ExtractionInfo(line, this.next());
    }

    private ExtractionInfo extractMultilineTextualBlock(JsDocToken token) {
        return this.extractMultilineTextualBlock(token, WhitespaceOption.SINGLE_LINE);
    }

    private ExtractionInfo extractMultilineTextualBlock(JsDocToken token, WhitespaceOption option) {
        if (token == JsDocToken.EOC || token == JsDocToken.EOL || token == JsDocToken.EOF) {
            return new ExtractionInfo("", token);
        }
        this.stream.update();
        int startLineno = this.stream.getLineno();
        int startCharno = this.stream.getCharno() + 1;
        String line = this.getRemainingJSDocLine();
        if (option != WhitespaceOption.PRESERVE) {
            line = line.trim();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(line);
        this.state = State.SEARCHING_ANNOTATION;
        token = this.next();
        boolean ignoreStar = false;
        int lineStartChar = -1;
        block4: while (true) {
            boolean isEOC;
            switch (token) {
                case STAR: {
                    if (ignoreStar) {
                        lineStartChar = this.stream.getCharno() + 1;
                    } else {
                        if (builder.length() > 0) {
                            builder.append(' ');
                        }
                        builder.append('*');
                    }
                    token = this.next();
                    continue block4;
                }
                case EOL: {
                    if (option != WhitespaceOption.SINGLE_LINE) {
                        builder.append("\n");
                    }
                    ignoreStar = true;
                    lineStartChar = 0;
                    token = this.next();
                    continue block4;
                }
            }
            ignoreStar = false;
            this.state = State.SEARCHING_ANNOTATION;
            boolean bl = isEOC = token == JsDocToken.EOC;
            if (!isEOC) {
                if (lineStartChar != -1 && option == WhitespaceOption.PRESERVE) {
                    int numSpaces = this.stream.getCharno() - lineStartChar;
                    for (int i = 0; i < numSpaces; ++i) {
                        builder.append(' ');
                    }
                    lineStartChar = -1;
                } else if (builder.length() > 0) {
                    builder.append(' ');
                }
            }
            if (token == JsDocToken.EOC || token == JsDocToken.EOF || token == JsDocToken.ANNOTATION && option != WhitespaceOption.PRESERVE) {
                String multilineText = builder.toString();
                if (option != WhitespaceOption.PRESERVE) {
                    multilineText = multilineText.trim();
                }
                int endLineno = this.stream.getLineno();
                int endCharno = this.stream.getCharno();
                if (multilineText.length() > 0) {
                    this.jsdocBuilder.markText(multilineText, startLineno, startCharno, endLineno, endCharno);
                }
                return new ExtractionInfo(multilineText, token);
            }
            builder.append(this.toString(token));
            line = this.getRemainingJSDocLine();
            if (option != WhitespaceOption.PRESERVE) {
                line = JsDocInfoParser.trimEnd(line);
            }
            builder.append(line);
            token = this.next();
        }
    }

    private ExtractionInfo extractBlockComment(JsDocToken token) {
        StringBuilder builder = new StringBuilder();
        boolean ignoreStar = true;
        block5: while (true) {
            switch (token) {
                case ANNOTATION: 
                case EOC: 
                case EOF: {
                    return new ExtractionInfo(builder.toString().trim(), token);
                }
                case STAR: {
                    if (!ignoreStar) {
                        if (builder.length() > 0) {
                            builder.append(' ');
                        }
                        builder.append('*');
                    }
                    token = this.next();
                    continue block5;
                }
                case EOL: {
                    ignoreStar = true;
                    builder.append('\n');
                    token = this.next();
                    continue block5;
                }
            }
            if (!ignoreStar && builder.length() > 0) {
                builder.append(' ');
            }
            ignoreStar = false;
            builder.append(this.toString(token));
            String line = this.getRemainingJSDocLine();
            line = JsDocInfoParser.trimEnd(line);
            builder.append(line);
            token = this.next();
        }
    }

    private static String trimEnd(String s) {
        char ch;
        int trimCount;
        for (trimCount = 0; trimCount < s.length() && Character.isWhitespace(ch = s.charAt(s.length() - trimCount - 1)); ++trimCount) {
        }
        if (trimCount == 0) {
            return s;
        }
        return s.substring(0, s.length() - trimCount);
    }

    private Node parseTypeExpressionAnnotation(JsDocToken token) {
        if (token == JsDocToken.LEFT_CURLY) {
            this.skipEOLs();
            Node typeNode = this.parseTopLevelTypeExpression(this.next());
            if (typeNode != null) {
                this.skipEOLs();
                if (!this.match(JsDocToken.RIGHT_CURLY)) {
                    this.reportTypeSyntaxWarning("msg.jsdoc.missing.rc");
                } else {
                    this.next();
                }
            }
            return typeNode;
        }
        return this.parseTypeExpression(token);
    }

    private Node parseParamTypeExpression(JsDocToken token) {
        Node typeNode;
        boolean restArg = false;
        if (token == JsDocToken.ELLIPSIS) {
            token = this.next();
            if (token == JsDocToken.RIGHT_CURLY) {
                this.restoreLookAhead(token);
                return this.wrapNode(305, IR.empty());
            }
            restArg = true;
        }
        if ((typeNode = this.parseTopLevelTypeExpression(token)) != null) {
            this.skipEOLs();
            if (restArg) {
                typeNode = this.wrapNode(305, typeNode);
            } else if (this.match(JsDocToken.EQUALS)) {
                this.next();
                this.skipEOLs();
                typeNode = this.wrapNode(307, typeNode);
            }
        }
        return typeNode;
    }

    private Node parseParamTypeExpressionAnnotation(JsDocToken token) {
        Preconditions.checkArgument((token == JsDocToken.LEFT_CURLY ? 1 : 0) != 0);
        this.skipEOLs();
        Node typeNode = this.parseParamTypeExpression(this.next());
        if (typeNode != null) {
            if (!this.match(JsDocToken.RIGHT_CURLY)) {
                this.reportTypeSyntaxWarning("msg.jsdoc.missing.rc");
            } else {
                this.next();
            }
        }
        return typeNode;
    }

    private Node parseTypeNameAnnotation(JsDocToken token) {
        if (token == JsDocToken.LEFT_CURLY) {
            this.skipEOLs();
            Node typeNode = this.parseTypeName(this.next());
            if (typeNode != null) {
                this.skipEOLs();
                if (!this.match(JsDocToken.RIGHT_CURLY)) {
                    this.reportTypeSyntaxWarning("msg.jsdoc.missing.rc");
                } else {
                    this.next();
                }
            }
            return typeNode;
        }
        return this.parseTypeName(token);
    }

    private Node parseTopLevelTypeExpression(JsDocToken token) {
        Node typeExpr = this.parseTypeExpression(token);
        if (typeExpr != null && this.match(JsDocToken.PIPE)) {
            this.next();
            if (this.match(JsDocToken.PIPE)) {
                this.next();
            }
            this.skipEOLs();
            token = this.next();
            return this.parseUnionTypeWithAlternate(token, typeExpr);
        }
        return typeExpr;
    }

    private Node parseTypeExpressionList(JsDocToken token) {
        Node typeExpr = this.parseTopLevelTypeExpression(token);
        if (typeExpr == null) {
            return null;
        }
        Node typeList = IR.block();
        typeList.addChildToBack(typeExpr);
        while (this.match(JsDocToken.COMMA)) {
            this.next();
            this.skipEOLs();
            typeExpr = this.parseTopLevelTypeExpression(this.next());
            if (typeExpr == null) {
                return null;
            }
            typeList.addChildToBack(typeExpr);
        }
        return typeList;
    }

    private Node parseTypeExpression(JsDocToken token) {
        if (token == JsDocToken.QMARK) {
            token = this.next();
            if (token == JsDocToken.COMMA || token == JsDocToken.EQUALS || token == JsDocToken.RIGHT_SQUARE || token == JsDocToken.RIGHT_CURLY || token == JsDocToken.RIGHT_PAREN || token == JsDocToken.PIPE || token == JsDocToken.RIGHT_ANGLE || token == JsDocToken.EOC || token == JsDocToken.EOF) {
                this.restoreLookAhead(token);
                return this.newNode(304);
            }
            return this.wrapNode(304, this.parseBasicTypeExpression(token));
        }
        if (token == JsDocToken.BANG) {
            return this.wrapNode(306, this.parseBasicTypeExpression(this.next()));
        }
        Node basicTypeExpr = this.parseBasicTypeExpression(token);
        if (basicTypeExpr != null) {
            if (this.match(JsDocToken.QMARK)) {
                this.next();
                return this.wrapNode(304, basicTypeExpr);
            }
            if (this.match(JsDocToken.BANG)) {
                this.next();
                return this.wrapNode(306, basicTypeExpr);
            }
        }
        return basicTypeExpr;
    }

    private Node parseContextTypeExpression(JsDocToken token) {
        if (token == JsDocToken.QMARK) {
            return this.newNode(304);
        }
        return this.parseBasicTypeExpression(token);
    }

    private Node parseBasicTypeExpression(JsDocToken token) {
        if (token == JsDocToken.STAR) {
            return this.newNode(302);
        }
        if (token == JsDocToken.LEFT_CURLY) {
            this.skipEOLs();
            return this.parseRecordType(this.next());
        }
        if (token == JsDocToken.LEFT_PAREN) {
            this.skipEOLs();
            return this.parseUnionType(this.next());
        }
        if (token == JsDocToken.STRING) {
            String string;
            switch (string = this.stream.getString()) {
                case "function": {
                    this.skipEOLs();
                    return this.parseFunctionType(this.next());
                }
                case "null": 
                case "undefined": {
                    return this.newStringNode(string);
                }
            }
            return this.parseTypeName(token);
        }
        this.restoreLookAhead(token);
        return this.reportGenericTypeSyntaxWarning();
    }

    private Node parseTypeName(JsDocToken token) {
        if (token != JsDocToken.STRING) {
            return this.reportGenericTypeSyntaxWarning();
        }
        String typeName = this.stream.getString();
        int lineno = this.stream.getLineno();
        int charno = this.stream.getCharno();
        while (this.match(JsDocToken.EOL) && typeName.charAt(typeName.length() - 1) == '.') {
            this.skipEOLs();
            if (!this.match(JsDocToken.STRING)) continue;
            this.next();
            typeName = typeName + this.stream.getString();
        }
        Node typeNameNode = this.newStringNode(typeName, lineno, charno);
        if (this.match(JsDocToken.LEFT_ANGLE)) {
            this.next();
            this.skipEOLs();
            Node memberType = this.parseTypeExpressionList(this.next());
            if (memberType != null) {
                typeNameNode.addChildToFront(memberType);
                this.skipEOLs();
                if (!this.match(JsDocToken.RIGHT_ANGLE)) {
                    return this.reportTypeSyntaxWarning("msg.jsdoc.missing.gt");
                }
                this.next();
            }
        }
        return typeNameNode;
    }

    private Node parseFunctionType(JsDocToken token) {
        if (token != JsDocToken.LEFT_PAREN) {
            this.restoreLookAhead(token);
            return this.reportTypeSyntaxWarning("msg.jsdoc.missing.lp");
        }
        Node functionType = this.newNode(105);
        Node parameters = null;
        this.skipEOLs();
        if (!this.match(JsDocToken.RIGHT_PAREN)) {
            token = this.next();
            boolean hasParams = true;
            if (token == JsDocToken.STRING) {
                String tokenStr = this.stream.getString();
                boolean isThis = "this".equals(tokenStr);
                boolean isNew = "new".equals(tokenStr);
                if (isThis || isNew) {
                    Node contextType;
                    if (this.match(JsDocToken.COLON)) {
                        this.next();
                        this.skipEOLs();
                        contextType = this.wrapNode(isThis ? 42 : 30, this.parseContextTypeExpression(this.next()));
                        if (contextType == null) {
                            return null;
                        }
                    } else {
                        return this.reportTypeSyntaxWarning("msg.jsdoc.missing.colon");
                    }
                    functionType.addChildToFront(contextType);
                    if (this.match(JsDocToken.COMMA)) {
                        this.next();
                        this.skipEOLs();
                        token = this.next();
                    } else {
                        hasParams = false;
                    }
                }
            }
            if (hasParams && (parameters = this.parseParametersType(token)) == null) {
                return null;
            }
        }
        if (parameters != null) {
            functionType.addChildToBack(parameters);
        }
        this.skipEOLs();
        if (!this.match(JsDocToken.RIGHT_PAREN)) {
            return this.reportTypeSyntaxWarning("msg.jsdoc.missing.rp");
        }
        this.skipEOLs();
        this.next();
        Node resultType = this.parseResultType();
        if (resultType == null) {
            return null;
        }
        functionType.addChildToBack(resultType);
        return functionType;
    }

    private Node parseParametersType(JsDocToken token) {
        Node paramsType = this.newNode(83);
        boolean isVarArgs = false;
        Node paramType = null;
        if (token != JsDocToken.RIGHT_PAREN) {
            do {
                if (paramType != null) {
                    this.next();
                    this.skipEOLs();
                    token = this.next();
                }
                if (token == JsDocToken.ELLIPSIS) {
                    this.skipEOLs();
                    if (this.match(JsDocToken.RIGHT_PAREN)) {
                        paramType = this.newNode(305);
                    } else {
                        this.skipEOLs();
                        paramType = this.wrapNode(305, this.parseTypeExpression(this.next()));
                        this.skipEOLs();
                    }
                    isVarArgs = true;
                } else {
                    paramType = this.parseTypeExpression(token);
                    if (this.match(JsDocToken.EQUALS)) {
                        this.skipEOLs();
                        this.next();
                        paramType = this.wrapNode(307, paramType);
                    }
                }
                if (paramType == null) {
                    return null;
                }
                paramsType.addChildToBack(paramType);
            } while (!isVarArgs && this.match(JsDocToken.COMMA));
        }
        if (isVarArgs && this.match(JsDocToken.COMMA)) {
            return this.reportTypeSyntaxWarning("msg.jsdoc.function.varargs");
        }
        return paramsType;
    }

    private Node parseResultType() {
        this.skipEOLs();
        if (!this.match(JsDocToken.COLON)) {
            return this.newNode(124);
        }
        this.next();
        this.skipEOLs();
        if (this.match(JsDocToken.STRING) && "void".equals(this.stream.getString())) {
            this.next();
            return this.newNode(122);
        }
        return this.parseTypeExpression(this.next());
    }

    private Node parseUnionType(JsDocToken token) {
        return this.parseUnionTypeWithAlternate(token, null);
    }

    private Node parseUnionTypeWithAlternate(JsDocToken token, Node alternate) {
        Node union = this.newNode(301);
        if (alternate != null) {
            union.addChildToBack(alternate);
        }
        Node expr = null;
        do {
            if (expr != null) {
                boolean isPipe;
                this.skipEOLs();
                token = this.next();
                Preconditions.checkState((token == JsDocToken.PIPE || token == JsDocToken.COMMA ? 1 : 0) != 0);
                boolean bl = isPipe = token == JsDocToken.PIPE;
                if (isPipe && this.match(JsDocToken.PIPE)) {
                    this.next();
                }
                this.skipEOLs();
                token = this.next();
            }
            if ((expr = this.parseTypeExpression(token)) == null) {
                return null;
            }
            union.addChildToBack(expr);
        } while (this.match(JsDocToken.PIPE, JsDocToken.COMMA));
        if (alternate == null) {
            this.skipEOLs();
            if (!this.match(JsDocToken.RIGHT_PAREN)) {
                return this.reportTypeSyntaxWarning("msg.jsdoc.missing.rp");
            }
            this.next();
        }
        if (union.getChildCount() == 1) {
            Node firstChild = union.getFirstChild();
            union.removeChild(firstChild);
            return firstChild;
        }
        return union;
    }

    private Node parseRecordType(JsDocToken token) {
        Node recordType = this.newNode(309);
        Node fieldTypeList = this.parseFieldTypeList(token);
        if (fieldTypeList == null) {
            return this.reportGenericTypeSyntaxWarning();
        }
        this.skipEOLs();
        if (!this.match(JsDocToken.RIGHT_CURLY)) {
            return this.reportTypeSyntaxWarning("msg.jsdoc.missing.rc");
        }
        this.next();
        recordType.addChildToBack(fieldTypeList);
        return recordType;
    }

    private Node parseFieldTypeList(JsDocToken token) {
        Node fieldTypeList = this.newNode(308);
        HashSet<String> names = new HashSet<String>();
        while (true) {
            String name;
            Node fieldType;
            if ((fieldType = this.parseFieldType(token)) == null) {
                return null;
            }
            String string = name = fieldType.isStringKey() ? fieldType.getString() : fieldType.getFirstChild().getString();
            if (names.add(name)) {
                fieldTypeList.addChildToBack(fieldType);
            } else {
                this.parser.addTypeWarning("msg.jsdoc.type.record.duplicate", name, this.stream.getLineno(), this.stream.getCharno());
            }
            this.skipEOLs();
            if (!this.match(JsDocToken.COMMA)) break;
            this.next();
            this.skipEOLs();
            token = this.next();
        }
        return fieldTypeList;
    }

    private Node parseFieldType(JsDocToken token) {
        Node fieldName = this.parseFieldName(token);
        if (fieldName == null) {
            return null;
        }
        this.skipEOLs();
        if (!this.match(JsDocToken.COLON)) {
            return fieldName;
        }
        this.next();
        this.skipEOLs();
        Node typeExpression = this.parseTypeExpression(this.next());
        if (typeExpression == null) {
            return null;
        }
        Node fieldType = this.newNode(310);
        fieldType.addChildToBack(fieldName);
        fieldType.addChildToBack(typeExpression);
        return fieldType;
    }

    private Node parseFieldName(JsDocToken token) {
        switch (token) {
            case STRING: {
                String s = this.stream.getString();
                Node n = Node.newString(154, s, this.stream.getLineno(), this.stream.getCharno()).clonePropsFrom(this.templateNode);
                n.setLength(s.length());
                return n;
            }
        }
        return null;
    }

    private Node wrapNode(int type, Node n) {
        return n == null ? null : new Node(type, n, n.getLineno(), n.getCharno()).clonePropsFrom(this.templateNode);
    }

    private Node newNode(int type) {
        return new Node(type, this.stream.getLineno(), this.stream.getCharno()).clonePropsFrom(this.templateNode);
    }

    private Node newStringNode(String s) {
        return this.newStringNode(s, this.stream.getLineno(), this.stream.getCharno());
    }

    private Node newStringNode(String s, int lineno, int charno) {
        Node n = Node.newString(s, lineno, charno).clonePropsFrom(this.templateNode);
        n.setLength(s.length());
        return n;
    }

    private Node createTemplateNode() {
        Node templateNode = IR.script();
        templateNode.setStaticSourceFile(this.sourceFile);
        return templateNode;
    }

    private Node reportTypeSyntaxWarning(String warning) {
        this.parser.addTypeWarning(warning, this.stream.getLineno(), this.stream.getCharno());
        return null;
    }

    private Node reportGenericTypeSyntaxWarning() {
        return this.reportTypeSyntaxWarning("msg.jsdoc.type.syntax");
    }

    private JsDocToken eatUntilEOLIfNotAnnotation() {
        return this.eatUntilEOLIfNotAnnotation(this.next());
    }

    private JsDocToken eatUntilEOLIfNotAnnotation(JsDocToken token) {
        if (token == JsDocToken.ANNOTATION) {
            this.state = State.SEARCHING_ANNOTATION;
            return token;
        }
        return this.eatTokensUntilEOL(token);
    }

    private JsDocToken eatTokensUntilEOL() {
        return this.eatTokensUntilEOL(this.next());
    }

    private JsDocToken eatTokensUntilEOL(JsDocToken token) {
        while (true) {
            if (token == JsDocToken.EOL || token == JsDocToken.EOC || token == JsDocToken.EOF) {
                this.state = State.SEARCHING_ANNOTATION;
                return token;
            }
            token = this.next();
        }
    }

    private void restoreLookAhead(JsDocToken token) {
        this.unreadToken = token;
    }

    private boolean match(JsDocToken token) {
        this.unreadToken = this.next();
        return this.unreadToken == token;
    }

    private boolean match(JsDocToken token1, JsDocToken token2) {
        this.unreadToken = this.next();
        return this.unreadToken == token1 || this.unreadToken == token2;
    }

    private JsDocToken next() {
        if (this.unreadToken == NO_UNREAD_TOKEN) {
            return this.stream.getJsDocToken();
        }
        return this.current();
    }

    private JsDocToken current() {
        JsDocToken t = this.unreadToken;
        this.unreadToken = NO_UNREAD_TOKEN;
        return t;
    }

    private void skipEOLs() {
        while (this.match(JsDocToken.EOL)) {
            this.next();
            if (!this.match(JsDocToken.STAR)) continue;
            this.next();
        }
    }

    private String getRemainingJSDocLine() {
        String result = this.stream.getRemainingJSDocLine();
        this.unreadToken = NO_UNREAD_TOKEN;
        return result;
    }

    private boolean hasParsedFileOverviewDocInfo() {
        return this.jsdocBuilder.isPopulatedWithFileOverview();
    }

    JSDocInfo retrieveAndResetParsedJSDocInfo() {
        return this.jsdocBuilder.build();
    }

    JSDocInfo getFileOverviewJSDocInfo() {
        return this.fileOverviewJSDocInfo;
    }

    private boolean lookAheadForType() {
        return this.lookAheadFor('{');
    }

    private boolean lookAheadForAnnotation() {
        return this.lookAheadFor('@');
    }

    private boolean lookAheadFor(char expect) {
        int c;
        boolean matched = false;
        while ((c = this.stream.getChar()) == 32) {
        }
        if (c == expect) {
            matched = true;
        }
        this.stream.ungetChar(c);
        return matched;
    }

    private static enum WhitespaceOption {
        PRESERVE,
        TRIM,
        SINGLE_LINE;

    }

    private static class ExtendedTypeInfo {
        final JSTypeExpression type;
        final int lineno;
        final int charno;

        public ExtendedTypeInfo(JSTypeExpression type, int lineno, int charno) {
            this.type = type;
            this.lineno = lineno;
            this.charno = charno;
        }
    }

    private static class ExtractionInfo {
        private final String string;
        private final JsDocToken token;

        public ExtractionInfo(String string, JsDocToken token) {
            this.string = string;
            this.token = token;
        }
    }

    private static enum State {
        SEARCHING_ANNOTATION,
        SEARCHING_NEWLINE,
        NEXT_IS_ANNOTATION;

    }

    private class ErrorReporterParser {
        private ErrorReporterParser() {
        }

        void addParserWarning(String messageId, String messageArg, int lineno, int charno) {
            JsDocInfoParser.this.errorReporter.warning(SimpleErrorReporter.getMessage1(messageId, messageArg), JsDocInfoParser.this.getSourceName(), lineno, charno);
        }

        void addParserWarning(String messageId, int lineno, int charno) {
            JsDocInfoParser.this.errorReporter.warning(SimpleErrorReporter.getMessage0(messageId), JsDocInfoParser.this.getSourceName(), lineno, charno);
        }

        void addTypeWarning(String messageId, String messageArg, int lineno, int charno) {
            JsDocInfoParser.this.errorReporter.warning("Bad type annotation. " + SimpleErrorReporter.getMessage1(messageId, messageArg), JsDocInfoParser.this.getSourceName(), lineno, charno);
        }

        void addTypeWarning(String messageId, int lineno, int charno) {
            JsDocInfoParser.this.errorReporter.warning("Bad type annotation. " + SimpleErrorReporter.getMessage0(messageId), JsDocInfoParser.this.getSourceName(), lineno, charno);
        }
    }
}

