/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc.datasource;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.geotools.data.jdbc.datasource.DataSourceFactorySpi;
import org.geotools.data.jdbc.datasource.UnWrapper;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryRegistry;
import org.geotools.util.logging.Logging;

public final class DataSourceFinder {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.jdbc");
    private static FactoryRegistry registry;

    private DataSourceFinder() {
    }

    public static synchronized DataSource getDataSource(Map params) throws IOException {
        Iterator ps = DataSourceFinder.getAvailableDataSources();
        while (ps.hasNext()) {
            DataSourceFactorySpi fac = (DataSourceFactorySpi)ps.next();
            try {
                if (!fac.canProcess(params)) continue;
                return fac.createDataSource(params);
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Could not acquire " + fac.getDescription() + ":" + t, t);
            }
        }
        return null;
    }

    public static synchronized UnWrapper getUnWrapper(Connection conn) throws IOException {
        Iterator ps = DataSourceFinder.getUnWrappers();
        while (ps.hasNext()) {
            UnWrapper uw = (UnWrapper)ps.next();
            try {
                if (!uw.canUnwrap(conn)) continue;
                return uw;
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Could not test  " + uw + " for unwrapping abilities agaist " + conn, t);
            }
        }
        return null;
    }

    public static synchronized UnWrapper getUnWrapper(Statement st) throws IOException {
        Iterator ps = DataSourceFinder.getUnWrappers();
        while (ps.hasNext()) {
            UnWrapper uw = (UnWrapper)ps.next();
            try {
                if (!uw.canUnwrap(st)) continue;
                return uw;
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Could not test  " + uw + " for unwrapping abilities agaist " + st, t);
            }
        }
        return null;
    }

    public static synchronized Iterator getAvailableDataSources() {
        HashSet<DataSourceFactorySpi> availableDS = new HashSet<DataSourceFactorySpi>();
        Iterator it = DataSourceFinder.getServiceRegistry().getServiceProviders(DataSourceFactorySpi.class, null, null);
        while (it.hasNext()) {
            DataSourceFactorySpi dsFactory = (DataSourceFactorySpi)it.next();
            if (!dsFactory.isAvailable()) continue;
            availableDS.add(dsFactory);
        }
        return availableDS.iterator();
    }

    public static synchronized Iterator getUnWrappers() {
        HashSet availableDS = new HashSet();
        return DataSourceFinder.getServiceRegistry().getServiceProviders(UnWrapper.class, null, null);
    }

    private static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(DataSourceFinder.class));
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(DataSourceFactorySpi.class, UnWrapper.class));
        }
        return registry;
    }

    public static synchronized void scanForPlugins() {
        DataSourceFinder.getServiceRegistry().scanForPlugins();
    }
}

