/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.processing;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.api.processing.report.MetadataReplacementProcessingReport;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.MetadataDataInfo;
import org.fao.geonet.events.history.RecordProcessingChangeEvent;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.MetadataIndexerProcessor;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.search.LuceneSearcher;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.springframework.context.ApplicationContext;

public class MetadataSearchAndReplace
extends MetadataIndexerProcessor {
    String process;
    Map<String, String> params;
    ServiceContext context;
    Set<String> metadata;
    MetadataReplacementProcessingReport report;
    boolean isTesting;
    boolean isCaseInsensitive;
    String vacuumMode;

    public MetadataSearchAndReplace(DataManager dm, String process, boolean isTesting, boolean isCaseInsensitive, String vacuumMode, Map<String, String> params, ServiceContext context, Set<String> records, MetadataReplacementProcessingReport report) {
        super(dm);
        this.process = process;
        this.params = params;
        this.context = context;
        this.metadata = records;
        this.report = report;
        this.isTesting = isTesting;
        this.isCaseInsensitive = isCaseInsensitive;
        this.vacuumMode = vacuumMode;
    }

    public void process() throws Exception {
        GeonetContext gc = (GeonetContext)this.context.getHandlerContext("contextName");
        DataManager dm = (DataManager)gc.getBean(DataManager.class);
        Element replacements = new Element("replacements");
        if (this.isCaseInsensitive) {
            Element caseInsensitiveEl = new Element("caseInsensitive").setText("true");
            replacements.addContent((Content)caseInsensitiveEl);
        }
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            if (!entry.getKey().startsWith("mdfield-")) continue;
            String key = entry.getKey().split("-")[1];
            String searchValue = this.params.get("searchValue-" + key);
            String replaceValue = this.params.get("replaceValue-" + key);
            Element replacement = new Element("replacement");
            replacement.addContent((Content)new Element("field").setText(entry.getValue()));
            replacement.addContent((Content)new Element("searchValue").setText(searchValue));
            replacement.addContent((Content)new Element("replaceValue").setText(replaceValue));
            replacements.addContent((Content)replacement);
        }
        String replacementsString = Xml.getString((Element)replacements);
        for (String uuid : this.metadata) {
            String id = dm.getMetadataId(uuid);
            this.context.info("Processing metadata with id:" + id);
            this.processInternal(id, this.process, "replacements", replacementsString, this.context);
        }
    }

    private Element processInternal(String id, String process, String paramNameXml, String paramXml, ServiceContext context) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dataMan = (DataManager)gc.getBean(DataManager.class);
        SchemaManager schemaMan = (SchemaManager)gc.getBean(SchemaManager.class);
        AccessManager accessMan = (AccessManager)gc.getBean(AccessManager.class);
        this.report.incrementProcessedRecords();
        if (id == null) {
            this.report.incrementNullRecords();
            return null;
        }
        int iId = Integer.valueOf(id);
        IMetadataUtils metadataRepository = (IMetadataUtils)context.getBean(IMetadataUtils.class);
        AbstractMetadata metadataEntity = metadataRepository.findOne(iId);
        MetadataDataInfo info = metadataEntity.getDataInfo();
        String metadataTitle = LuceneSearcher.getMetadataFromIndexById((String)context.getLanguage(), (String)id, (String)"title");
        if (StringUtils.isEmpty((String)metadataTitle)) {
            metadataTitle = metadataEntity.getUuid();
        }
        if (info == null) {
            this.report.incrementNullRecords();
        } else if (!accessMan.isOwner(context, id)) {
            this.report.addNotEditableMetadataId(iId);
        } else {
            String schema = info.getSchemaId();
            String filePath = schemaMan.getSchemaDir(schema) + "/process/" + process + ".xsl";
            File xslProcessing = new File(filePath);
            if (!xslProcessing.exists()) {
                context.info("  Processing instruction not found for " + schema + " schema.");
                this.report.addNoProcessFoundMetadataId(iId);
                return null;
            }
            Element processedMetadata = null;
            try {
                boolean hasChanges;
                Element md = dataMan.getMetadataNoInfo(context, id);
                processedMetadata = Xml.transformWithXmlParam((Element)md, (String)filePath, (String)paramNameXml, (String)paramXml);
                Path filePath2 = schemaMan.getSchemaDir(schema).resolve("process/massive-content-update-extract-changes.xsl");
                List changesEl = Xml.transform((Element)processedMetadata, (Path)filePath2).getChildren("change");
                boolean bl = hasChanges = changesEl.size() > 0;
                if (hasChanges) {
                    this.report.addMetadataChanges(iId, changesEl);
                } else {
                    this.report.addMetadataInfos(metadataEntity, "No changes.");
                }
                if (changesEl.size() > 0 && !this.isTesting) {
                    Path filePath3 = schemaMan.getSchemaDir(schema).resolve("process/massive-content-update-clean-changes.xsl");
                    if (!StringUtils.isEmpty((String)this.vacuumMode)) {
                        if ("record".equals(this.vacuumMode)) {
                            processedMetadata = Xml.transform((Element)processedMetadata, (Path)filePath3);
                            Path vacuumXsltPath = schemaMan.getSchemaDir(schema).resolve("process/vacuum.xsl");
                            if (vacuumXsltPath.toFile().exists()) {
                                processedMetadata = Xml.transform((Element)processedMetadata, (Path)vacuumXsltPath);
                            }
                        } else if ("element".equals(this.vacuumMode)) {
                            HashMap<String, String> params = new HashMap<String, String>(1);
                            params.put("removeEmptyElement", "true");
                            processedMetadata = Xml.transform((Element)processedMetadata, (Path)filePath3, params);
                        }
                    } else {
                        processedMetadata = Xml.transform((Element)processedMetadata, (Path)filePath3);
                    }
                    dataMan.updateMetadata(context, id, processedMetadata, false, true, true, context.getLanguage(), new ISODate().toString(), true);
                    UserSession userSession = context.getUserSession();
                    if (userSession != null) {
                        XMLOutputter outp = new XMLOutputter();
                        String xmlAfter = outp.outputString(processedMetadata);
                        String xmlBefore = outp.outputString(md);
                        new RecordProcessingChangeEvent(Long.valueOf(Long.parseLong(id)), Integer.valueOf(Integer.parseInt(userSession.getUserId())), xmlBefore, xmlAfter, process).publish((ApplicationContext)ApplicationContextHolder.get());
                    }
                }
            }
            catch (Exception e) {
                this.report.addMetadataError(metadataEntity, e);
            }
            return processedMetadata;
        }
        return null;
    }
}

