/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils;

import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.fao.geonet.Logger;

public final class Log {
    public static final String JEEVES = "jeeves";
    public static final String ENGINE = "jeeves.engine";
    public static final String MONITOR = "jeeves.monitor";
    public static final String APPHAND = "jeeves.apphand";
    public static final String WEBAPP = "jeeves.webapp";
    public static final String REQUEST = "jeeves.request";
    public static final String SERVICE = "jeeves.service";
    public static final String SCHEDULER = "jeeves.scheduler";
    public static final String RESOURCES = "jeeves.resources";
    public static final String XLINK_PROCESSOR = "jeeves.xlinkprocessor";
    public static final String XML_RESOLVER = "jeeves.xmlresolver";
    public static final String TRANSFORMER_FACTORY = "jeeves.transformerFactory";

    private Log() {
    }

    public static void debug(String module, Object message) {
        org.apache.log4j.Logger.getLogger((String)module).debug(message);
    }

    public static void debug(String module, Object message, Exception e) {
        org.apache.log4j.Logger.getLogger((String)module).debug(message, (Throwable)e);
    }

    public static boolean isDebugEnabled(String module) {
        return org.apache.log4j.Logger.getLogger((String)module).isDebugEnabled();
    }

    public static boolean isEnabledFor(String module, int priority) {
        return org.apache.log4j.Logger.getLogger((String)module).isEnabledFor(Priority.toPriority((int)priority));
    }

    public static void trace(String module, Object message) {
        org.apache.log4j.Logger.getLogger((String)module).trace(message);
    }

    public static void trace(String module, Object message, Exception e) {
        org.apache.log4j.Logger.getLogger((String)module).trace(message, (Throwable)e);
    }

    public static boolean isTraceEnabled(String module) {
        return org.apache.log4j.Logger.getLogger((String)module).isTraceEnabled();
    }

    public static void info(String module, Object message) {
        org.apache.log4j.Logger.getLogger((String)module).info(message);
    }

    public static void info(String module, Object message, Throwable t) {
        org.apache.log4j.Logger.getLogger((String)module).info(message, t);
    }

    public static void warning(String module, Object message) {
        org.apache.log4j.Logger.getLogger((String)module).warn(message);
    }

    public static void warning(String module, Object message, Throwable e) {
        org.apache.log4j.Logger.getLogger((String)module).warn(message, e);
    }

    public static void error(String module, Object message) {
        org.apache.log4j.Logger.getLogger((String)module).error(message);
    }

    public static void error(String module, Object message, Throwable t) {
        org.apache.log4j.Logger.getLogger((String)module).error(message, t);
    }

    public static void fatal(String module, Object message) {
        org.apache.log4j.Logger.getLogger((String)module).fatal(message);
    }

    public static Logger createLogger(String module) {
        return Log.createLogger(module, null);
    }

    public static Logger createLogger(final String module, final String fallbackModule) {
        return new Logger(){

            @Override
            public boolean isDebugEnabled() {
                return Log.isDebugEnabled(module);
            }

            @Override
            public void debug(String message) {
                Log.debug(module, message);
            }

            @Override
            public void info(String message) {
                Log.info(module, message);
            }

            @Override
            public void warning(String message) {
                Log.warning(module, message);
            }

            @Override
            public void error(String message) {
                Log.error(module, message);
            }

            @Override
            public void fatal(String message) {
                Log.fatal(module, message);
            }

            @Override
            public void error(Throwable t) {
                Log.error(module, t.getMessage(), t);
            }

            @Override
            public void setAppender(FileAppender fa) {
                org.apache.log4j.Logger.getLogger((String)module).removeAllAppenders();
                org.apache.log4j.Logger.getLogger((String)module).addAppender((Appender)fa);
            }

            @Override
            public String getFileAppender() {
                Appender a;
                org.apache.log4j.Logger.getLogger((String)module).setLevel(this.getThreshold());
                Enumeration appenders = org.apache.log4j.Logger.getLogger((String)module).getAllAppenders();
                while (appenders.hasMoreElements()) {
                    a = (Appender)appenders.nextElement();
                    if (!(a instanceof FileAppender)) continue;
                    return ((FileAppender)a).getFile();
                }
                appenders = org.apache.log4j.Logger.getLogger((String)fallbackModule).getAllAppenders();
                while (appenders.hasMoreElements()) {
                    a = (Appender)appenders.nextElement();
                    if (!(a instanceof FileAppender)) continue;
                    return ((FileAppender)a).getFile();
                }
                return "";
            }

            @Override
            public Level getThreshold() {
                return org.apache.log4j.Logger.getLogger((String)fallbackModule).getEffectiveLevel();
            }

            @Override
            public String getModule() {
                return module;
            }
        };
    }
}

