/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.newtypes.EnumType;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.ObjectType;

final class UnionType
extends JSType {
    private final int mask;
    private final ImmutableSet<ObjectType> objs;
    private final String typeVar;
    private final ImmutableSet<EnumType> enums;

    UnionType(int mask, ImmutableSet<ObjectType> objs, String typeVar, ImmutableSet<EnumType> enums) {
        this.enums = (ImmutableSet)Preconditions.checkNotNull(enums);
        this.objs = (ImmutableSet)Preconditions.checkNotNull(objs);
        if (typeVar != null) {
            mask |= 1;
        }
        this.typeVar = typeVar;
        this.mask = mask;
        if (!this.isValidType()) {
            throw new IllegalStateException(String.format("Cannot create type with bits <<<%x>>>, objs <<<%s>>>, typeVar <<<%s>>>, enums <<<%s>>>", mask, objs, typeVar, enums));
        }
    }

    UnionType(int mask) {
        this(mask, null, null, null);
    }

    @Override
    protected int getMask() {
        return this.mask;
    }

    @Override
    protected ImmutableSet<ObjectType> getObjs() {
        return (ImmutableSet)Preconditions.checkNotNull(this.objs);
    }

    @Override
    protected String getTypeVar() {
        return this.typeVar;
    }

    @Override
    protected ImmutableSet<EnumType> getEnums() {
        return (ImmutableSet)Preconditions.checkNotNull(this.enums);
    }
}

