/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_0_0;

import com.vividsolutions.jts.geom.Envelope;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.naming.OperationNotSupportedException;
import javax.swing.Icon;
import javax.xml.namespace.QName;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSServiceInfo;
import org.geotools.data.wfs.protocol.http.HttpMethod;
import org.geotools.data.wfs.v1_0_0.FeatureSetDescription;
import org.geotools.data.wfs.v1_0_0.LogInputStream;
import org.geotools.data.wfs.v1_0_0.LogWriterDecorator;
import org.geotools.data.wfs.v1_0_0.MapServerWFSStrategy;
import org.geotools.data.wfs.v1_0_0.NonStrictWFSStrategy;
import org.geotools.data.wfs.v1_0_0.StrictWFSStrategy;
import org.geotools.data.wfs.v1_0_0.UpdateFidFilterVisitor;
import org.geotools.data.wfs.v1_0_0.WFS100ProtocolHandler;
import org.geotools.data.wfs.v1_0_0.WFSCapabilities;
import org.geotools.data.wfs.v1_0_0.WFSFeatureReader;
import org.geotools.data.wfs.v1_0_0.WFSFeatureSource;
import org.geotools.data.wfs.v1_0_0.WFSFeatureStore;
import org.geotools.data.wfs.v1_0_0.WFSStrategy;
import org.geotools.data.wfs.v1_0_0.WFSTransactionAccessor;
import org.geotools.data.wfs.v1_0_0.WFSTransactionState;
import org.geotools.data.wfs.v1_0_0.gml.WFSFeatureTypeTransformer;
import org.geotools.data.wfs.v1_0_0.xml.WFSSchema;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.visitor.ClientTransactionAccessor;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.geotools.xml.DocumentWriter;
import org.geotools.xml.SchemaFactory;
import org.geotools.xml.filter.FilterSchema;
import org.geotools.xml.gml.GMLComplexTypes;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.Schema;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.spatial.BBOX;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.xml.sax.SAXException;

@Deprecated
public class WFS_1_0_0_DataStore
extends AbstractDataStore
implements WFSDataStore {
    public static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.wfs.1.1.0");
    protected WFSCapabilities capabilities = null;
    protected HttpMethod preferredProtocol = HttpMethod.POST;
    private final int bufferSize;
    private final int timeout;
    protected WFSStrategy strategy;
    private boolean lenient;
    WFS100ProtocolHandler protocolHandler;
    private String[] typeNames = null;
    private Map<String, SimpleFeatureType> featureTypeCache = new HashMap<String, SimpleFeatureType>();
    private Map<String, String> fidMap = new HashMap<String, String>();
    private String wfsStrategy = null;
    private Integer filterCompliance = null;
    private String namespaceOverride;

    public WFS_1_0_0_DataStore(HttpMethod protocol, WFS100ProtocolHandler protocolHandler, int timeout, int buffer, boolean lenient) throws SAXException, IOException {
        this(protocol, protocolHandler, timeout, buffer, lenient, null, null);
    }

    public WFS_1_0_0_DataStore(HttpMethod protocol, WFS100ProtocolHandler protocolHandler, int timeout, int buffer, boolean lenient, String wfsStrategy, Integer filterCompliance) throws SAXException, IOException {
        super(true);
        this.capabilities = protocolHandler.getCapabilities();
        this.protocolHandler = protocolHandler;
        this.lenient = lenient;
        this.preferredProtocol = protocol;
        this.timeout = timeout;
        this.bufferSize = buffer;
        this.wfsStrategy = wfsStrategy;
        this.filterCompliance = filterCompliance;
        this.determineCorrectStrategy();
    }

    public String getDefaultEncoding() {
        return this.protocolHandler.getEncoding();
    }

    @Override
    public WFSServiceInfo getInfo() {
        return new WFSServiceInfo(){

            @Override
            public String getDescription() {
                return WFS_1_0_0_DataStore.this.capabilities.getService().get_abstract();
            }

            public Icon getIcon() {
                return null;
            }

            @Override
            public Set<String> getKeywords() {
                String[] keywordList = WFS_1_0_0_DataStore.this.capabilities.getService().getKeywordList();
                if (keywordList == null) {
                    return Collections.emptySet();
                }
                return new HashSet<String>(Arrays.asList(keywordList));
            }

            @Override
            public URI getPublisher() {
                return null;
            }

            @Override
            public URI getSchema() {
                try {
                    return new URI("http://schemas.opengis.net/wfs/1.0.0/WFS-transaction.xsd");
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public URI getSource() {
                try {
                    return WFS_1_0_0_DataStore.this.capabilities.getGetCapabilities().getGet().toURI();
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }

            @Override
            public String getTitle() {
                return WFS_1_0_0_DataStore.this.capabilities.getService().getTitle();
            }

            @Override
            public String getVersion() {
                return "1.0.0";
            }
        };
    }

    private void determineCorrectStrategy() {
        URL host = this.capabilities.getGetCapabilities().getGet();
        if (this.wfsStrategy != null && this.wfsStrategy.equalsIgnoreCase("mapserver")) {
            this.strategy = new MapServerWFSStrategy(this, this.filterCompliance);
        } else if (this.wfsStrategy != null && this.wfsStrategy.equalsIgnoreCase("geoserver")) {
            this.strategy = new NonStrictWFSStrategy(this, this.filterCompliance);
        } else if (this.wfsStrategy != null && this.wfsStrategy.equalsIgnoreCase("strict")) {
            this.strategy = new StrictWFSStrategy(this, this.filterCompliance);
        } else if (this.wfsStrategy != null && this.wfsStrategy.equalsIgnoreCase("nonstrict")) {
            this.strategy = new NonStrictWFSStrategy(this, this.filterCompliance);
        } else {
            if (host == null) {
                host = this.capabilities.getGetCapabilities().getPost();
            }
            this.strategy = host.toString().indexOf("mapserv") != -1 ? new MapServerWFSStrategy(this, this.filterCompliance) : (host.toString().indexOf("geoserver") != -1 ? new NonStrictWFSStrategy(this, this.filterCompliance) : (this.lenient ? new NonStrictWFSStrategy(this, this.filterCompliance) : new StrictWFSStrategy(this, this.filterCompliance)));
        }
    }

    @Override
    public String[] getTypeNames() {
        if (this.typeNames == null) {
            List<FeatureSetDescription> l = this.capabilities.getFeatureTypes();
            this.typeNames = new String[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                this.typeNames[i] = l.get(i).getName();
            }
        }
        String[] retVal = new String[this.typeNames.length];
        System.arraycopy(this.typeNames, 0, retVal, 0, this.typeNames.length);
        return retVal;
    }

    @Override
    public SimpleFeatureType getSchema(String typeName) throws IOException {
        if (this.featureTypeCache.containsKey(typeName)) {
            return this.featureTypeCache.get(typeName);
        }
        SimpleFeatureType featureType = null;
        SAXException sax = null;
        IOException io = null;
        if (this.preferredProtocol == HttpMethod.POST) {
            try {
                featureType = this.getSchemaPost(typeName);
            }
            catch (SAXException e) {
                LOGGER.warning(e.toString());
                sax = e;
            }
            catch (IOException e) {
                LOGGER.warning(e.toString());
                io = e;
            }
        }
        if (featureType == null) {
            try {
                featureType = this.getSchemaGet(typeName);
            }
            catch (SAXException e) {
                LOGGER.warning(e.toString());
                sax = e;
            }
            catch (IOException e) {
                LOGGER.warning(e.toString());
                io = e;
            }
        }
        if (featureType == null) {
            if (sax != null) {
                throw new DataSourceException(sax);
            }
            throw io;
        }
        FeatureSetDescription fsd = WFSCapabilities.getFeatureSetDescription(this.capabilities, typeName);
        String crsName = null;
        String ftName = null;
        if (fsd != null) {
            crsName = fsd.getSRS();
            ftName = fsd.getName();
            try {
                if (crsName != null) {
                    CoordinateReferenceSystem crs = CRS.decode((String)crsName, (boolean)true);
                    featureType = WFSFeatureTypeTransformer.transform(featureType, crs);
                }
            }
            catch (FactoryException e) {
                LOGGER.warning(e.getMessage());
            }
            catch (SchemaException e) {
                LOGGER.warning(e.getMessage());
            }
        }
        if (ftName != null) {
            SimpleFeatureTypeBuilder build = new SimpleFeatureTypeBuilder();
            build.init(featureType);
            build.setName(ftName);
            if (this.namespaceOverride != null) {
                build.setNamespaceURI(this.namespaceOverride);
            }
            featureType = build.buildFeatureType();
        }
        if (featureType != null) {
            this.featureTypeCache.put(typeName, featureType);
        }
        return featureType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SimpleFeatureType getSchemaGet(String typeName) throws SAXException, IOException {
        Schema schema;
        HttpURLConnection hc = this.protocolHandler.createDescribeFeatureTypeConnection(typeName, HttpMethod.GET);
        if (hc == null) {
            return null;
        }
        try (InputStream is = this.protocolHandler.getConnectionFactory().getInputStream(hc);){
            schema = SchemaFactory.getInstance(null, is);
        }
        return WFS_1_0_0_DataStore.parseDescribeFeatureTypeResponse(typeName, schema);
    }

    static SimpleFeatureType parseDescribeFeatureTypeResponse(String typeName, Schema schema) throws SAXException {
        Element[] elements = schema.getElements();
        if (elements == null) {
            return null;
        }
        Element element = null;
        String ttname = typeName.substring(typeName.indexOf(":") + 1);
        for (int i = 0; i < elements.length && element == null; ++i) {
            if (!typeName.equals(elements[i].getName()) && !ttname.equals(elements[i].getName())) continue;
            element = elements[i];
        }
        if (element == null) {
            return null;
        }
        SimpleFeatureType ft = GMLComplexTypes.createFeatureType(element);
        return ft;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SimpleFeatureType getSchemaPost(String typeName) throws IOException, SAXException {
        Schema schema;
        HttpURLConnection hc = this.protocolHandler.createDescribeFeatureTypeConnection(typeName, HttpMethod.POST);
        Writer osw = this.getOutputStream(hc);
        HashMap<String, Object> hints = new HashMap<String, Object>();
        hints.put("DocumentWriter_BASE_ELEMENT", WFSSchema.getInstance().getElements()[1]);
        List<FeatureSetDescription> l = this.capabilities.getFeatureTypes();
        Iterator<FeatureSetDescription> it = l.iterator();
        URI uri = null;
        while (it.hasNext() && uri == null) {
            FeatureSetDescription fsd = it.next();
            if (!typeName.equals(fsd.getName())) continue;
            uri = fsd.getNamespace();
        }
        if (uri != null) {
            hints.put("DocumentWriter_SCHEMA_ORDER", new String[]{WFSSchema.NAMESPACE.toString(), uri.toString()});
        }
        hints.put("DocumentWriter_ENCODING", this.protocolHandler.getEncoding());
        try {
            DocumentWriter.writeDocument((Object)new String[]{typeName}, WFSSchema.getInstance(), osw, hints);
        }
        catch (OperationNotSupportedException e) {
            LOGGER.warning(e.getMessage());
            throw new SAXException(e);
        }
        osw.flush();
        osw.close();
        try (InputStream is = this.protocolHandler.getConnectionFactory().getInputStream(hc);){
            schema = SchemaFactory.getInstance(null, is);
        }
        return WFS_1_0_0_DataStore.parseDescribeFeatureTypeResponse(typeName, schema);
    }

    /*
     * WARNING - void declaration
     */
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReaderGet(Query request, Transaction transaction) throws UnsupportedEncodingException, IOException, SAXException {
        void var10_15;
        URL getUrl = this.capabilities.getGetFeature().getGet();
        if (getUrl == null) {
            return null;
        }
        String query = getUrl.getQuery();
        query = query == null ? null : query.toUpperCase();
        String url = getUrl.toString();
        if (query == null || "".equals(query)) {
            if (url == null || !url.endsWith("?")) {
                url = url + "?";
            }
            url = url + "SERVICE=WFS";
        } else if (query.indexOf("SERVICE=WFS") == -1) {
            url = url + "&SERVICE=WFS";
        }
        if (query == null || query.indexOf("VERSION") == -1) {
            url = url + "&VERSION=1.0.0";
        }
        if (query == null || query.indexOf("REQUEST") == -1) {
            url = url + "&REQUEST=GetFeature";
        }
        if (request != null) {
            if (request.getMaxFeatures() != Integer.MAX_VALUE) {
                url = url + "&MAXFEATURES=" + request.getMaxFeatures();
            }
            Filter filter = request.getFilter();
            String typeName = request.getTypeName();
            if (filter != null) {
                if (filter instanceof BBOX) {
                    String bb = this.printBBoxGet((BBOX)filter, typeName);
                    if (bb != null) {
                        url = url + "&BBOX=" + URLEncoder.encode(bb, this.protocolHandler.getEncoding());
                    }
                } else if (filter instanceof Id) {
                    Id ff = (Id)filter;
                    Set fids = ff.getIDs();
                    if (fids != null && !fids.isEmpty()) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("&FEATUREID=");
                        boolean first = true;
                        for (Object fid : fids) {
                            if (first) {
                                first = false;
                            } else {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(fid);
                        }
                        url = url + stringBuilder.toString();
                    }
                } else if (filter != Filter.INCLUDE && filter != Filter.EXCLUDE) {
                    String print = this.printFilter(filter);
                    String encode = URLEncoder.encode(print, this.protocolHandler.getEncoding());
                    url = url + "&FILTER=" + (String)encode;
                }
                if (request.getHints() != null && request.getHints().get((Object)WFSDataStore.WFS_VENDOR_PARAMETERS) != null) {
                    Map vendorParams = (Map)request.getHints().get((Object)WFSDataStore.WFS_VENDOR_PARAMETERS);
                    for (Map.Entry entry : vendorParams.entrySet()) {
                        url = url + "&" + (String)entry.getKey() + "=" + URLEncoder.encode((String)entry.getValue(), this.protocolHandler.getEncoding());
                    }
                }
            }
        }
        url = url + "&TYPENAME=" + URLEncoder.encode(request.getTypeName(), this.protocolHandler.getEncoding());
        Logging.getLogger((String)"org.geotools.data.wfs").fine(url);
        Logging.getLogger((String)"org.geotools.data.communication").fine("Output: " + url);
        getUrl = new URL(url);
        HttpURLConnection hc = this.protocolHandler.getConnectionFactory().getConnection(getUrl, HttpMethod.GET);
        InputStream is = this.protocolHandler.getConnectionFactory().getInputStream(hc);
        WFSTransactionState ts = null;
        if (transaction != Transaction.AUTO_COMMIT && (ts = (WFSTransactionState)transaction.getState(this)) == null) {
            ts = new WFSTransactionState(this);
            transaction.putState(this, ts);
        }
        SimpleFeatureType schema = this.getSchema(request.getTypeName());
        try {
            SimpleFeatureType simpleFeatureType = DataUtilities.createSubType((SimpleFeatureType)schema, (String[])request.getPropertyNames(), (CoordinateReferenceSystem)request.getCoordinateSystem());
        }
        catch (SchemaException e) {
            SimpleFeatureType simpleFeatureType = schema;
        }
        schema.getUserData().put("lenient", true);
        WFSFeatureReader ft = WFSFeatureReader.getFeatureReader(is, this.bufferSize, this.timeout, ts, schema);
        if (!var10_15.equals(ft.getFeatureType())) {
            LOGGER.fine("Recasting feature type to subtype by using a ReTypeFeatureReader");
            return new ReTypeFeatureReader((FeatureReader)ft, (SimpleFeatureType)var10_15, false);
        }
        return ft;
    }

    Writer getOutputStream(HttpURLConnection hc) throws IOException {
        OutputStream os = hc.getOutputStream();
        String encoding = this.getDefaultEncoding();
        Writer w = new OutputStreamWriter(os, encoding);
        Logger logger = Logging.getLogger((String)"org.geotools.data.wfs");
        if (logger.isLoggable(Level.FINE)) {
            w = new LogWriterDecorator(w, logger, Level.FINE);
        }
        if ((logger = Logging.getLogger((String)"org.geotools.data.communication")).isLoggable(Level.FINE)) {
            w = new LogWriterDecorator(w, logger, Level.FINE);
        }
        return w;
    }

    static InputStream getInputStream(HttpURLConnection hc, boolean tryGZIP) throws IOException {
        InputStream is = hc.getInputStream();
        if (tryGZIP && hc.getContentEncoding() != null && hc.getContentEncoding().indexOf("gzip") != -1) {
            is = new GZIPInputStream(is);
        }
        is = new BufferedInputStream(is);
        Logger logger = Logging.getLogger((String)"org.geotools.data.communication");
        if (logger.isLoggable(Level.FINE)) {
            is = new LogInputStream(is, logger, Level.FINE);
        }
        return is;
    }

    private String printFilter(Filter f) throws IOException, SAXException {
        HashMap<String, Element> hints = new HashMap<String, Element>();
        hints.put("DocumentWriter_BASE_ELEMENT", FilterSchema.getInstance().getElements()[2]);
        StringWriter w = new StringWriter();
        try {
            DocumentWriter.writeFragment((Object)f, (Schema)FilterSchema.getInstance(), w, hints);
        }
        catch (OperationNotSupportedException e) {
            LOGGER.warning(e.toString());
            throw new SAXException(e);
        }
        return w.toString();
    }

    private String printBBoxGet(BBOX bbox, String typeName) throws IOException {
        return bbox.getMinX() + "," + bbox.getMinY() + "," + bbox.getMaxX() + "," + bbox.getMaxY();
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReaderPost(Query query, Transaction transaction) throws SAXException, IOException {
        SimpleFeatureType featureType;
        URL postUrl = this.capabilities.getGetFeature().getPost();
        if (postUrl == null) {
            return null;
        }
        if (query != null && query.getHints() != null && query.getHints().get((Object)WFSDataStore.WFS_VENDOR_PARAMETERS) != null) {
            String url = postUrl.toString();
            if (url == null || !url.endsWith("?")) {
                url = url + "?";
            }
            boolean first = true;
            if (query.getHints() != null && query.getHints().get((Object)WFSDataStore.WFS_VENDOR_PARAMETERS) != null) {
                Map vendorParams = (Map)query.getHints().get((Object)WFSDataStore.WFS_VENDOR_PARAMETERS);
                for (Map.Entry entry : vendorParams.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        url = url + "&";
                    }
                    url = url + (String)entry.getKey() + "=" + URLEncoder.encode((String)entry.getValue(), this.protocolHandler.getEncoding());
                }
            }
            postUrl = new URL(url);
        }
        HttpURLConnection hc = this.protocolHandler.getConnectionFactory().getConnection(postUrl, HttpMethod.POST);
        Writer w = this.getOutputStream(hc);
        HashMap<String, Object> hints = new HashMap<String, Object>();
        hints.put("DocumentWriter_BASE_ELEMENT", WFSSchema.getInstance().getElements()[2]);
        hints.put("DocumentWriter_ENCODING", this.protocolHandler.getEncoding());
        try {
            DocumentWriter.writeDocument((Object)query, WFSSchema.getInstance(), w, hints);
        }
        catch (OperationNotSupportedException e) {
            LOGGER.warning(e.toString());
            throw new SAXException(e);
        }
        finally {
            w.flush();
            w.close();
        }
        InputStream is = this.protocolHandler.getConnectionFactory().getInputStream(hc);
        WFSTransactionState ts = null;
        if (transaction != Transaction.AUTO_COMMIT && (ts = (WFSTransactionState)transaction.getState(this)) == null) {
            ts = new WFSTransactionState(this);
            transaction.putState(this, ts);
        }
        SimpleFeatureType schema = this.getSchema(query.getTypeName());
        try {
            featureType = DataUtilities.createSubType((SimpleFeatureType)schema, (String[])query.getPropertyNames(), (CoordinateReferenceSystem)query.getCoordinateSystem());
        }
        catch (SchemaException e) {
            featureType = schema;
        }
        schema.getUserData().put("lenient", true);
        WFSFeatureReader ft = WFSFeatureReader.getFeatureReader(is, this.bufferSize, this.timeout, ts, schema);
        if (!featureType.equals(ft.getFeatureType())) {
            LOGGER.fine("Recasting feature type to subtype by using a ReTypeFeatureReader");
            return new ReTypeFeatureReader((FeatureReader)ft, featureType, false);
        }
        return ft;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String typeName) throws IOException {
        return this.getFeatureReader(typeName, new Query(typeName));
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String typeName, Query query) throws IOException {
        if (query.getTypeName() == null || !query.getTypeName().equals(typeName)) {
            Query q = new Query(query);
            q.setTypeName(typeName);
            return this.getFeatureReader(q, Transaction.AUTO_COMMIT);
        }
        return this.getFeatureReader(query, Transaction.AUTO_COMMIT);
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
        if (query.getFilter() instanceof BBOX) {
            DuplicatingFilterVisitor dfv = new DuplicatingFilterVisitor();
            Filter filter = (Filter)dfv.visit((BBOX)query.getFilter(), null);
            Query q = new Query(query);
            q.setFilter(filter);
            query = q;
        }
        return this.strategy.getFeatureReader(query, transaction);
    }

    protected ReferencedEnvelope getBounds(Query query) throws IOException {
        if (query == null || query.getTypeName() == null) {
            return super.getBounds(query);
        }
        List<FeatureSetDescription> fts = this.capabilities.getFeatureTypes();
        Iterator<FeatureSetDescription> i = fts.iterator();
        String desiredType = query.getTypeName().substring(query.getTypeName().indexOf(":") + 1);
        while (i.hasNext()) {
            FeatureSetDescription fsd = i.next();
            String fsdName = fsd.getName() == null ? null : fsd.getName().substring(fsd.getName().indexOf(":") + 1);
            if (!desiredType.equals(fsdName)) continue;
            Envelope env = fsd.getLatLongBoundingBox();
            ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            try {
                return referencedEnvelope.transform(CRS.decode((String)fsd.getSRS(), (boolean)true), true);
            }
            catch (NoSuchAuthorityCodeException e) {
                return referencedEnvelope;
            }
            catch (TransformException e) {
                return referencedEnvelope;
            }
            catch (FactoryException e) {
                return referencedEnvelope;
            }
        }
        return super.getBounds(query);
    }

    protected Filter[] splitFilters(Query q, Transaction t) throws IOException {
        if (q.getFilter() == null) {
            return new Filter[]{Filter.INCLUDE, Filter.INCLUDE};
        }
        if (q.getTypeName() == null || t == null) {
            return new Filter[]{Filter.INCLUDE, q.getFilter()};
        }
        SimpleFeatureType ft = this.getSchema(q.getTypeName());
        List<FeatureSetDescription> fts = this.capabilities.getFeatureTypes();
        boolean found = false;
        for (int i = 0; i < fts.size(); ++i) {
            String fsdName;
            if (fts.get(i) == null) continue;
            FeatureSetDescription fsd = fts.get(i);
            if (ft.getTypeName().equals(fsd.getName())) {
                found = true;
                continue;
            }
            String string = fsdName = fsd.getName() == null ? null : fsd.getName().substring(fsd.getName().indexOf(":") + 1);
            if (!ft.getTypeName().equals(fsdName)) continue;
            found = true;
        }
        if (!found) {
            LOGGER.warning("Could not find typeName: " + ft.getTypeName());
            return new Filter[]{Filter.INCLUDE, q.getFilter()};
        }
        WFSTransactionState state = t == Transaction.AUTO_COMMIT ? null : (WFSTransactionState)t.getState(this);
        WFSTransactionAccessor transactionAccessor = null;
        if (state != null) {
            transactionAccessor = new WFSTransactionAccessor(state.getActions(ft.getTypeName()));
        }
        PostPreProcessFilterSplittingVisitor wfsfv = new PostPreProcessFilterSplittingVisitor(this.capabilities.getFilterCapabilities(), ft, (ClientTransactionAccessor)transactionAccessor);
        q.getFilter().accept((FilterVisitor)wfsfv, null);
        Filter[] f = new Filter[]{wfsfv.getFilterPre(), wfsfv.getFilterPost()};
        return f;
    }

    protected Filter getUnsupportedFilter(String typeName, Filter filter) {
        try {
            return this.splitFilters(new Query(typeName, filter), Transaction.AUTO_COMMIT)[1];
        }
        catch (IOException e) {
            return filter;
        }
    }

    @Override
    public WFSFeatureSource getFeatureSource(String typeName) throws IOException {
        if (this.capabilities.getTransaction() != null) {
            return new WFSFeatureStore(this, typeName);
        }
        return new WFSFeatureSource(this, typeName);
    }

    public Filter processFilter(Filter filter) {
        UpdateFidFilterVisitor visitor = new UpdateFidFilterVisitor(this.fidMap);
        return (Filter)filter.accept((FilterVisitor)visitor, null);
    }

    public synchronized void addFidMapping(String original, String finalFid) {
        if (original == null) {
            throw new NullPointerException();
        }
        this.fidMap.put(original, finalFid);
    }

    public WFSCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public SimpleFeatureSource getFeatureSource(Name typeName) throws IOException {
        return null;
    }

    @Override
    public List<Name> getNames() throws IOException {
        return null;
    }

    @Override
    public SimpleFeatureType getSchema(Name name) throws IOException {
        return null;
    }

    @Override
    public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
    }

    @Override
    public URL getDescribeFeatureTypeURL(String typeName) {
        try {
            return this.protocolHandler.getDescribeFeatureTypeURLGet(typeName);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getFeatureTypeAbstract(String typeName) {
        try {
            return this.getFeatureSource(typeName).getInfo().getDescription();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ReferencedEnvelope getFeatureTypeBounds(String typeName) {
        try {
            return this.getFeatureSource(typeName).getInfo().getBounds();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CoordinateReferenceSystem getFeatureTypeCRS(String typeName) {
        try {
            return this.getFeatureSource(typeName).getInfo().getCRS();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Set<String> getFeatureTypeKeywords(String typeName) {
        try {
            Set<String> keywords = this.getFeatureSource(typeName).getInfo().getKeywords();
            return new HashSet<String>(keywords);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getFeatureTypeTitle(String typeName) {
        try {
            return this.getFeatureSource(typeName).getInfo().getTitle();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ReferencedEnvelope getFeatureTypeWGS84Bounds(String typeName) {
        FeatureSetDescription fsd = WFSCapabilities.getFeatureSetDescription(this.capabilities, typeName);
        Envelope latLongBoundingBox = fsd.getLatLongBoundingBox();
        return new ReferencedEnvelope(latLongBoundingBox, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    @Override
    public void setMaxFeatures(Integer maxFeatures) {
    }

    @Override
    public URL getCapabilitiesURL() {
        throw new UnsupportedOperationException("Not used, this class needs to be adapted to the new architecture in the wfs.v_1_1_0 package");
    }

    @Override
    public QName getFeatureTypeName(String typeName) {
        throw new UnsupportedOperationException("Not used, this class needs to be adapted to the new architecture in the wfs.v_1_1_0 package");
    }

    @Override
    public Integer getMaxFeatures() {
        throw new UnsupportedOperationException("Not used, this class needs to be adapted to the new architecture in the wfs.v_1_1_0 package");
    }

    @Override
    public String getServiceAbstract() {
        throw new UnsupportedOperationException("Not used, this class needs to be adapted to the new architecture in the wfs.v_1_1_0 package");
    }

    @Override
    public Set<String> getServiceKeywords() {
        throw new UnsupportedOperationException("Not used, this class needs to be adapted to the new architecture in the wfs.v_1_1_0 package");
    }

    @Override
    public URI getServiceProviderUri() {
        throw new UnsupportedOperationException("Not used, this class needs to be adapted to the new architecture in the wfs.v_1_1_0 package");
    }

    @Override
    public String getServiceTitle() {
        throw new UnsupportedOperationException("Not used, this class needs to be adapted to the new architecture in the wfs.v_1_1_0 package");
    }

    @Override
    public String getServiceVersion() {
        throw new UnsupportedOperationException("Not used, this class needs to be adapted to the new architecture in the wfs.v_1_1_0 package");
    }

    @Override
    public boolean isPreferPostOverGet() {
        throw new UnsupportedOperationException("Not used, this class needs to be adapted to the new architecture in the wfs.v_1_1_0 package");
    }

    @Override
    public void setPreferPostOverGet(Boolean booleanValue) {
        throw new UnsupportedOperationException("Not used, this class needs to be adapted to the new architecture in the wfs.v_1_1_0 package");
    }

    @Override
    public void setNamespaceOverride(String namespaceOverride) {
        this.namespaceOverride = namespaceOverride;
    }

    @Override
    public void setUseDefaultSRS(Boolean useDefaultSRS) {
        throw new UnsupportedOperationException("Not used, this class needs to be adapted to the new architecture in the wfs.v_1_1_0 package");
    }

    @Override
    public void removeSchema(String typeName) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeSchema(Name typeName) throws IOException {
        throw new UnsupportedOperationException();
    }
}

