/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.main;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Logger;
import org.fao.geonet.component.csw.CatalogDispatcher;
import org.fao.geonet.kernel.setting.SettingManager;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class CswDiscoveryDispatcher
implements Service {
    private Logger logger;
    private String cswServiceSpecificContraint;

    public void init(Path appPath, ServiceConfig config) throws Exception {
        this.cswServiceSpecificContraint = config.getValue("filter");
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        Element info;
        String operation;
        this.logger = context.getLogger();
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SettingManager settingMan = (SettingManager)gc.getBean(SettingManager.class);
        boolean cswEnable = settingMan.getValueAsBool("system/csw/enable", false);
        Element response = new Element("response");
        if (params.getName().equals("request")) {
            Map<String, String> hm = CatalogDispatcher.extractParams(params);
            operation = hm.get("request");
            if (operation == null) {
                Element info2 = new Element("info").setText("No 'request' parameter found");
                response.addContent((Content)info2);
                return response;
            }
        } else if (params.getName().equals("Envelope")) {
            Element soapBody = params.getChild("Body", Namespace.getNamespace((String)"http://www.w3.org/2003/05/soap-envelope"));
            List payloadList = soapBody.getChildren();
            Element payload = (Element)payloadList.get(0);
            operation = payload.getName();
        } else {
            operation = params.getName();
        }
        if (!(operation.equals("GetCapabilities") || operation.equals("GetRecords") || operation.equals("GetRecordById") || operation.equals("DescribeRecord") || operation.equals("GetDomain"))) {
            info = new Element("info").setText("Not a CSW Discovery operation: " + operation + ". Did you mean to use the CSW Publication service? Use service name /csw-publication");
            response.addContent((Content)info);
            return response;
        }
        if (!cswEnable) {
            this.logger.info("CSW is disabled");
            info = new Element("info").setText("CSW is disabled");
            response.addContent((Content)info);
        } else {
            response = ((CatalogDispatcher)gc.getBean(CatalogDispatcher.class)).dispatch(params, context, this.cswServiceSpecificContraint);
        }
        return response;
    }
}

