/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.csw.services.getrecords;

import java.util.HashMap;
import java.util.Set;
import org.fao.geonet.kernel.csw.CatalogConfiguration;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;

public class FieldMapper {
    @Autowired
    private CatalogConfiguration _catalogConfig;

    public String map(String field) {
        return this._catalogConfig.getFieldMapping().get(this.getAbsolute(field));
    }

    public String mapXPath(String field, String schema) {
        HashMap<String, String> xpaths = this._catalogConfig.getFieldMappingXPath().get(this.getAbsolute(field));
        return xpaths != null ? xpaths.get(schema) : null;
    }

    public Iterable<String> getMappedFields() {
        return this._catalogConfig.getFieldMapping().values();
    }

    public boolean match(Element elem, Set<String> elemNames) {
        String name = elem.getQualifiedName();
        for (String field : elemNames) {
            if (!field.equals(name)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getPropertiesByType(String type) {
        return this._catalogConfig.getTypeMapping(type);
    }

    private String getAbsolute(String field) {
        if (field.startsWith("./")) {
            field = field.substring(2);
        }
        if (field.contains(":")) {
            field = field.substring(field.indexOf(58) + 1);
        }
        return field.toLowerCase();
    }
}

