/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.index;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.NRTCachingDirectory;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.search.LuceneConfig;
import org.fao.geonet.kernel.search.index.DirectoryFactory;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;

public class FSDirectoryFactory
implements DirectoryFactory {
    public static final String NON_SPATIAL_DIR = "index";
    public static final String TAXONOMY_DIR = "taxonomy";
    private static final String DELETE_DIR_FLAG_FILE = "This_directory_could_not_be_deleted_during_reindex";
    protected volatile Path taxonomyFile;
    protected volatile Path indexFile;

    public synchronized void init() throws IOException {
        GeonetworkDataDirectory dataDir = (GeonetworkDataDirectory)ApplicationContextHolder.get().getBean(GeonetworkDataDirectory.class);
        if (this.taxonomyFile == null) {
            Path luceneDir = dataDir.getLuceneDir();
            if (luceneDir == null) {
                throw new IllegalStateException("This object cannot be constructed until GeonetworkDataDirectory has been initialized");
            }
            this.indexFile = this.findLatestIndexDir(NON_SPATIAL_DIR);
            this.taxonomyFile = this.findLatestIndexDir(TAXONOMY_DIR);
        }
    }

    private Path findLatestIndexDir(String baseName) throws IOException {
        GeonetworkDataDirectory dataDir = (GeonetworkDataDirectory)ApplicationContextHolder.get().getBean(GeonetworkDataDirectory.class);
        Path indexDir = null;
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(dataDir.getLuceneDir());){
            for (Path file : paths) {
                if (!file.getFileName().toString().equals(baseName) || Files.exists(file.resolve(DELETE_DIR_FLAG_FILE), new LinkOption[0]) || indexDir != null && indexDir.getFileName().compareTo(file.getFileName()) >= 0) continue;
                indexDir = file;
            }
        }
        if (indexDir == null) {
            return dataDir.getLuceneDir().resolve(baseName);
        }
        return indexDir;
    }

    @Override
    public Directory createIndexDirectory(String indexId, LuceneConfig config) throws IOException {
        this.init();
        return this.create(this.indexFile.resolve(indexId), config);
    }

    @Override
    public Directory createTaxonomyDirectory(LuceneConfig config) throws IOException {
        this.init();
        return this.create(this.taxonomyFile, config);
    }

    @Override
    public void resetTaxonomy() throws IOException {
        this.init();
        this.cleanOldDirectoriesIfPossible();
        if (!this.cleanDirectory(this.taxonomyFile)) {
            IO.touch((Path)this.taxonomyFile.resolve(DELETE_DIR_FLAG_FILE));
        }
        this.taxonomyFile = this.createNewIndexDirectory(TAXONOMY_DIR);
    }

    @Override
    public void resetIndex() throws IOException {
        this.init();
        this.cleanOldDirectoriesIfPossible();
        if (!this.cleanDirectory(this.indexFile)) {
            IO.touch((Path)this.indexFile.resolve(DELETE_DIR_FLAG_FILE));
        }
        this.indexFile = this.createNewIndexDirectory(NON_SPATIAL_DIR);
    }

    private void cleanOldDirectoriesIfPossible() throws IOException {
        GeonetworkDataDirectory dataDir = (GeonetworkDataDirectory)ApplicationContextHolder.get().getBean(GeonetworkDataDirectory.class);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dataDir.getLuceneDir());){
            for (Path path : directoryStream) {
                Path deleteFlagFile = path.resolve(DELETE_DIR_FLAG_FILE);
                if (!Files.exists(deleteFlagFile, new LinkOption[0])) continue;
                try {
                    IO.deleteFileOrDirectory((Path)path);
                }
                catch (IOException e) {
                    Log.debug((String)"geonetwork.lucene.tracking", (Object)("Unable to delete obsolete index directory: " + path));
                    IO.touch((Path)deleteFlagFile);
                }
            }
        }
    }

    @Nonnull
    @VisibleForTesting
    protected Path createNewIndexDirectory(String baseName) throws IOException {
        GeonetworkDataDirectory dataDir = (GeonetworkDataDirectory)ApplicationContextHolder.get().getBean(GeonetworkDataDirectory.class);
        Path newFile = dataDir.getLuceneDir().resolve(baseName);
        int i = 0;
        while (Files.exists(newFile, new LinkOption[0]) || Files.exists(newFile.resolve(DELETE_DIR_FLAG_FILE), new LinkOption[0])) {
            newFile = dataDir.getLuceneDir().resolve(baseName + "_" + ++i);
        }
        return newFile;
    }

    private boolean cleanDirectory(Path root) throws IOException {
        if (!Files.exists(root, new LinkOption[0])) {
            return true;
        }
        final AtomicBoolean allReset = new AtomicBoolean(true);
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                try {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
                catch (IOException e) {
                    Log.debug((String)"geonetwork.lucene.tracking", (Object)("Unable to reset lucene index directory: " + dir));
                    return FileVisitResult.CONTINUE;
                }
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                try {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }
                catch (IOException e) {
                    Log.debug((String)"geonetwork.lucene.tracking", (Object)("Unable to reset lucene index file: " + file));
                    try (OutputStream out = Files.newOutputStream(file, new OpenOption[0]);){
                        Log.debug((String)"geonetwork.lucene.tracking", (Object)("Zero'd out " + file + " with outputstream: " + out));
                    }
                    catch (IOException e2) {
                        Log.debug((String)"geonetwork.lucene.tracking", (Object)("Unable to zero-out file because of open file: " + file));
                        allReset.set(false);
                    }
                    return FileVisitResult.TERMINATE;
                }
            }
        });
        return allReset.get();
    }

    @Override
    public Set<String> listIndices() throws IOException {
        this.init();
        LinkedHashSet<String> indices = new LinkedHashSet<String>();
        if (Files.exists(this.indexFile, new LinkOption[0])) {
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(this.indexFile);){
                for (Path file : dirStream) {
                    if (!Files.exists(file.resolve("segments.gen"), new LinkOption[0])) continue;
                    indices.add(file.getFileName().toString());
                }
            }
        }
        return indices;
    }

    private Directory create(Path file, LuceneConfig luceneConfig) throws IOException {
        Files.createDirectories(file, new FileAttribute[0]);
        FSDirectory fsDir = FSDirectory.open((File)file.toFile());
        double maxMergeSizeMD = luceneConfig.getMergeFactor();
        double maxCachedMB = luceneConfig.getRAMBufferSize();
        return new NRTCachingDirectory((Directory)fsDir, maxMergeSizeMD, maxCachedMB);
    }

    public Path getIndexDir() {
        return this.indexFile;
    }

    public Path getTaxonomyDir() {
        return this.taxonomyFile;
    }
}

