/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.domain.ServiceParam;
import org.fao.geonet.entitylistener.ServiceEntityListenerManager;

@Entity
@Access(value=AccessType.PROPERTY)
@Table(name="Services")
@EntityListeners(value={ServiceEntityListenerManager.class})
@SequenceGenerator(name="service_id_seq", initialValue=100, allocationSize=1)
public class Service
extends GeonetEntity {
    static final String ID_SEQ_NAME = "service_id_seq";
    private int _id;
    private String _name;
    private String _className;
    private String description;
    private String explicitQuery = "";
    private List<ServiceParam> _parameters = new ArrayList<ServiceParam>();

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="service_id_seq")
    public int getId() {
        return this._id;
    }

    public void setId(int id) {
        this._id = id;
    }

    @Column(nullable=false, unique=true)
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @Column(name="class", length=1024, nullable=false)
    public String getClassName() {
        return this._className;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    @Column(length=1024)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="service", orphanRemoval=true)
    public List<ServiceParam> getParameters() {
        return this._parameters;
    }

    public void setParameters(List<ServiceParam> parameters) {
        this._parameters = parameters;
    }

    public Service addParameter(ServiceParam param) {
        if (this._parameters == null) {
            this._parameters = Lists.newArrayList();
        }
        param.setService(this);
        this._parameters.add(param);
        return this;
    }

    public boolean removeParameter(ServiceParam param) {
        if (this._parameters == null) {
            return false;
        }
        param.setService(null);
        return this._parameters.remove(param);
    }

    public void clearParameters() {
        for (ServiceParam parameter : this._parameters) {
            parameter.setService(null);
        }
        this._parameters.clear();
    }

    @Nonnull
    public String getExplicitQuery() {
        return this.explicitQuery == null ? "" : this.explicitQuery;
    }

    public void setExplicitQuery(String explicitQuery) {
        this.explicitQuery = explicitQuery;
    }
}

