/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.model.factory;

import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.model.factory.GroovyModelParser;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.AbstractWroModelFactory;
import ro.isdc.wro.util.StopWatch;

public class GroovyModelFactory
extends AbstractWroModelFactory {
    private static final Logger LOG = LoggerFactory.getLogger(GroovyModelFactory.class);
    private static final String DEFAULT_FILE_NAME = "wro.groovy";
    public static final String ALIAS = "groovy";

    public WroModel create() {
        StopWatch stopWatch = new StopWatch("Create Wro Model from Groovy");
        try {
            stopWatch.start("parseStream");
            Script script = new GroovyShell().parse((Reader)new InputStreamReader((InputStream)new AutoCloseInputStream(this.getModelResourceAsStream())));
            LOG.debug("Parsing groovy script to build the model");
            stopWatch.stop();
            stopWatch.start("parseScript");
            WroModel model = GroovyModelParser.parse(script);
            stopWatch.stop();
            LOG.debug("groovy model: {}", (Object)model);
            if (model == null) {
                throw new WroRuntimeException("Invalid content provided, cannot build model!");
            }
            WroModel wroModel = model;
            return wroModel;
        }
        catch (IOException e) {
            throw new WroRuntimeException("Invalid model found!", (Throwable)e);
        }
        finally {
            LOG.debug(stopWatch.prettyPrint());
        }
    }

    protected String getDefaultModelFilename() {
        return DEFAULT_FILE_NAME;
    }
}

