/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.remote;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNCommitPathHandler;
import org.tmatesoft.svn.core.internal.wc.SVNCommitUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc2.SvnRemoteOperationRunner;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc2.SvnCommitItem;
import org.tmatesoft.svn.core.wc2.SvnRemoteDelete;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnRemoteRemoteDelete
extends SvnRemoteOperationRunner<SVNCommitInfo, SvnRemoteDelete> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SVNCommitInfo run() throws SVNException {
        if (((SvnRemoteDelete)this.getOperation()).getTargets().size() == 0) {
            return SVNCommitInfo.NULL;
        }
        SVNHashMap reposInfo = new SVNHashMap();
        SVNHashMap relPathInfo = new SVNHashMap();
        try {
            SVNRepository repository;
            for (SvnTarget target : ((SvnRemoteDelete)this.getOperation()).getTargets()) {
                SVNNodeKind kind;
                SVNErrorMessage err;
                ArrayList<String> relPaths;
                SVNURL url = target.getURL();
                repository = null;
                SVNURL reposRoot2 = null;
                String reposRelPath = null;
                for (SVNURL reposRoot2 : reposInfo.keySet()) {
                    reposRelPath = SVNWCUtils.isChild(reposRoot2, url);
                    if (reposRelPath == null) continue;
                    repository = (SVNRepository)reposInfo.get(reposRoot2);
                    relPaths = (ArrayList<String>)relPathInfo.get(reposRoot2);
                    relPaths.add(reposRelPath);
                    break;
                }
                if (repository == null) {
                    repository = this.getRepositoryAccess().createRepository(url, null, false);
                    reposRoot2 = repository.getRepositoryRoot(true);
                    repository.setLocation(reposRoot2, false);
                    reposInfo.put(reposRoot2, repository);
                    reposRelPath = SVNWCUtils.isChild(reposRoot2, url);
                    relPaths = new ArrayList<String>();
                    relPathInfo.put(reposRoot2, relPaths);
                    relPaths.add(reposRelPath);
                }
                if (reposRelPath == null) {
                    err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' not within a repository", (Object)url);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                if ((kind = repository.checkPath(reposRelPath, -1L)) != SVNNodeKind.NONE) continue;
                err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "URL ''{0}'' does not exist", (Object)url);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            SVNPropertiesManager.validateRevisionProperties(((SvnRemoteDelete)this.getOperation()).getRevisionProperties());
            SVNCommitInfo info = null;
            for (SVNURL reposRoot : reposInfo.keySet()) {
                List paths;
                repository = (SVNRepository)reposInfo.get(reposRoot);
                info = this.singleRepositoryDelete(repository, reposRoot, paths = (List)relPathInfo.get(reposRoot));
                if (info == null) continue;
                ((SvnRemoteDelete)this.getOperation()).receive(SvnTarget.fromURL(reposRoot), info);
            }
            SVNCommitInfo sVNCommitInfo = info != null ? info : SVNCommitInfo.NULL;
            return sVNCommitInfo;
        }
        finally {
            for (Object entry : reposInfo.entrySet()) {
                SVNRepository svnRepository = (SVNRepository)((Map.Entry)entry).getValue();
                if (svnRepository == null) continue;
                svnRepository.closeSession();
            }
        }
    }

    private SVNCommitInfo singleRepositoryDelete(SVNRepository repository, SVNURL rootURL, List<String> paths) throws SVNException {
        SVNCommitInfo info;
        String commitMessage;
        if (paths.isEmpty()) {
            paths.add(SVNPathUtil.tail(rootURL.getURIEncodedPath()));
            rootURL = rootURL.removePathTail();
        }
        if (((SvnRemoteDelete)this.getOperation()).getCommitHandler() != null) {
            SvnCommitItem[] commitItems = new SvnCommitItem[paths.size()];
            for (int i = 0; i < commitItems.length; ++i) {
                String path = paths.get(i);
                SvnCommitItem item = new SvnCommitItem();
                item.setKind(SVNNodeKind.NONE);
                item.setUrl(rootURL.appendPath(path, true));
                item.setFlags(2);
                commitItems[i] = item;
            }
            commitMessage = ((SvnRemoteDelete)this.getOperation()).getCommitHandler().getCommitMessage(((SvnRemoteDelete)this.getOperation()).getCommitMessage(), commitItems);
            if (commitMessage == null) {
                return SVNCommitInfo.NULL;
            }
        } else {
            commitMessage = ((SvnRemoteDelete)this.getOperation()).getCommitMessage();
        }
        commitMessage = commitMessage == null ? "" : SVNCommitUtil.validateCommitMessage(commitMessage);
        String[] pathsArray = new String[paths.size()];
        paths.toArray(pathsArray);
        ArrayList<String> condencedPaths = new ArrayList<String>();
        String commonParentPath = SVNPathUtil.condencePaths(pathsArray, condencedPaths, false);
        if (condencedPaths.isEmpty()) {
            condencedPaths.add(SVNPathUtil.tail(commonParentPath));
            commonParentPath = SVNPathUtil.removeTail(commonParentPath);
        }
        repository.setLocation(rootURL.appendPath(commonParentPath, false), false);
        ISVNEditor commitEditor = repository.getCommitEditor(commitMessage, null, false, ((SvnRemoteDelete)this.getOperation()).getRevisionProperties(), null);
        ISVNCommitPathHandler deleter = new ISVNCommitPathHandler(){

            public boolean handleCommitPath(String commitPath, ISVNEditor commitEditor) throws SVNException {
                commitEditor.deleteEntry(commitPath, -1L);
                return false;
            }
        };
        try {
            SVNCommitUtil.driveCommitEditor(deleter, condencedPaths, commitEditor, -1L);
            info = commitEditor.closeEdit();
        }
        catch (SVNException e) {
            try {
                commitEditor.abortEdit();
            }
            catch (SVNException inner) {
                // empty catch block
            }
            throw e;
        }
        if (info != null && info.getNewRevision() >= 0L) {
            this.handleEvent(SVNEventFactory.createSVNEvent(null, SVNNodeKind.NONE, null, info.getNewRevision(), SVNEventAction.COMMIT_COMPLETED, null, null, null), -1.0);
        }
        return info != null ? info : SVNCommitInfo.NULL;
    }
}

