/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibUtils;
import com.sun.media.jai.util.ImageUtil;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;

final class MlibAddConstOpImage
extends PointOpImage {
    private double[] constants;

    public MlibAddConstOpImage(RenderedImage source, Map config, ImageLayout layout, double[] constants) {
        super(source, layout, config, true);
        this.constants = MlibUtils.initConstants(constants, this.getSampleModel().getNumBands());
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        Raster source = sources[0];
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        int formatTag = MediaLibAccessor.findCompatibleTag(sources, dest);
        MediaLibAccessor srcAccessor = new MediaLibAccessor(source, srcRect, formatTag);
        MediaLibAccessor dstAccessor = new MediaLibAccessor(dest, destRect, formatTag);
        mediaLibImage[] srcML = srcAccessor.getMediaLibImages();
        mediaLibImage[] dstML = dstAccessor.getMediaLibImages();
        switch (dstAccessor.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int i;
                int[] constInt = new int[this.constants.length];
                for (i = 0; i < this.constants.length; ++i) {
                    constInt[i] = ImageUtil.clampRoundInt(this.constants[i]);
                }
                for (i = 0; i < dstML.length; ++i) {
                    int[] mlconstants = dstAccessor.getIntParameters(i, constInt);
                    Image.ConstAdd((mediaLibImage)dstML[i], (mediaLibImage)srcML[i], (int[])mlconstants);
                }
                break;
            }
            case 4: 
            case 5: {
                for (int i = 0; i < dstML.length; ++i) {
                    double[] mlconstants = dstAccessor.getDoubleParameters(i, this.constants);
                    Image.ConstAdd_Fp((mediaLibImage)dstML[i], (mediaLibImage)srcML[i], (double[])mlconstants);
                }
                break;
            }
            default: {
                String className = this.getClass().getName();
                throw new RuntimeException(className + JaiI18N.getString("Generic2"));
            }
        }
        if (dstAccessor.isDataCopy()) {
            dstAccessor.clampDataArrays();
            dstAccessor.copyDataToRaster();
        }
    }
}

