/*
 * Decompiled with CFR 0.152.
 */
package org.geonetwork.http;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import org.apache.commons.lang.StringUtils;

public class SessionTimeoutCookieFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse httpResp = (HttpServletResponse)resp;
        HttpServletRequest httpReq = (HttpServletRequest)req;
        HttpSession session = httpReq.getSession(false);
        if (session != null) {
            Object tmp;
            long currTime = System.currentTimeMillis();
            Cookie cookie = new Cookie("serverTime", "" + currTime);
            cookie.setPath("/");
            cookie.setSecure(req.getServletContext().getSessionCookieConfig().isSecure());
            httpResp.addCookie(cookie);
            UserSession userSession = null;
            if (session != null && (tmp = session.getAttribute("session")) instanceof UserSession) {
                userSession = (UserSession)tmp;
            }
            if (userSession != null && StringUtils.isNotEmpty((String)userSession.getName())) {
                long expiryTime = currTime + (long)(session.getMaxInactiveInterval() * 1000);
                cookie = new Cookie("sessionExpiry", "" + expiryTime);
            } else {
                cookie = new Cookie("sessionExpiry", "" + currTime);
            }
            cookie.setPath("/");
            cookie.setSecure(req.getServletContext().getSessionCookieConfig().isSecure());
            httpResp.addCookie(cookie);
        }
        filterChain.doFilter(req, resp);
    }

    public void destroy() {
    }
}

