/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import io.searchbox.action.Action;
import io.searchbox.client.JestResult;
import io.searchbox.core.Get;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jeeves.server.ServiceConfig;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.Source;
import org.fao.geonet.es.EsClient;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SelectionManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.search.ISearchManager;
import org.fao.geonet.kernel.search.MetaSearcher;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;

public class EsSearchManager
implements ISearchManager {
    public static final String ID = "id";
    public static final String DOC_TYPE = "docType";
    public static final String SCHEMA_INDEX_XSLT_FOLDER = "index-fields";
    public static final String SCHEMA_INDEX_XSTL_FILENAME = "index.xsl";
    public static final String FIELDNAME = "name";
    public static final String FIELDSTRING = "string";
    @Value(value="${es.index.records:gn-records}")
    private String index = "records";
    @Value(value="${es.index.records_public:gn-records-public}")
    private String publicIndex = "records";
    @Value(value="${es.index.records.type:records}")
    private String indexType = "records";
    @Autowired
    private EsClient client;
    private int commitInterval = 200;
    private Map<String, String> listOfDocumentsToIndex = new HashMap<String, String>();
    private Map<String, String> listOfPublicDocumentsToIndex = new HashMap<String, String>();
    @Autowired
    SourceRepository sourceRepository;
    private static ImmutableSet<String> booleanFields = ImmutableSet.builder().add((Object)"hasxlinks").add((Object)"hasInspireTheme").add((Object)"hasOverview").add((Object)"has_atom").add((Object)"_hasxlinks").add((Object)"isHarvested").add((Object)"isPublishedToAll").add((Object)"isTemplate").add((Object)"isValid").add((Object)"isSchemaValid").add((Object)"isAboveThreshold").add((Object)"isOpenData").build();
    private static ImmutableSet<String> booleanValues = ImmutableSet.builder().add((Object)"1").add((Object)"y").add((Object)"true").build();

    public String getIndex() {
        return this.index;
    }

    public String getPublicIndex() {
        return this.publicIndex;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }

    public static Path getXSLTForIndexing(Path schemaDir) {
        Path xsltForIndexing = schemaDir.resolve(SCHEMA_INDEX_XSLT_FOLDER).resolve(SCHEMA_INDEX_XSTL_FILENAME);
        if (!Files.exists(xsltForIndexing, new LinkOption[0])) {
            throw new RuntimeException(String.format("XSLT for schema indexing does not exist. Create file '%s'.", xsltForIndexing.toString()));
        }
        return xsltForIndexing;
    }

    private static void addMDFields(Element doc, Path schemaDir, Element metadata, String root) {
        Path styleSheet = EsSearchManager.getXSLTForIndexing(schemaDir);
        try {
            Element fields = Xml.transform((Element)metadata, (Path)styleSheet);
            for (Element field : fields.getChildren()) {
                doc.addContent((Content)((Element)field.clone()));
            }
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.index", (Object)String.format("Indexing stylesheet contains errors: %s \n\t Marking the metadata as _indexingError=1 in index", e.getMessage()));
            doc.addContent((Content)new Element("_indexingError").setText("1"));
            doc.addContent((Content)new Element("_indexingErrorMsg").setText("GNIDX-XSL||" + e.getMessage()));
            StringBuilder sb = new StringBuilder();
            EsSearchManager.allText(metadata, sb);
            doc.addContent((Content)new Element("_text_").setText(sb.toString()));
        }
    }

    private static void allText(Element metadata, StringBuilder sb) {
        String text = metadata.getText().trim();
        if (text.length() > 0) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(text);
        }
        List children = metadata.getChildren();
        for (Element aChildren : children) {
            EsSearchManager.allText(aChildren, sb);
        }
    }

    private static void addMoreFields(Element doc, List<Element> fields) {
        for (Element field : fields) {
            doc.addContent((Content)new Element(field.getAttributeValue(FIELDNAME)).setText(field.getAttributeValue(FIELDSTRING)));
        }
    }

    public static Integer convertInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.valueOf(value.toString());
    }

    public static Element makeField(String name, String value) {
        Element field = new Element("Field");
        field.setAttribute(FIELDNAME, name);
        field.setAttribute(FIELDSTRING, value == null ? "" : value);
        return field;
    }

    public static void addField(Element xmlDoc, String name, String value, boolean store, boolean index) {
        Element field = EsSearchManager.makeField(name, value);
        xmlDoc.addContent((Content)field);
    }

    @Override
    public void init(ServiceConfig handlerConfig) throws Exception {
    }

    @Override
    public void end() throws Exception {
    }

    @Override
    public MetaSearcher newSearcher(String stylesheetName) throws Exception {
        return null;
    }

    @Override
    public void index(Path schemaDir, Element metadata, String id, List<Element> moreFields, MetadataType metadataType, String root, boolean forceRefreshReaders) throws Exception {
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        Element docs = new Element("docs");
        Element allFields = new Element("doc");
        allFields.addContent((Content)new Element(ID).setText(id));
        allFields.addContent((Content)new Element(DOC_TYPE).setText("metadata"));
        EsSearchManager.addMDFields(allFields, schemaDir, metadata, root);
        EsSearchManager.addMoreFields(allFields, moreFields);
        docs.addContent((Content)allFields);
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode doc = this.documentToJson(docs).get(id);
        String catalog = doc.get("source").asText();
        doc.remove("source");
        if (StringUtils.isNotEmpty((String)catalog)) {
            doc.put("sourceCatalogue", catalog);
            Source source = (Source)this.sourceRepository.findOne((Serializable)((Object)catalog));
            if (source != null) {
                source.getLabelTranslations().forEach((key, value) -> doc.put("sourceCatalogueName_lang" + key, value));
            }
        }
        doc.put("scope", settingManager.getSiteName());
        doc.put("harvesterUuid", settingManager.getSiteId());
        doc.put("harvesterId", settingManager.getNodeURL());
        String json = mapper.writeValueAsString((Object)doc);
        if (doc.get("isPublishedToAll").asBoolean()) {
            this.listOfPublicDocumentsToIndex.put(id, json);
        }
        this.listOfDocumentsToIndex.put(id, json);
        if (this.listOfDocumentsToIndex.size() == this.commitInterval) {
            this.sendDocumentsToIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDocumentsToIndex() throws IOException {
        EsSearchManager esSearchManager = this;
        synchronized (esSearchManager) {
            if (this.listOfDocumentsToIndex.size() > 0) {
                this.client.bulkRequest(this.index, this.listOfDocumentsToIndex);
                if (StringUtils.isNotEmpty((String)this.publicIndex)) {
                    this.client.bulkRequest(this.publicIndex, this.listOfPublicDocumentsToIndex);
                    this.listOfPublicDocumentsToIndex.clear();
                }
                this.listOfDocumentsToIndex.clear();
            }
        }
    }

    public Map<String, ObjectNode> documentToJson(Element xml) {
        ObjectMapper mapper = new ObjectMapper();
        List records = xml.getChildren("doc");
        HashMap<String, ObjectNode> listOfXcb = new HashMap<String, ObjectNode>();
        for (int i = 0; i < records.size(); ++i) {
            Element record = (Element)records.get(i);
            if (record == null || !(record instanceof Element)) continue;
            ObjectNode doc = mapper.createObjectNode();
            String id = null;
            ArrayList<String> elementNames = new ArrayList<String>();
            List fields = record.getChildren();
            for (int j = 0; j < fields.size(); ++j) {
                Element currentField = (Element)fields.get(j);
                String name = currentField.getName();
                if (elementNames.contains(name)) continue;
                elementNames.add(name);
                boolean isObject = "object".equals(currentField.getAttributeValue("type"));
                List nodeElements = record.getChildren(name);
                boolean isArray = nodeElements.size() > 1;
                String propertyName = name.startsWith("_") ? name.substring(1) : name;
                ArrayNode arrayNode = null;
                if (isArray) {
                    arrayNode = doc.putArray(propertyName);
                }
                for (int k = 0; k < nodeElements.size(); ++k) {
                    Element node = (Element)nodeElements.get(k);
                    if (name.equals(ID)) {
                        id = node.getTextNormalize();
                    }
                    if (name.equals("geom")) continue;
                    if (isArray) {
                        if (isObject) {
                            try {
                                arrayNode.add(mapper.readTree(node.getTextNormalize()));
                            }
                            catch (IOException e) {
                                Log.error((String)"geonetwork.index", (Object)e.getMessage(), (Throwable)e);
                            }
                            continue;
                        }
                        arrayNode.add(booleanFields.contains((Object)propertyName) ? this.parseBoolean(node.getTextNormalize()) : node.getTextNormalize());
                        continue;
                    }
                    if (name.equals("geojson")) {
                        doc.put("geom", node.getTextNormalize());
                        continue;
                    }
                    if (name.startsWith("conformTo_")) continue;
                    if (isObject) {
                        try {
                            doc.set(propertyName, mapper.readTree(((Element)nodeElements.get(0)).getTextNormalize()));
                        }
                        catch (IOException e) {
                            Log.error((String)"geonetwork.index", (Object)e.getMessage(), (Throwable)e);
                        }
                        continue;
                    }
                    doc.put(propertyName, booleanFields.contains((Object)propertyName) ? this.parseBoolean(node.getTextNormalize()) : node.getTextNormalize());
                }
            }
            listOfXcb.put(id, doc);
        }
        return listOfXcb;
    }

    private String parseBoolean(String value) {
        return String.valueOf(booleanValues.contains((Object)value));
    }

    @Override
    public void forceIndexChanges() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rebuildIndex(ServiceContext context, boolean xlinks, boolean reset, String bucket) throws Exception {
        DataManager dataMan = context.getBean(DataManager.class);
        IMetadataUtils metadataRepository = context.getBean(IMetadataUtils.class);
        if (reset) {
            this.clearIndex();
        }
        if (StringUtils.isNotBlank((String)bucket)) {
            ArrayList<String> listOfIdsToIndex = new ArrayList<String>();
            UserSession session = context.getUserSession();
            SelectionManager sm = SelectionManager.getManager(session);
            Set<String> set = sm.getSelection(bucket);
            synchronized (set) {
                for (String uuid : sm.getSelection(bucket)) {
                    for (AbstractMetadata abstractMetadata : metadataRepository.findAllByUuid(uuid)) {
                        listOfIdsToIndex.add(abstractMetadata.getId() + "");
                    }
                    if (metadataRepository.existsMetadataUuid(uuid)) continue;
                    Log.warning((String)"geonetwork.index", (Object)String.format("Selection contains uuid '%s' not found in database", uuid));
                }
            }
            for (String id : listOfIdsToIndex) {
                dataMan.indexMetadata(id + "", false, this);
            }
            this.sendDocumentsToIndex();
        } else {
            Specifications metadataSpec = Specifications.where((Specification)MetadataSpecs.isType((MetadataType)MetadataType.METADATA)).or(MetadataSpecs.isType((MetadataType)MetadataType.TEMPLATE));
            List<Integer> metadataIds = metadataRepository.findAllIdsBy((Specification<? extends AbstractMetadata>)Specifications.where((Specification)metadataSpec));
            for (Integer id : metadataIds) {
                dataMan.indexMetadata(id + "", false, this);
            }
            this.sendDocumentsToIndex();
        }
        return true;
    }

    public void clearIndex() throws Exception {
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        this.client.deleteByQuery(this.index, "harvesterUuid:\\\"" + settingManager.getSiteId() + "\\\"");
        if (StringUtils.isNotEmpty((String)this.publicIndex)) {
            this.client.deleteByQuery(this.publicIndex, "harvesterUuid:\\\"" + settingManager.getSiteId() + "\\\"");
        }
    }

    @Override
    public Map<String, String> getDocsChangeDate() throws Exception {
        String query = "{\"query\": {\"filtered\": {\"query_string\": \"*:*\"}}}";
        Search search = ((Search.Builder)((Search.Builder)new Search.Builder(query).addIndex(this.index)).addType(this.indexType)).build();
        SearchResult searchResult = (SearchResult)this.client.getClient().execute((Action)search);
        return null;
    }

    @Override
    public ISODate getDocChangeDate(String mdId) throws Exception {
        Get get = ((Get.Builder)new Get.Builder(this.index, mdId).type(this.index)).build();
        JestResult result = this.client.getClient().execute((Action)get);
        if (result != null) {
            JsonElement date = result.getJsonObject().get("_changeDate");
            return date != null ? new ISODate(date.getAsString()) : null;
        }
        return null;
    }

    @Override
    public Set<Integer> getDocsWithXLinks() throws Exception {
        return null;
    }

    @Override
    public void delete(String txt) throws Exception {
        this.client.deleteByQuery(this.index, txt);
    }

    @Override
    public void delete(List<String> txts) throws Exception {
    }

    @Override
    public void rescheduleOptimizer(Calendar beginAt, int interval) {
    }

    @Override
    public void disableOptimizer() {
    }

    public Long getNumDocs(String query) throws Exception {
        if (StringUtils.isBlank((String)query)) {
            query = "*:*";
        }
        String searchQuery = "{\"query\": {\"filtered\": {\"query_string\": \"" + query + "\"}}}";
        Search search = ((Search.Builder)((Search.Builder)new Search.Builder(searchQuery).addIndex(this.index)).addType(this.indexType)).build();
        SearchResult searchResult = (SearchResult)this.client.getClient().execute((Action)search);
        return searchResult.getTotal();
    }

    public EsClient getClient() {
        return this.client;
    }

    void setClient(EsClient client) {
        this.client = client;
    }

    public List<Element> getDocs(String query, Integer start, Long rows) throws IOException, JDOMException {
        List<String> result = this.getDocIds(query, start, rows);
        ArrayList<Element> xmlDocs = new ArrayList<Element>(result.size());
        IMetadataUtils metadataRepository = (IMetadataUtils)ApplicationContextHolder.get().getBean(IMetadataUtils.class);
        for (String id : result) {
            AbstractMetadata metadata = metadataRepository.findOne(id);
            xmlDocs.add(metadata.getXmlData(false));
        }
        return xmlDocs;
    }

    public List<String> getDocIds(String query, Integer start, Long rows) throws IOException, JDOMException {
        return null;
    }

    public List<Element> getAllDocs(String query) throws Exception {
        Long hitsNumber = this.getNumDocs(query);
        return this.getDocs(query, 0, hitsNumber);
    }

    public List<String> getAllDocIds(String query) throws Exception {
        Long hitsNumber = this.getNumDocs(query);
        return this.getDocIds(query, 0, hitsNumber);
    }

    public static String analyzeField(String analyzer, String fieldValue) {
        return EsClient.analyzeField((String)((EsSearchManager)ApplicationContextHolder.get().getBean(EsSearchManager.class)).getIndex(), (String)analyzer, (String)fieldValue);
    }
}

