/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.datamanager.draft;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.domain.MetadataSourceInfo;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.base.BaseMetadataManager;
import org.fao.geonet.notifier.MetadataNotifierManager;
import org.fao.geonet.repository.MetadataDraftRepository;
import org.fao.geonet.repository.PathSpec;
import org.fao.geonet.repository.Updater;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;

public class DraftMetadataManager
extends BaseMetadataManager
implements IMetadataManager {
    @Autowired
    private MetadataDraftRepository metadataDraftRepository;

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    public void init(ServiceContext context, Boolean force) throws Exception {
        this.metadataDraftRepository = context.getBean(MetadataDraftRepository.class);
        super.init(context, force);
    }

    @Override
    public void deleteMetadata(ServiceContext context, String metadataId) throws Exception {
        AbstractMetadata findOne = this.metadataUtils.findOne(metadataId);
        if (findOne != null) {
            long countDraft;
            boolean isMetadata;
            boolean bl = isMetadata = findOne.getDataInfo().getType() == MetadataType.METADATA;
            if (findOne instanceof Metadata && (countDraft = this.metadataDraftRepository.count(MetadataSpecs.hasMetadataUuid((String)findOne.getUuid()))) > 0L) {
                throw new Exception("The metadata " + findOne.getUuid() + " has a draft version. Cancel the modification to be able to remove the approved version.");
            }
            this.deleteMetadataFromDB(context, metadataId);
            if (isMetadata) {
                context.getBean(MetadataNotifierManager.class).deleteMetadata(metadataId, findOne.getUuid(), context);
            }
        }
        this.getSearchManager().delete(metadataId + "");
    }

    @Override
    public synchronized void updateMetadataOwner(int id, final String owner, final String groupOwner) throws Exception {
        if (this.metadataDraftRepository.exists((Serializable)Integer.valueOf(id))) {
            this.metadataDraftRepository.update((Serializable)Integer.valueOf(id), (Updater)new Updater<MetadataDraft>(){

                public void apply(@Nonnull MetadataDraft entity) {
                    entity.getSourceInfo().setGroupOwner(Integer.valueOf(groupOwner));
                    entity.getSourceInfo().setOwner(Integer.valueOf(owner));
                }
            });
        } else {
            super.updateMetadataOwner(id, owner, groupOwner);
        }
    }

    @Override
    public AbstractMetadata save(AbstractMetadata info) {
        if (info instanceof Metadata) {
            return super.save((AbstractMetadata)((Metadata)info));
        }
        if (info instanceof MetadataDraft) {
            return (AbstractMetadata)this.metadataDraftRepository.save((Object)((MetadataDraft)info));
        }
        throw new ClassCastException("Unknown AbstractMetadata subtype: " + info.getClass().getName());
    }

    @Override
    public AbstractMetadata update(int id, @Nonnull Updater<? extends AbstractMetadata> updater) {
        AbstractMetadata md = null;
        Log.trace((String)"geonetwork.datamanager", (Object)("AbstractMetadata.update(" + id + ")"));
        if (this.metadataDraftRepository.exists((Serializable)Integer.valueOf(id))) {
            try {
                Log.trace((String)"geonetwork.datamanager", (Object)"Updating draft table.");
                md = (AbstractMetadata)this.metadataDraftRepository.update((Serializable)Integer.valueOf(id), updater);
            }
            catch (ClassCastException t) {
                throw new ClassCastException("Unknown AbstractMetadata subtype: " + updater.getClass().getName());
            }
        } else {
            md = super.update(id, updater);
        }
        return md;
    }

    @Override
    public void deleteAll(Specification<? extends AbstractMetadata> specs) {
        try {
            super.deleteAll(specs);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            this.metadataDraftRepository.deleteAll(specs);
        }
        catch (ClassCastException t) {
            throw new ClassCastException("Unknown AbstractMetadata subtype: " + specs.getClass().getName());
        }
    }

    @Override
    public void delete(Integer id) {
        super.delete(id);
        if (this.metadataDraftRepository.exists((Serializable)id)) {
            this.metadataDraftRepository.delete((Serializable)id);
        }
    }

    @Override
    public void createBatchUpdateQuery(PathSpec<? extends AbstractMetadata, String> servicesPath, String newUuid, Specification<? extends AbstractMetadata> harvested) {
        try {
            super.createBatchUpdateQuery(servicesPath, newUuid, harvested);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            this.metadataDraftRepository.createBatchUpdateQuery(servicesPath, (Object)newUuid, harvested);
        }
        catch (ClassCastException t) {
            throw new ClassCastException("Unknown AbstractMetadata subtype: " + servicesPath.getClass().getName());
        }
    }

    @Override
    public Map<Integer, MetadataSourceInfo> findAllSourceInfo(Specification<? extends AbstractMetadata> specs) {
        HashMap<Integer, MetadataSourceInfo> res = new HashMap<Integer, MetadataSourceInfo>();
        try {
            res.putAll(super.findAllSourceInfo(specs));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            res.putAll(this.metadataDraftRepository.findAllSourceInfo(specs));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return res;
    }
}

