/*
 * Decompiled with CFR 0.152.
 */
package jeeves.server.overrides;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jeeves.server.overrides.PropertyUpdater;
import org.apache.commons.beanutils.PropertyUtils;
import org.fao.geonet.utils.Log;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedProperties;
import org.springframework.beans.factory.support.ManagedSet;

class AddPropertyUpdater
extends PropertyUpdater {
    AddPropertyUpdater() {
    }

    @Override
    protected void doUpdate(ConfigurableListableBeanFactory beanFactory, BeanDefinition bean, Object value) {
        Object originalValue;
        Log.debug((String)"jeeves", (Object)("Adding new value " + value + " to property: " + this.propertyName + " on " + this.beanName));
        PropertyValue propertyValue = bean.getPropertyValues().getPropertyValue(this.propertyName);
        if (propertyValue == null) {
            String beanClassName = bean.getBeanClassName();
            try {
                PropertyDescriptor[] propertyDescriptors;
                Class<?> aClass = Class.forName(beanClassName);
                for (PropertyDescriptor descriptor : propertyDescriptors = PropertyUtils.getPropertyDescriptors(aClass)) {
                    if (!this.propertyName.equals(descriptor.getName())) continue;
                    Class<?> collectionType = descriptor.getWriteMethod().getParameterTypes()[0];
                    if (List.class.isAssignableFrom(collectionType)) {
                        propertyValue = new PropertyValue(this.propertyName, (Object)new ManagedList());
                        break;
                    }
                    if (Set.class.isAssignableFrom(collectionType)) {
                        propertyValue = new PropertyValue(this.propertyName, (Object)new ManagedSet());
                        break;
                    }
                    if (Map.class.isAssignableFrom(collectionType)) {
                        propertyValue = new PropertyValue(this.propertyName, (Object)new ManagedMap());
                        break;
                    }
                    if (Properties.class.isAssignableFrom(collectionType)) {
                        propertyValue = new PropertyValue(this.propertyName, (Object)new ManagedProperties());
                        break;
                    }
                    if (Array.class.isAssignableFrom(collectionType)) {
                        throw new IllegalArgumentException("Array collections not currently supported");
                    }
                    if (Collection.class.isAssignableFrom(collectionType)) {
                        propertyValue = new PropertyValue(this.propertyName, (Object)new ManagedList());
                        break;
                    }
                    throw new IllegalArgumentException(collectionType + " is not a supported type for adding new values");
                }
                if (propertyValue == null) {
                    throw new IllegalArgumentException("Unable to find the collection type for property: " + this.propertyName + " on bean " + this.beanName);
                }
                bean.getPropertyValues().addPropertyValue(propertyValue);
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }
        if (!((originalValue = propertyValue.getValue()) instanceof Collection)) {
            throw new IllegalArgumentException(originalValue + " is not a collection as expected");
        }
        Collection coll = (Collection)originalValue;
        coll.add(value);
    }
}

