/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fao.geonet.Constants;
import org.fao.geonet.utils.IO;

public class ConfigFile {
    private static final String CONFIG_PROPERTIES_FILENAME = "config.properties";
    private static final String FIXED_LANG_CONFIG_PROP = "fixedLang";
    private static final String LOAD_STRINGS_PROP = "loadGeonetworkStrings";
    private static final String SCHEMAS_TO_LOAD_PROP = "schemasToLoad";
    private static final String APPLICABLE_SCHEMAS = "applicableSchemas";
    private static final String DEPENDS_ON = "dependsOn";
    private static final String PUBLISHED = "published";
    private Properties config = new Properties();

    public ConfigFile(Path bundleDir, boolean searchParentDir, Path schemaDir) throws IOException {
        ArrayList<Path> properties = new ArrayList<Path>();
        if (searchParentDir) {
            if (schemaDir == null) {
                properties.add(bundleDir.getParent().resolve(CONFIG_PROPERTIES_FILENAME));
                properties.add(bundleDir.resolve(CONFIG_PROPERTIES_FILENAME));
            } else {
                Path current = bundleDir;
                while (current.getParent() != null && !schemaDir.equals(current) && Files.exists(current.getParent(), new LinkOption[0])) {
                    properties.add(current.resolve(CONFIG_PROPERTIES_FILENAME));
                    current = current.getParent();
                }
                properties.add(schemaDir.resolve(CONFIG_PROPERTIES_FILENAME));
            }
        } else {
            properties.add(bundleDir.resolve(CONFIG_PROPERTIES_FILENAME));
        }
        Collections.reverse(properties);
        for (Path file : properties) {
            if (!Files.exists(file, new LinkOption[0])) continue;
            BufferedReader reader = IO.newBufferedReader((Path)file, (Charset)Constants.CHARSET);
            Throwable throwable = null;
            try {
                this.config.load(reader);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((Reader)reader).close();
            }
        }
    }

    public static void generateDefault(Path bundleDir) throws IOException {
        Path configFile = bundleDir.resolve(CONFIG_PROPERTIES_FILENAME);
        if (!Files.exists(configFile, new LinkOption[0])) {
            try (PrintStream out = new PrintStream(Files.newOutputStream(configFile, new OpenOption[0]), true, Constants.ENCODING);){
                out.println("# Generated as part of download");
                out.println("# This file is an example of a metadata formatter configuration file");
                out.println("# Uncomment lines of interest");
                out.println("");
                out.println("# fixedLang sets the language of the strings to the fixed language, this ensures that the formatter will always use the same language for its labels, strings, etc... no matter what language code is in the url.");
                out.println("#fixedLang=eng");
                out.println("# loadGeonetworkStrings - if true or non-existent then geonetwork strings will be added to the xml document before view.xsl is applied.  The default is true so if this parameter is not present then the strings will be loaded");
                out.println("loadGeonetworkStrings=true");
                out.println("");
                out.println("# applicableSchemas - defines which metadata schemas this bundle applies to.  ");
                out.println("# For example one can specify only iso19139 or a comma separated list of schemas (or all)");
                out.println("# applicableSchemas=iso19115,fgdc-std,iso19139,csw-record,iso19110");
                out.println("applicableSchemas=all");
                out.println("");
                out.println("# dependsOn - defines which schema plugin's formatter folder is required to run the  ");
                out.println("# current formatter.  For example iso19139.che depends on iso19139.  This means that the");
                out.println("# files in iso19139 are accessible by iso19139.che formatter.");
                out.println("# dependsOn=iso19139");
                out.println("");
                out.println("# published (true/false) - declares if the formatter should be part of public listing of the formatter.");
                out.println("published=true");
            }
        }
    }

    public String getLang(String defaultLang) {
        if (this.config.containsKey(FIXED_LANG_CONFIG_PROP)) {
            return this.config.getProperty(FIXED_LANG_CONFIG_PROP).trim();
        }
        return defaultLang;
    }

    public boolean isPublished() {
        String published = this.config.getProperty(PUBLISHED);
        return published == null || "true".equals(published);
    }

    public boolean contains(String propertyName) {
        return this.is(propertyName, true);
    }

    private boolean is(String propertyName, boolean defaultValue) {
        return Boolean.parseBoolean(this.config.getProperty(propertyName, String.valueOf(defaultValue)));
    }

    private List<String> toList(String schemasToLoad) {
        List<String> schemasToLoadList = Arrays.asList(schemasToLoad.split(","));
        ArrayList<String> tmp = new ArrayList<String>(schemasToLoadList.size());
        for (String string : schemasToLoadList) {
            tmp.add(string.trim().toLowerCase());
        }
        schemasToLoadList = tmp;
        return schemasToLoadList;
    }

    @Nonnull
    public List<String> listOfApplicableSchemas() {
        return this.toList(this.applicableSchemas());
    }

    @Nonnull
    private String applicableSchemas() {
        return this.config.getProperty(APPLICABLE_SCHEMAS, "all").toLowerCase();
    }

    @Nonnull
    public List<String> listOfSchemasToLoad() {
        return this.toList(this.schemasToLoad());
    }

    @Nonnull
    public String schemasToLoad() {
        return this.config.getProperty(SCHEMAS_TO_LOAD_PROP, "all");
    }

    @Nullable
    public String dependOn() {
        return this.config.getProperty(DEPENDS_ON, null);
    }

    public boolean loadStrings() {
        return this.contains(LOAD_STRINGS_PROP);
    }
}

