/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.services.ReadWriteController;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.processing.report.MetadataProcessingReport;
import org.fao.geonet.api.processing.report.SimpleMetadataProcessingReport;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.domain.utils.ObjectJSONUtils;
import org.fao.geonet.events.history.RecordCategoryChangeEvent;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.repository.MetadataCategoryRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api/records", "/{portal}/api/0.1/records"})
@Api(value="records", tags={"records"}, description="Metadata record operations")
@Controller(value="tagRecords")
@ReadWriteController
public class MetadataTagApi {
    public static final String API_PARAM_TAG_IDENTIFIER = "Tag identifier";
    @Autowired
    MetadataCategoryRepository categoryRepository;
    @Autowired
    DataManager dataManager;
    @Autowired
    IMetadataManager metadataManager;

    @ApiOperation(value="Get record tags", notes="Tags are used to classify information.<br/><a href='http://geonetwork-opensource.org/manuals/trunk/eng/users/user-guide/tag-information/tagging-with-categories.html'>More info</a>", nickname="getRecordTags")
    @RequestMapping(value={"/{metadataUuid}/tags"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="Record tags."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public Set<MetadataCategory> getTags(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canViewRecord(metadataUuid, request);
        return metadata.getCategories();
    }

    @ApiOperation(value="Add tags to a record", notes="", nickname="addTagsToRecord")
    @RequestMapping(value={"/{metadataUuid}/tags"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(code=201, message="Record tags added."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseBody
    public void updateTags(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Tag identifier", required=true) @RequestParam Integer[] id, @ApiParam(value="Clear all before adding new ones", required=false) @RequestParam(defaultValue="false", required=false) boolean clear, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        Set before = metadata.getCategories();
        if (clear) {
            this.metadataManager.update(metadata.getId(), entity -> entity.getCategories().clear());
        }
        Integer[] integerArray = id;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int c = integerArray[i];
            MetadataCategory category = (MetadataCategory)this.categoryRepository.findOne((Serializable)Integer.valueOf(c));
            if (category == null) {
                throw new ResourceNotFoundException(String.format("Can't assign non existing category with id '%d' to record '%s'", c, metadataUuid));
            }
            this.dataManager.setCategory(ApiUtils.createServiceContext(request), String.valueOf(metadata.getId()), String.valueOf(c));
        }
        this.dataManager.indexMetadata(String.valueOf(metadata.getId()), true, null);
        metadata = ApiUtils.canEditRecord(metadataUuid, request);
        Set after = metadata.getCategories();
        UserSession userSession = ApiUtils.getUserSession(request.getSession());
        new RecordCategoryChangeEvent(Integer.valueOf(metadata.getId()), Integer.valueOf(userSession.getUserIdAsInt()), ObjectJSONUtils.convertObjectInJsonObject((Object)before, (String)"category"), ObjectJSONUtils.convertObjectInJsonObject((Object)after, (String)"category")).publish((ApplicationContext)appContext);
    }

    @ApiOperation(value="Delete tags of a record", notes="", nickname="deleteRecordTags")
    @RequestMapping(value={"/{metadataUuid}/tags"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(code=204, message="Record tags removed."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseBody
    public void deleteTags(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Tag identifier. If none, all tags are removed.", required=false) @RequestParam(required=false) Integer[] id, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        Set before = metadata.getCategories();
        if (id == null || id.length == 0) {
            this.metadataManager.update(metadata.getId(), entity -> entity.getCategories().clear());
        }
        if (id != null) {
            Integer[] integerArray = id;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int c = integerArray[i];
                this.dataManager.unsetCategory(ApiUtils.createServiceContext(request), String.valueOf(metadata.getId()), c);
            }
        }
        this.dataManager.indexMetadata(String.valueOf(metadata.getId()), true, null);
        metadata = ApiUtils.canEditRecord(metadataUuid, request);
        Set after = metadata.getCategories();
        UserSession userSession = ApiUtils.getUserSession(request.getSession());
        new RecordCategoryChangeEvent(Integer.valueOf(metadata.getId()), Integer.valueOf(userSession.getUserIdAsInt()), ObjectJSONUtils.convertObjectInJsonObject((Object)before, (String)"category"), ObjectJSONUtils.convertObjectInJsonObject((Object)after, (String)"category")).publish((ApplicationContext)appContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Add tags to one or more records", notes="", nickname="addTagsToRecords")
    @RequestMapping(value={"/tags"}, produces={"application/json"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(code=201, message="Report about updated records."), @ApiResponse(code=403, message="Operation not allowed. Only Editors can access it.")})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseBody
    public MetadataProcessingReport updateTags(@ApiParam(value="Record UUIDs. If null current selection is used.", required=false) @RequestParam(required=false) String[] uuids, @ApiParam(value="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @ApiParam(value="Tag identifier", required=true) @RequestParam Integer[] id, @ApiParam(value="Clear all before adding new ones", required=false) @RequestParam(defaultValue="false", required=false) boolean clear, HttpServletRequest request, @ApiIgnore HttpSession session) throws Exception {
        try (SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();){
            Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, ApiUtils.getUserSession(session));
            report.setTotalRecords(records.size());
            ConfigurableApplicationContext context = ApplicationContextHolder.get();
            AccessManager accessMan = (AccessManager)context.getBean(AccessManager.class);
            MetadataRepository metadataRepository = (MetadataRepository)context.getBean(MetadataRepository.class);
            IMetadataManager metadataManager = (IMetadataManager)context.getBean(IMetadataManager.class);
            ArrayList<String> listOfUpdatedRecords = new ArrayList<String>();
            for (String uuid : records) {
                Metadata info = metadataRepository.findOneByUuid(uuid);
                Set before = info.getCategories();
                if (info == null) {
                    report.incrementNullRecords();
                } else if (!accessMan.canEdit(ApiUtils.createServiceContext(request), String.valueOf(info.getId()))) {
                    report.addNotEditableMetadataId(info.getId());
                } else {
                    if (clear) {
                        info.getCategories().clear();
                    }
                    if (id != null) {
                        Integer[] integerArray = id;
                        int n = integerArray.length;
                        for (int i = 0; i < n; ++i) {
                            int c = integerArray[i];
                            MetadataCategory category = (MetadataCategory)this.categoryRepository.findOne((Serializable)Integer.valueOf(c));
                            if (category != null) {
                                info.getCategories().add(category);
                                listOfUpdatedRecords.add(String.valueOf(info.getId()));
                                continue;
                            }
                            report.addMetadataInfos((AbstractMetadata)info, String.format("Can't assign non existing category with id '%d' to record '%s'", c, info.getUuid()));
                        }
                        metadataManager.save((AbstractMetadata)info);
                        report.incrementProcessedRecords();
                    }
                }
                info = metadataRepository.findOneByUuid(uuid);
                Set after = info.getCategories();
                UserSession userSession = ApiUtils.getUserSession(request.getSession());
                new RecordCategoryChangeEvent(Integer.valueOf(info.getId()), Integer.valueOf(userSession.getUserIdAsInt()), ObjectJSONUtils.convertObjectInJsonObject((Object)before, (String)"category"), ObjectJSONUtils.convertObjectInJsonObject((Object)after, (String)"category")).publish((ApplicationContext)context);
            }
            this.dataManager.flush();
            this.dataManager.indexMetadata(listOfUpdatedRecords);
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Delete tags to one or more records", notes="", nickname="deleteRecordsTags")
    @RequestMapping(value={"/tags"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(code=201, message="Report about removed records."), @ApiResponse(code=403, message="Operation not allowed. Only Editors can access it.")})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseBody
    public MetadataProcessingReport updateTags(@ApiParam(value="Record UUIDs. If null current selection is used.", required=false) @RequestParam(required=false) String[] uuids, @ApiParam(value="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @ApiParam(value="Tag identifier") @RequestParam Integer[] id, HttpServletRequest request, @ApiIgnore HttpSession session) throws Exception {
        try (SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();){
            Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, ApiUtils.getUserSession(session));
            report.setTotalRecords(records.size());
            ConfigurableApplicationContext context = ApplicationContextHolder.get();
            AccessManager accessMan = (AccessManager)context.getBean(AccessManager.class);
            MetadataRepository metadataRepository = (MetadataRepository)context.getBean(MetadataRepository.class);
            IMetadataManager metadataManager = (IMetadataManager)context.getBean(IMetadataManager.class);
            ArrayList listOfUpdatedRecords = new ArrayList();
            for (String uuid : records) {
                Metadata info = metadataRepository.findOneByUuid(uuid);
                Set before = info.getCategories();
                if (info == null) {
                    report.incrementNullRecords();
                } else if (!accessMan.canEdit(ApiUtils.createServiceContext(request), String.valueOf(info.getId()))) {
                    report.addNotEditableMetadataId(info.getId());
                } else {
                    info.getCategories().clear();
                    metadataManager.save((AbstractMetadata)info);
                    report.incrementProcessedRecords();
                }
                info = metadataRepository.findOneByUuid(uuid);
                Set after = info.getCategories();
                UserSession userSession = ApiUtils.getUserSession(request.getSession());
                new RecordCategoryChangeEvent(Integer.valueOf(info.getId()), Integer.valueOf(userSession.getUserIdAsInt()), ObjectJSONUtils.convertObjectInJsonObject((Object)before, (String)"category"), ObjectJSONUtils.convertObjectInJsonObject((Object)after, (String)"category")).publish((ApplicationContext)context);
            }
            this.dataManager.flush();
            this.dataManager.indexMetadata(listOfUpdatedRecords);
        }
        return report;
    }
}

