/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import java.util.ArrayList;
import java.util.List;
import org.geotools.Builder;
import org.geotools.styling.GraphicLegend;
import org.geotools.styling.Rule;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.builder.AbstractStyleBuilder;
import org.geotools.styling.builder.ExtensionSymbolizerBuilder;
import org.geotools.styling.builder.FeatureTypeStyleBuilder;
import org.geotools.styling.builder.GraphicLegendBuilder;
import org.geotools.styling.builder.LineSymbolizerBuilder;
import org.geotools.styling.builder.PointSymbolizerBuilder;
import org.geotools.styling.builder.PolygonSymbolizerBuilder;
import org.geotools.styling.builder.RasterSymbolizerBuilder;
import org.geotools.styling.builder.StyleBuilder;
import org.geotools.styling.builder.TextSymbolizerBuilder;
import org.opengis.filter.Filter;

public class RuleBuilder
extends AbstractStyleBuilder<Rule> {
    List<Symbolizer> symbolizers = new ArrayList<Symbolizer>();
    Builder<? extends Symbolizer> symbolizerBuilder;
    String name;
    String ruleAbstract;
    double minScaleDenominator;
    double maxScaleDenominator;
    Filter filter = null;
    boolean elseFilter;
    String title;
    private GraphicLegendBuilder legend = new GraphicLegendBuilder(this).unset();

    public RuleBuilder() {
        this((FeatureTypeStyleBuilder)null);
    }

    public RuleBuilder(FeatureTypeStyleBuilder parent) {
        super(parent);
        this.reset();
    }

    public RuleBuilder name(String name) {
        this.unset = false;
        this.name = name;
        return this;
    }

    public RuleBuilder title(String title) {
        this.unset = false;
        this.title = title;
        return this;
    }

    public RuleBuilder ruleAbstract(String ruleAbstract) {
        this.unset = false;
        this.ruleAbstract = ruleAbstract;
        return this;
    }

    public GraphicLegendBuilder legend() {
        this.unset = false;
        return this.legend;
    }

    public RuleBuilder min(double minScaleDenominator) {
        this.unset = false;
        if (minScaleDenominator < 0.0) {
            throw new IllegalArgumentException("Invalid min scale denominator, should be positive or 0");
        }
        this.minScaleDenominator = minScaleDenominator;
        return this;
    }

    public RuleBuilder max(double maxScaleDenominator) {
        this.unset = false;
        if (maxScaleDenominator < 0.0) {
            throw new IllegalArgumentException("Invalid max scale denominator, should be positive or 0");
        }
        this.maxScaleDenominator = maxScaleDenominator;
        return this;
    }

    public RuleBuilder elseFilter() {
        this.unset = false;
        this.elseFilter = true;
        this.filter = null;
        return this;
    }

    public RuleBuilder filter(Filter filter) {
        this.unset = false;
        this.elseFilter = false;
        this.filter = filter;
        return this;
    }

    public RuleBuilder filter(String cql) {
        this.unset = false;
        this.elseFilter = false;
        this.filter = this.cqlFilter(cql);
        return this;
    }

    public PointSymbolizerBuilder point() {
        this.unset = false;
        if (this.symbolizerBuilder != null) {
            this.symbolizers.add(this.symbolizerBuilder.build());
        }
        this.symbolizerBuilder = new PointSymbolizerBuilder(this);
        return (PointSymbolizerBuilder)this.symbolizerBuilder;
    }

    public LineSymbolizerBuilder line() {
        this.unset = false;
        if (this.symbolizerBuilder != null) {
            this.symbolizers.add(this.symbolizerBuilder.build());
        }
        this.symbolizerBuilder = new LineSymbolizerBuilder(this);
        return (LineSymbolizerBuilder)this.symbolizerBuilder;
    }

    public PolygonSymbolizerBuilder polygon() {
        this.unset = false;
        if (this.symbolizerBuilder != null) {
            this.symbolizers.add(this.symbolizerBuilder.build());
        }
        this.symbolizerBuilder = new PolygonSymbolizerBuilder(this);
        return (PolygonSymbolizerBuilder)this.symbolizerBuilder;
    }

    public TextSymbolizerBuilder text() {
        this.unset = false;
        if (this.symbolizerBuilder != null) {
            this.symbolizers.add(this.symbolizerBuilder.build());
        }
        this.symbolizerBuilder = new TextSymbolizerBuilder(this);
        return (TextSymbolizerBuilder)this.symbolizerBuilder;
    }

    public RasterSymbolizerBuilder raster() {
        this.unset = false;
        if (this.symbolizerBuilder != null) {
            this.symbolizers.add(this.symbolizerBuilder.build());
        }
        this.symbolizerBuilder = new RasterSymbolizerBuilder(this);
        return (RasterSymbolizerBuilder)this.symbolizerBuilder;
    }

    public ExtensionSymbolizerBuilder extension() {
        this.unset = false;
        if (this.symbolizerBuilder != null) {
            this.symbolizers.add(this.symbolizerBuilder.build());
        }
        this.symbolizerBuilder = new ExtensionSymbolizerBuilder(this);
        return (ExtensionSymbolizerBuilder)this.symbolizerBuilder;
    }

    @Override
    public Rule build() {
        if (this.unset) {
            return null;
        }
        if (this.symbolizerBuilder == null && this.symbolizers.size() == 0) {
            this.symbolizerBuilder = new PointSymbolizerBuilder();
        }
        if (this.symbolizerBuilder != null) {
            this.symbolizers.add(this.symbolizerBuilder.build());
        }
        Rule rule = this.sf.createRule();
        rule.setName(this.name);
        rule.setTitle(this.title);
        rule.setAbstract(this.ruleAbstract);
        rule.setMinScaleDenominator(this.minScaleDenominator);
        rule.setMaxScaleDenominator(this.maxScaleDenominator);
        rule.setFilter(this.filter);
        rule.setElseFilter(this.elseFilter);
        rule.symbolizers().addAll(this.symbolizers);
        GraphicLegend gl = this.legend.build();
        if (gl != null) {
            rule.setLegend(gl);
        }
        if (this.parent == null) {
            this.reset();
        }
        return rule;
    }

    @Override
    public RuleBuilder unset() {
        return (RuleBuilder)super.unset();
    }

    public RuleBuilder reset() {
        this.name = null;
        this.title = null;
        this.ruleAbstract = null;
        this.minScaleDenominator = 0.0;
        this.maxScaleDenominator = Double.POSITIVE_INFINITY;
        this.filter = Filter.INCLUDE;
        this.elseFilter = false;
        this.symbolizers.clear();
        this.legend.unset();
        this.unset = false;
        return this;
    }

    public RuleBuilder reset(Rule rule) {
        if (rule == null) {
            return this.unset();
        }
        this.name = rule.getName();
        this.title = rule.getTitle();
        this.ruleAbstract = rule.getAbstract();
        this.minScaleDenominator = rule.getMinScaleDenominator();
        this.maxScaleDenominator = rule.getMaxScaleDenominator();
        this.filter = rule.getFilter();
        this.elseFilter = rule.isElseFilter();
        this.symbolizers.clear();
        this.symbolizers.addAll(rule.symbolizers());
        this.symbolizerBuilder = null;
        this.unset = false;
        this.legend.reset(rule.getLegend());
        return this;
    }

    @Override
    protected void buildStyleInternal(StyleBuilder sb) {
        sb.featureTypeStyle().rule().init(this);
    }
}

