/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.repository;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fao.geonet.domain.CswCapabilitiesInfoField;

public class CswCapabilitiesInfo {
    private static final String FIELD_TITLE = "title";
    private static final String FIELD_ABSTRACT = "abstract";
    private static final String FIELD_FEES = "fees";
    private static final String FIELD_ACCESS_CONSTRAINTS = "accessConstraints";
    private final Map<String, CswCapabilitiesInfoField> _fields = new HashMap<String, CswCapabilitiesInfoField>();
    private String _langId;

    CswCapabilitiesInfo(String landId, List<CswCapabilitiesInfoField> allFieldsForLang) {
        this._langId = landId;
        for (CswCapabilitiesInfoField cswCapabilitiesInfoField : allFieldsForLang) {
            this._fields.put(cswCapabilitiesInfoField.getFieldName(), cswCapabilitiesInfoField);
        }
    }

    @Nullable
    public String getTitle() {
        String key = FIELD_TITLE;
        return this.getValue(FIELD_TITLE);
    }

    public void setTitle(@Nonnull String title) {
        this.setValue(FIELD_TITLE, title);
    }

    @Nullable
    public String getAbstract() {
        return this.getValue(FIELD_ABSTRACT);
    }

    public void setAbstract(@Nonnull String newAbstract) {
        this.setValue(FIELD_ABSTRACT, newAbstract);
    }

    @Nullable
    public String getFees() {
        return this.getValue(FIELD_FEES);
    }

    public void setFees(@Nonnull String fees) {
        this.setValue(FIELD_FEES, fees);
    }

    @Nullable
    public String getAccessConstraints() {
        return this.getValue(FIELD_ACCESS_CONSTRAINTS);
    }

    public void setAccessConstraints(@Nonnull String accessConstraints) {
        this.setValue(FIELD_ACCESS_CONSTRAINTS, accessConstraints);
    }

    @Nonnull
    public String getLangId() {
        return this._langId;
    }

    void setLangId(@Nonnull String langId) {
        this._langId = langId;
        for (CswCapabilitiesInfoField cswCapabilitiesInfoField : this._fields.values()) {
            cswCapabilitiesInfoField.setLangId(langId);
        }
    }

    private void setValue(@Nonnull String fieldTitle, @Nonnull String newValue) {
        CswCapabilitiesInfoField field = this._fields.get(fieldTitle);
        if (field == null) {
            field = new CswCapabilitiesInfoField().setFieldName(fieldTitle).setLangId(this._langId);
            this._fields.put(fieldTitle, field);
        }
        field.setValue(newValue);
    }

    @Nullable
    private String getValue(@Nonnull String key) {
        CswCapabilitiesInfoField field = this._fields.get(key);
        if (field == null) {
            return null;
        }
        return field.getValue();
    }

    public Collection<CswCapabilitiesInfoField> getFields() {
        return this._fields.values();
    }
}

