/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import bak.pcj.map.MapDefaults;
import bak.pcj.map.ObjectKeyByteChainedHashMap;
import bak.pcj.map.ObjectKeyByteMap;
import bak.pcj.map.ObjectKeyByteMapIterator;
import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;

public class LangSortField
extends SortField {
    private static final String MD_DOC_LANG_FIELD = "_docLocale";

    public LangSortField(String currentLocale) {
        super(MD_DOC_LANG_FIELD, (FieldComparatorSource)new LangFieldComparatorSource(currentLocale));
    }

    static class LangFieldComparator
    extends FieldComparator<String> {
        private ObjectKeyByteMap langCodeValue = new ObjectKeyByteChainedHashMap();
        private byte nextVal;
        private String defaultLocale;
        private byte[] values;
        private SortedDocValues currentReaderValues;
        private int bottom = -2;

        public LangFieldComparator(String currentLocale, int numHits) {
            this.values = new byte[numHits];
            this.langCodeValue.put((Object)currentLocale, (byte)1);
            this.langCodeValue.put(null, (byte)-1);
            this.nextVal = (byte)2;
            this.defaultLocale = currentLocale;
        }

        public int compare(int slot1, int slot2) {
            return this.values[slot1] - this.values[slot2];
        }

        public int compareBottom(int doc) {
            String val2 = this.readerValue(doc);
            if (this.bottom == -2) {
                if (val2 == null) {
                    return 0;
                }
                return 1;
            }
            if (val2 == null) {
                return -1;
            }
            return this.bottom - this.intValue(val2);
        }

        public void setTopValue(String value) {
        }

        public int compareTop(int doc) throws IOException {
            return -1;
        }

        public void copy(int slot, int doc) {
            String locale = this.readerValue(doc);
            this.values[slot] = this.intValue(locale);
        }

        private String readerValue(int docID) {
            int ord = this.currentReaderValues.getOrd(docID);
            if (ord < 0) {
                ord = 0;
            }
            return this.currentReaderValues.lookupOrd(ord).utf8ToString();
        }

        private byte intValue(String locale) {
            byte val = this.langCodeValue.get((Object)locale);
            if (val == MapDefaults.defaultByte()) {
                val = this.nextVal;
                this.nextVal = (byte)(this.nextVal + 1);
                this.langCodeValue.put((Object)locale, val);
            }
            return val;
        }

        public FieldComparator<String> setNextReader(AtomicReaderContext context) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getTermsIndex(context.reader(), LangSortField.MD_DOC_LANG_FIELD);
            return this;
        }

        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        public String value(int slot) {
            String lang = this.defaultLocale;
            byte val = this.values[slot];
            ObjectKeyByteMapIterator iter = this.langCodeValue.entries();
            while (iter.hasNext()) {
                iter.next();
                if (iter.getValue() != val) continue;
                if (iter.getKey() == null) break;
                lang = (String)iter.getKey();
                break;
            }
            return lang;
        }
    }

    static class LangFieldComparatorSource
    extends FieldComparatorSource {
        private String currentLocale;

        public LangFieldComparatorSource(String currentLocale) {
            this.currentLocale = currentLocale;
        }

        public FieldComparator<String> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
            return new LangFieldComparator(this.currentLocale, numHits);
        }
    }
}

