/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.ServletContext;
import org.fao.geonet.Constants;
import org.fao.geonet.util.XslUtil;
import org.fao.geonet.utils.Log;
import org.jdom.JDOMException;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.context.ConfigurableApplicationContext;

public final class JSONLocCacheLoader
implements Callable<Map<String, String>> {
    private static final List<String> files = Arrays.asList("core", "admin", "editor", "search");
    private final String langCode;
    private ConfigurableApplicationContext applicationContext;

    public JSONLocCacheLoader(ConfigurableApplicationContext context, String langCode) {
        this.langCode = langCode;
        this.applicationContext = context;
    }

    public static String cacheKey(String langCode) {
        return "json:" + langCode;
    }

    @Override
    public Map<String, String> call() throws Exception {
        HashMap<String, String> translations = new HashMap<String, String>();
        ServletContext servletContext = (ServletContext)this.applicationContext.getBean(ServletContext.class);
        String iso2letterLangCode = XslUtil.twoCharLangCode(this.langCode, "eng");
        for (String file : files) {
            URL resource = servletContext.getResource("/catalog/locales/" + iso2letterLangCode + "-" + file + ".json");
            if (resource == null) {
                resource = servletContext.getResource("/catalog/locales/en-" + file + ".json");
            }
            this.addJSONLocalizationFile(translations, resource);
        }
        return translations;
    }

    private void addJSONLocalizationFile(Map<String, String> translation, URL file) throws IOException, JDOMException {
        if (file != null) {
            try {
                JSONObject json = new JSONObject(Resources.toString((URL)file, (Charset)Constants.CHARSET));
                Iterator keys = json.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    translation.put(key, json.getString(key));
                }
            }
            catch (JSONException e) {
                Log.error((String)"geonetwork", (Object)("addJSONLocalizationFile error:" + e.getMessage()), (Throwable)e);
            }
        }
    }
}

