/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.simple;

import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.xsd.XSDElementDeclaration;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.gml2.GML;
import org.geotools.gml2.GMLConfiguration;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.gml2.simple.EnvelopeEncoder;
import org.geotools.gml2.simple.FeatureCollectionEncoderDelegate;
import org.geotools.gml2.simple.GMLDelegate;
import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryCollectionEncoder;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml2.simple.LineStringEncoder;
import org.geotools.gml2.simple.LinearRingEncoder;
import org.geotools.gml2.simple.MultiLineStringEncoder;
import org.geotools.gml2.simple.MultiPointEncoder;
import org.geotools.gml2.simple.MultiPolygonEncoder;
import org.geotools.gml2.simple.PointEncoder;
import org.geotools.gml2.simple.PolygonEncoder;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.geotools.xml.XSD;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.helpers.AttributesImpl;

public class GML2FeatureCollectionEncoderDelegate
extends FeatureCollectionEncoderDelegate {
    public GML2FeatureCollectionEncoderDelegate(SimpleFeatureCollection features, Encoder encoder) {
        super(features, encoder, new GML2Delegate(encoder));
    }

    public static class GML2Delegate
    implements GMLDelegate {
        static final QualifiedName FEATURE_MEMBER = new QualifiedName("http://www.opengis.net/gml", "featureMember", "gml");
        QualifiedName featureMember;
        private String gmlPrefix;
        private int numDecimals;

        public GML2Delegate(Encoder encoder) {
            this.gmlPrefix = encoder.getNamespaces().getPrefix("http://www.opengis.net/gml");
            this.featureMember = FEATURE_MEMBER.derive(this.gmlPrefix);
            this.numDecimals = this.getNumDecimals(encoder.getConfiguration());
        }

        private int getNumDecimals(Configuration configuration) {
            GMLConfiguration config = configuration instanceof GMLConfiguration ? (GMLConfiguration)configuration : (GMLConfiguration)configuration.getDependency(GMLConfiguration.class);
            if (config == null) {
                return 6;
            }
            return config.getNumDecimals();
        }

        @Override
        public List getFeatureProperties(SimpleFeature f, XSDElementDeclaration element, Encoder e) {
            return GML2EncodingUtils.AbstractFeatureType_getProperties(f, element, e.getSchemaIndex(), new HashSet<String>(Arrays.asList("name", "description", "boundedBy")), e.getConfiguration());
        }

        @Override
        public EnvelopeEncoder createEnvelopeEncoder(Encoder e) {
            return new EnvelopeEncoder(e, this.gmlPrefix);
        }

        @Override
        public void initFidAttribute(AttributesImpl atts) {
            atts.addAttribute(null, "fid", "fid", null, "");
        }

        @Override
        public void startFeatures(GMLWriter handler) {
        }

        @Override
        public void startFeature(GMLWriter handler) throws Exception {
            handler.startElement(FEATURE_MEMBER, null);
        }

        @Override
        public void endFeature(GMLWriter handler) throws Exception {
            handler.endElement(FEATURE_MEMBER);
        }

        @Override
        public void endFeatures(GMLWriter handler) {
        }

        @Override
        public void setSrsNameAttribute(AttributesImpl atts, CoordinateReferenceSystem crs) {
            atts.addAttribute(null, "srsName", "srsName", null, GML2EncodingUtils.toURI(crs, true));
        }

        @Override
        public void setGeometryDimensionAttribute(AttributesImpl srsatts, int dimension) {
        }

        @Override
        public void registerGeometryEncoders(Map<Class, GeometryEncoder> encoders, Encoder encoder) {
            encoders.put(Point.class, new PointEncoder(encoder, this.gmlPrefix));
            encoders.put(MultiPoint.class, new MultiPointEncoder(encoder, this.gmlPrefix));
            encoders.put(LineString.class, new LineStringEncoder(encoder, this.gmlPrefix));
            encoders.put(LinearRing.class, new LinearRingEncoder(encoder, this.gmlPrefix));
            encoders.put(MultiLineString.class, new MultiLineStringEncoder(encoder, this.gmlPrefix));
            encoders.put(Polygon.class, new PolygonEncoder(encoder, this.gmlPrefix));
            encoders.put(MultiPolygon.class, new MultiPolygonEncoder(encoder, this.gmlPrefix));
            encoders.put(GeometryCollection.class, new GeometryCollectionEncoder(encoder, this.gmlPrefix));
        }

        @Override
        public String getGmlPrefix() throws Exception {
            return this.gmlPrefix;
        }

        @Override
        public boolean supportsTuples() {
            return false;
        }

        @Override
        public void startTuple(GMLWriter output) {
        }

        @Override
        public void endTuple(GMLWriter output) {
        }

        @Override
        public XSD getSchema() {
            return GML.getInstance();
        }

        @Override
        public int getNumDecimals() {
            return this.numDecimals;
        }

        @Override
        public boolean forceDecimalEncoding() {
            return true;
        }
    }
}

