/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.TestAutoregister;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.postgis.Geometry;
import org.postgis.PGgeometry;
import org.postgis.binary.BinaryParser;
import org.postgis.binary.BinaryWriter;
import org.postgresql.util.PGtokenizer;

public class TestParser {
    public static String ALL = "ALL";
    public static String ONLY10 = "ONLY10";
    public static String EQUAL10 = "EQUAL10";
    public static final String[][] testset = new String[][]{{ALL, "POINT(10 10)"}, {ALL, "POINT(10 10 0)"}, {ALL, "POINT(10 10 20)"}, {ALL, "POINT(1e100 1.2345e-100 -2e-5)"}, {ONLY10, "POINTM(10 10 20)"}, {ONLY10, "POINT(10 10 20 30)"}, {ALL, "MULTIPOINT(11 12, 20 20)"}, {ALL, "MULTIPOINT(11 12 13, 20 20 20)"}, {ONLY10, "MULTIPOINTM(11 12 13, 20 20 20)"}, {ONLY10, "MULTIPOINT(11 12 13 14,20 20 20 20)"}, {ALL, "MULTIPOINT((11 12), (20 20))"}, {ALL, "MULTIPOINT((11 12 13), (20 20 20))"}, {ONLY10, "MULTIPOINTM((11 12 13), (20 20 20))"}, {ONLY10, "MULTIPOINT((11 12 13 14),(20 20 20 20))"}, {ALL, "LINESTRING(10 10,20 20,50 50,34 34)"}, {ALL, "LINESTRING(10 10 20,20 20 20,50 50 50,34 34 34)"}, {ONLY10, "LINESTRINGM(10 10 20,20 20 20,50 50 50,34 34 34)"}, {ONLY10, "LINESTRING(10 10 20 20,20 20 20 20,50 50 50 50,34 34 34 50)"}, {ALL, "POLYGON((10 10,20 10,20 20,20 10,10 10),(5 5,5 6,6 6,6 5,5 5))"}, {ALL, "POLYGON((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0))"}, {ONLY10, "POLYGONM((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0))"}, {ONLY10, "POLYGON((10 10 0 7,20 10 0 7,20 20 0 7,20 10 0 7,10 10 0 7),(5 5 0 7,5 6 0 7,6 6 0 7,6 5 0 7,5 5 0 7))"}, {ALL, "MULTIPOLYGON(((10 10,20 10,20 20,20 10,10 10),(5 5,5 6,6 6,6 5,5 5)),((10 10,20 10,20 20,20 10,10 10),(5 5,5 6,6 6,6 5,5 5)))"}, {ALL, "MULTIPOLYGON(((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)),((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)))"}, {ONLY10, "MULTIPOLYGONM(((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)),((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)))"}, {ONLY10, "MULTIPOLYGON(((10 10 0 7,20 10 0 7,20 20 0 7,20 10 0 7,10 10 0 7),(5 5 0 7,5 6 0 7,6 6 0 7,6 5 0 7,5 5 0 7)),((10 10 0 7,20 10 0 7,20 20 0 7,20 10 0 7,10 10 0 7),(5 5 0 7,5 6 0 7,6 6 0 7,6 5 0 7,5 5 0 7)))"}, {ALL, "MULTILINESTRING((10 10,20 10,20 20,20 10,10 10),(5 5,5 6,6 6,6 5,5 5))"}, {ALL, "MULTILINESTRING((10 10 5,20 10 5,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0))"}, {ONLY10, "MULTILINESTRINGM((10 10 7,20 10 7,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0))"}, {ONLY10, "MULTILINESTRING((10 10 0 7,20 10 0 7,20 20 0 7,20 10 0 7,10 10 0 7),(5 5 0 7,5 6 0 7,6 6 0 7,6 5 0 7,5 5 0 7))"}, {ALL, "GEOMETRYCOLLECTION(POINT(10 10),POINT(20 20))"}, {ALL, "GEOMETRYCOLLECTION(POINT(10 10 20),POINT(20 20 20))"}, {ONLY10, "GEOMETRYCOLLECTIONM(POINT(10 10 20),POINT(20 20 20))"}, {ONLY10, "GEOMETRYCOLLECTION(POINT(10 10 20 7),POINT(20 20 20 7))"}, {ALL, "GEOMETRYCOLLECTION(LINESTRING(10 10 20,20 20 20, 50 50 50, 34 34 34),LINESTRING(10 10 20,20 20 20, 50 50 50, 34 34 34))"}, {ALL, "GEOMETRYCOLLECTION(POLYGON((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)),POLYGON((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)))"}, {ONLY10, "GEOMETRYCOLLECTION(MULTIPOINT(10 10 10, 20 20 20),MULTIPOINT(10 10 10, 20 20 20))"}, {ONLY10, "GEOMETRYCOLLECTION(MULTIPOINT((10 10 10), (20 20 20)),MULTIPOINT((10 10 10), (20 20 20)))"}, {EQUAL10, "GEOMETRYCOLLECTION(MULTILINESTRING((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)))"}, {EQUAL10, "GEOMETRYCOLLECTION(MULTIPOLYGON(((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)),((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0))),MULTIPOLYGON(((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)),((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0))))"}, {ALL, "GEOMETRYCOLLECTION(POINT(10 10 20),LINESTRING(10 10 20,20 20 20, 50 50 50, 34 34 34),POLYGON((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)))"}, {ONLY10, "GEOMETRYCOLLECTION(POINT(10 10 20),MULTIPOINT(10 10 10, 20 20 20),LINESTRING(10 10 20,20 20 20, 50 50 50, 34 34 34),POLYGON((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)),MULTIPOLYGON(((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)),((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0))),MULTILINESTRING((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)))"}, {ONLY10, "GEOMETRYCOLLECTION(POINT(10 10 20),MULTIPOINT((10 10 10), (20 20 20)),LINESTRING(10 10 20,20 20 20, 50 50 50, 34 34 34),POLYGON((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)),MULTIPOLYGON(((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)),((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0))),MULTILINESTRING((10 10 0,20 10 0,20 20 0,20 10 0,10 10 0),(5 5 0,5 6 0,6 6 0,6 5 0,5 5 0)))"}, {ALL, "GEOMETRYCOLLECTION(EMPTY)"}, {ALL, "GEOMETRYCOLLECTION EMPTY"}, {ONLY10, "POINT EMPTY"}, {ONLY10, "LINESTRING EMPTY"}, {ONLY10, "POLYGON EMPTY"}, {ONLY10, "MULTIPOINT EMPTY"}, {ONLY10, "MULTILINESTRING EMPTY"}, {ONLY10, "MULTIPOLYGON EMPTY"}};
    public static final int SRID = 4326;
    public static final String SRIDPREFIX = "SRID=4326;";
    public static int failcount = 0;
    private static BinaryParser bp = new BinaryParser();
    private static final BinaryWriter bw = new BinaryWriter();

    public static void test(String WKT, Connection[] conns, String flags) throws SQLException {
        System.out.println("Original:  " + WKT);
        Geometry geom = PGgeometry.geomFromString(WKT);
        String parsed = geom.toString();
        System.out.println("Parsed:    " + parsed);
        Geometry regeom = PGgeometry.geomFromString(parsed);
        String reparsed = regeom.toString();
        System.out.println("Re-Parsed: " + reparsed);
        if (!geom.equals(regeom)) {
            System.out.println("--- Geometries are not equal!");
            ++failcount;
        } else if (!reparsed.equals(parsed)) {
            System.out.println("--- Text Reps are not equal!");
            ++failcount;
        } else {
            System.out.println("Equals:    yes");
        }
        String hexNWKT = bw.writeHexed(regeom, (byte)1);
        System.out.println("NDRHex:    " + hexNWKT);
        regeom = PGgeometry.geomFromString(hexNWKT);
        System.out.println("ReNDRHex:  " + regeom.toString());
        if (!geom.equals(regeom)) {
            System.out.println("--- Geometries are not equal!");
            ++failcount;
        } else {
            System.out.println("Equals:    yes");
        }
        String hexXWKT = bw.writeHexed(regeom, (byte)0);
        System.out.println("XDRHex:    " + hexXWKT);
        regeom = PGgeometry.geomFromString(hexXWKT);
        System.out.println("ReXDRHex:  " + regeom.toString());
        if (!geom.equals(regeom)) {
            System.out.println("--- Geometries are not equal!");
            ++failcount;
        } else {
            System.out.println("Equals:    yes");
        }
        byte[] NWKT = bw.writeBinary(regeom, (byte)1);
        regeom = bp.parse(NWKT);
        System.out.println("NDR:       " + regeom.toString());
        if (!geom.equals(regeom)) {
            System.out.println("--- Geometries are not equal!");
            ++failcount;
        } else {
            System.out.println("Equals:    yes");
        }
        byte[] XWKT = bw.writeBinary(regeom, (byte)0);
        regeom = bp.parse(XWKT);
        System.out.println("XDR:       " + regeom.toString());
        if (!geom.equals(regeom)) {
            System.out.println("--- Geometries are not equal!");
            ++failcount;
        } else {
            System.out.println("Equals:    yes");
        }
        for (int i = 0; i < conns.length; ++i) {
            Connection connection = conns[i];
            Statement statement = connection.createStatement();
            int serverPostgisMajor = TestAutoregister.getPostgisMajor(statement);
            if (flags == ONLY10 && serverPostgisMajor < 1) {
                System.out.println("PostGIS server too old, skipping test on connection " + i + ": " + connection.getCatalog());
            } else {
                Geometry sqlreGeom;
                Geometry sqlGeom;
                System.out.println("Testing on connection " + i + ": " + connection.getCatalog());
                try {
                    sqlGeom = TestParser.viaSQL(WKT, statement);
                    System.out.println("SQLin    : " + sqlGeom.toString());
                    if (!geom.equals(sqlGeom)) {
                        System.out.println("--- Geometries after SQL are not equal!");
                        if (flags == EQUAL10 && serverPostgisMajor < 1) {
                            System.out.println("--- This is expected with PostGIS " + serverPostgisMajor + ".X");
                        } else {
                            ++failcount;
                        }
                    } else {
                        System.out.println("Eq SQL in: yes");
                    }
                }
                catch (SQLException e) {
                    System.out.println("--- Server side error: " + e.toString());
                    ++failcount;
                }
                try {
                    sqlreGeom = TestParser.viaSQL(parsed, statement);
                    System.out.println("SQLout  :  " + sqlreGeom.toString());
                    if (!geom.equals(sqlreGeom)) {
                        System.out.println("--- reparsed Geometries after SQL are not equal!");
                        if (flags == EQUAL10 && serverPostgisMajor < 1) {
                            System.out.println("--- This is expected with PostGIS " + serverPostgisMajor + ".X");
                        } else {
                            ++failcount;
                        }
                    } else {
                        System.out.println("Eq SQLout: yes");
                    }
                }
                catch (SQLException e) {
                    System.out.println("--- Server side error: " + e.toString());
                    ++failcount;
                }
                try {
                    sqlreGeom = TestParser.viaPrepSQL(geom, connection);
                    System.out.println("Prepared:  " + sqlreGeom.toString());
                    if (!geom.equals(sqlreGeom)) {
                        System.out.println("--- reparsed Geometries after prepared StatementSQL are not equal!");
                        if (flags == EQUAL10 && serverPostgisMajor < 1) {
                            System.out.println("--- This is expected with PostGIS " + serverPostgisMajor + ".X");
                        } else {
                            ++failcount;
                        }
                    } else {
                        System.out.println("Eq Prep: yes");
                    }
                }
                catch (SQLException e) {
                    System.out.println("--- Server side error: " + e.toString());
                    ++failcount;
                }
                try {
                    if (serverPostgisMajor >= 1) {
                        sqlGeom = TestParser.ewktViaSQL(WKT, statement);
                        System.out.println("asEWKT   : " + sqlGeom.toString());
                        if (!geom.equals(sqlGeom)) {
                            System.out.println("--- Geometries after EWKT SQL are not equal!");
                            ++failcount;
                        } else {
                            System.out.println("equal   : yes");
                        }
                    }
                }
                catch (SQLException e) {
                    System.out.println("--- Server side error: " + e.toString());
                    ++failcount;
                }
                try {
                    if (serverPostgisMajor >= 1) {
                        sqlGeom = TestParser.ewkbViaSQL(WKT, statement);
                        System.out.println("asEWKB   : " + sqlGeom.toString());
                        if (!geom.equals(sqlGeom)) {
                            System.out.println("--- Geometries after EWKB SQL are not equal!");
                            ++failcount;
                        } else {
                            System.out.println("equal    : yes");
                        }
                    }
                }
                catch (SQLException e) {
                    System.out.println("--- Server side error: " + e.toString());
                    ++failcount;
                }
                try {
                    if (serverPostgisMajor >= 1) {
                        sqlGeom = TestParser.viaSQL(hexNWKT, statement);
                        System.out.println("hexNWKT:   " + sqlGeom.toString());
                        if (!geom.equals(sqlGeom)) {
                            System.out.println("--- Geometries after EWKB SQL are not equal!");
                            ++failcount;
                        } else {
                            System.out.println("equal    : yes");
                        }
                    }
                }
                catch (SQLException e) {
                    System.out.println("--- Server side error: " + e.toString());
                    ++failcount;
                }
                try {
                    if (serverPostgisMajor >= 1) {
                        sqlGeom = TestParser.viaSQL(hexXWKT, statement);
                        System.out.println("hexXWKT:   " + sqlGeom.toString());
                        if (!geom.equals(sqlGeom)) {
                            System.out.println("--- Geometries after EWKB SQL are not equal!");
                            ++failcount;
                        } else {
                            System.out.println("equal    : yes");
                        }
                    }
                }
                catch (SQLException e) {
                    System.out.println("--- Server side error: " + e.toString());
                    ++failcount;
                }
                try {
                    if (serverPostgisMajor >= 1) {
                        sqlGeom = TestParser.binaryViaSQL(NWKT, connection);
                        System.out.println("NWKT:      " + sqlGeom.toString());
                        if (!geom.equals(sqlGeom)) {
                            System.out.println("--- Geometries after EWKB SQL are not equal!");
                            ++failcount;
                        } else {
                            System.out.println("equal    : yes");
                        }
                    }
                }
                catch (SQLException e) {
                    System.out.println("--- Server side error: " + e.toString());
                    ++failcount;
                }
                try {
                    if (serverPostgisMajor >= 1) {
                        sqlGeom = TestParser.binaryViaSQL(XWKT, connection);
                        System.out.println("XWKT:      " + sqlGeom.toString());
                        if (!geom.equals(sqlGeom)) {
                            System.out.println("--- Geometries after EWKB SQL are not equal!");
                            ++failcount;
                        } else {
                            System.out.println("equal    : yes");
                        }
                    }
                }
                catch (SQLException e) {
                    System.out.println("--- Server side error: " + e.toString());
                    ++failcount;
                }
            }
            statement.close();
        }
        System.out.println("***");
    }

    private static Geometry viaSQL(String rep, Statement stat) throws SQLException {
        ResultSet rs = stat.executeQuery("SELECT geometry_in('" + rep + "')");
        rs.next();
        return ((PGgeometry)((Object)rs.getObject(1))).getGeometry();
    }

    private static Geometry viaPrepSQL(Geometry geom, Connection conn) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("SELECT ?::geometry");
        PGgeometry wrapper = new PGgeometry(geom);
        prep.setObject(1, (Object)wrapper, 1111);
        ResultSet rs = prep.executeQuery();
        rs.next();
        PGgeometry resultwrapper = (PGgeometry)((Object)rs.getObject(1));
        return resultwrapper.getGeometry();
    }

    private static Geometry ewktViaSQL(String rep, Statement stat) throws SQLException {
        ResultSet rs = stat.executeQuery("SELECT asEWKT(geometry_in('" + rep + "'))");
        rs.next();
        String resrep = rs.getString(1);
        return PGgeometry.geomFromString(resrep);
    }

    private static Geometry ewkbViaSQL(String rep, Statement stat) throws SQLException {
        ResultSet rs = stat.executeQuery("SELECT asEWKB(geometry_in('" + rep + "'))");
        rs.next();
        byte[] resrep = rs.getBytes(1);
        return bp.parse(resrep);
    }

    private static Geometry binaryViaSQL(byte[] rep, Connection conn) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("SELECT ?::bytea::geometry");
        prep.setBytes(1, rep);
        ResultSet rs = prep.executeQuery();
        rs.next();
        PGgeometry resultwrapper = (PGgeometry)((Object)rs.getObject(1));
        return resultwrapper.getGeometry();
    }

    public static Connection connect(String url, String dbuser, String dbpass) throws SQLException {
        Connection conn = DriverManager.getConnection(url, dbuser, dbpass);
        return conn;
    }

    public static void loadDrivers() throws ClassNotFoundException {
        Class.forName("org.postgis.DriverWrapper");
        Class.forName("org.postgis.DriverWrapperAutoprobe");
    }

    public static void main(String[] args) throws SQLException, ClassNotFoundException {
        int i;
        PGtokenizer dburls;
        TestParser.loadDrivers();
        String dbuser = null;
        String dbpass = null;
        if (args.length == 1 && args[0].equalsIgnoreCase("offline")) {
            System.out.println("Performing only offline tests");
            dburls = new PGtokenizer("", ';');
        } else if (args.length == 3) {
            System.out.println("Performing offline and online tests");
            dburls = new PGtokenizer(args[0], ';');
            dbuser = args[1];
            dbpass = args[2];
        } else {
            System.err.println("Usage: java examples/TestParser dburls user pass");
            System.err.println("   or: java examples/TestParser offline");
            System.err.println();
            System.err.println("dburls has one or more jdbc urls separated by ; in the following format");
            System.err.println("jdbc:postgresql://HOST:PORT/DATABASENAME");
            System.exit(1);
            return;
        }
        Connection[] conns = new Connection[dburls.getSize()];
        for (i = 0; i < dburls.getSize(); ++i) {
            System.out.println("Creating JDBC connection to " + dburls.getToken(i));
            conns[i] = TestParser.connect(dburls.getToken(i), dbuser, dbpass);
        }
        System.out.println("Performing tests...");
        System.out.println("***");
        for (i = 0; i < testset.length; ++i) {
            TestParser.test(testset[i][1], conns, testset[i][0]);
            TestParser.test(SRIDPREFIX + testset[i][1], conns, testset[i][0]);
        }
        System.out.print("cleaning up...");
        for (i = 0; i < conns.length; ++i) {
            conns[i].close();
        }
        System.out.println("Finished, " + failcount + " tests failed!");
        System.err.println("Finished, " + failcount + " tests failed!");
        System.exit(failcount);
    }
}

