/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.HashMap;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.language.groovy.GroovyLanguage;
import org.apache.camel.support.ExpressionSupport;
import org.apache.camel.util.ExchangeHelper;

public class GroovyExpression
extends ExpressionSupport {
    private final String text;

    public GroovyExpression(String text) {
        this.text = text;
    }

    public String toString() {
        return "groovy: " + this.text;
    }

    protected String assertionFailureMessage(Exchange exchange) {
        return "groovy: " + this.text;
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        Script script = this.instantiateScript(exchange);
        script.setBinding(this.createBinding(exchange));
        Object value = script.run();
        return (T)exchange.getContext().getTypeConverter().convertTo(type, value);
    }

    private Script instantiateScript(Exchange exchange) {
        GroovyLanguage language = (GroovyLanguage)exchange.getContext().resolveLanguage("groovy");
        Class scriptClass = language.getScriptFromCache(this.text);
        if (scriptClass == null) {
            ClassLoader cl = exchange.getContext().getApplicationContextClassLoader();
            GroovyShell shell = cl != null ? new GroovyShell(cl) : new GroovyShell();
            scriptClass = shell.getClassLoader().parseClass(this.text);
            language.addScriptToCache(this.text, scriptClass);
        }
        try {
            return scriptClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    private Binding createBinding(Exchange exchange) {
        HashMap variables = new HashMap();
        ExchangeHelper.populateVariableMap((Exchange)exchange, variables);
        return new Binding(variables);
    }
}

