/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.fes20;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MatchActionType implements Enumerator
{
    ALL(0, "All", "All"),
    ANY(1, "Any", "Any"),
    ONE(2, "One", "One");

    public static final int ALL_VALUE = 0;
    public static final int ANY_VALUE = 1;
    public static final int ONE_VALUE = 2;
    private static final MatchActionType[] VALUES_ARRAY;
    public static final List<MatchActionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static MatchActionType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            MatchActionType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static MatchActionType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            MatchActionType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static MatchActionType get(int value) {
        switch (value) {
            case 0: {
                return ALL;
            }
            case 1: {
                return ANY;
            }
            case 2: {
                return ONE;
            }
        }
        return null;
    }

    private MatchActionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new MatchActionType[]{ALL, ANY, ONE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

