/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.log;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.es.EsClient;
import org.fao.geonet.kernel.search.log.LuceneQueryParamType;
import org.fao.geonet.kernel.search.log.SearchRequestParam;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class QueryRequest {
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String QUERY_TYPE_MDS = "service";
    public static final String QUERY_TYPE_MDD = "dataset";
    public static final String QUERY_TYPE_GEO = "basicgeodata";
    public static final String QUERY_TYPE_ALL = "all";
    int requestId;
    private List<SearchRequestParam> queryInfos;
    private Date date;
    private String formattedDate;
    private String ip;
    private String luceneQuery;
    private Integer hits;
    private String language;
    private String sortBy;
    private String spatialFilter;
    private LuceneQueryParamType mdType;
    private String service;
    @Deprecated
    private boolean simpleQuery;
    @Deprecated
    private boolean autoGenQuery;
    @Autowired
    private EsClient client;

    public QueryRequest(String ip, long queryDate) {
        this.ip = ip;
        this.date = new Date(queryDate);
        this.formattedDate = new SimpleDateFormat(DATE_FORMAT).format(this.date);
        this.mdType = LuceneQueryParamType.MATCH_ALL_DOCS;
        try {
            this.client = (EsClient)ApplicationContextHolder.get().getBean(EsClient.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            Log.debug((String)"geonetwork.search-logger", (Object)"No Elasticsearch client defined. If using maven use '-Des.spring.profile=es' option.");
        }
    }

    public void setQueryInfos(@Nonnull List<SearchRequestParam> queryInfos) {
        Assert.isTrue((queryInfos != null ? 1 : 0) != 0);
        this.queryInfos = queryInfos;
        for (SearchRequestParam qi : queryInfos) {
            Assert.isTrue((qi != null ? 1 : 0) != 0);
            LuceneQueryParamType t = qi.getQueryType();
            if (t == null) continue;
            this.mdType = t;
            break;
        }
    }

    public Date getDate() {
        return (Date)this.date.clone();
    }

    public void setDate(Date date) {
        this.date = (Date)date.clone();
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getLuceneQuery() {
        return this.luceneQuery;
    }

    public void setLuceneQuery(String luceneQuery) {
        this.luceneQuery = luceneQuery;
    }

    public Integer getHits() {
        return this.hits;
    }

    public void setHits(Integer hits) {
        this.hits = hits;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public String getSpatialFilter() {
        return this.spatialFilter;
    }

    public void setSpatialFilter(String spatialFilter) {
        this.spatialFilter = spatialFilter;
    }

    public String getFormattedDate() {
        return this.formattedDate;
    }

    public void setFormattedDate(String formattedDate) {
        this.formattedDate = formattedDate;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public boolean getAutoGeneratedQuery() {
        return this.autoGenQuery;
    }

    public void setAutoGeneratedQuery(boolean autoGenQuery) {
        this.autoGenQuery = autoGenQuery;
    }

    public boolean isSimpleQuery() {
        this.simpleQuery = false;
        if (this.queryInfos != null) {
            this.simpleQuery = true;
            for (SearchRequestParam qi : this.queryInfos) {
                if (LuceneQueryParamType.MATCH_ALL_DOCS != qi.getQueryType() && ("any".equals(qi.getTermField()) || "type".equals(qi.getTermField()) || "_owner".equals(qi.getTermField()) || qi.getTermField().contains("_op") || "_isTemplate".equals(qi.getTermField()) || "_locale".equals(qi.getTermField()))) continue;
                this.simpleQuery = false;
                break;
            }
        }
        return this.simpleQuery;
    }

    public boolean storeToEs(String index, String indexType) {
        if (this.client == null) {
            Log.debug((String)"geonetwork.search-logger", (Object)"No Elasticsearch instance to log search in.");
            return false;
        }
        HashMap<String, String> listOfDocumentsToIndex = new HashMap<String, String>();
        ObjectMapper mapper = new ObjectMapper();
        try {
            String id = UUID.randomUUID().toString();
            ObjectNode doc = mapper.createObjectNode();
            long time = this.date.getTime();
            doc.put("id", id);
            doc.put("documentType", "request");
            doc.put("timestamp", time);
            doc.put("host", this.ip);
            doc.put("path", this.service);
            doc.put("hits", this.hits);
            doc.put("language", this.language);
            doc.put("query", this.luceneQuery);
            doc.put("recordType", this.mdType.name());
            doc.put("sortBy", this.sortBy);
            doc.put("spatialFilter", this.spatialFilter);
            listOfDocumentsToIndex.put(id, mapper.writeValueAsString((Object)doc));
            List<SearchRequestParam> queryInfos = this.queryInfos;
            int[] i = new int[]{0};
            queryInfos.forEach(q -> {
                ObjectNode paramsDoc = mapper.createObjectNode();
                String type = "searchParam";
                i[0] = i[0] + 1;
                String pId = id + type + i[0];
                paramsDoc.put("id", pId);
                paramsDoc.put("documentType", type);
                paramsDoc.put("timestamp", time);
                paramsDoc.put("field", q.getTermField());
                paramsDoc.put("fieldValue", q.getTermText());
                paramsDoc.put("similarity", q.getSimilarity());
                paramsDoc.put("fieldLowerValue", q.getLowerText());
                paramsDoc.put("fieldUpperValue", q.getUpperText());
                paramsDoc.put("inclusive", q.isInclusive());
                try {
                    listOfDocumentsToIndex.put(pId, mapper.writeValueAsString((Object)paramsDoc));
                }
                catch (JsonProcessingException e) {
                    Log.debug((String)"geonetwork.search-logger", (Object)String.format("Error occured while building search requests: %s", e.getMessage()));
                }
            });
            listOfDocumentsToIndex.put(id, mapper.writeValueAsString((Object)doc));
            this.client = (EsClient)ApplicationContextHolder.get().getBean(EsClient.class);
            this.client.bulkRequest(index, listOfDocumentsToIndex);
        }
        catch (JsonProcessingException e) {
            Log.debug((String)"geonetwork.search-logger", (Object)String.format("Error occured while building JSON for search requests: %s", e.getMessage()));
            return false;
        }
        catch (Exception e) {
            Log.debug((String)"geonetwork.search-logger", (Object)String.format("Error occured while sending search requests to index: %s", e.getMessage()));
            return false;
        }
        return true;
    }
}

